/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.directaccess.fritz;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;
import yajhfc.model.FmtItemList;
import yajhfc.model.RecvFormat;
import yajhfc.model.TableType;
import yajhfc.model.jobq.HylaDirAccessor;
import yajhfc.model.servconn.FaxListConnection;
import yajhfc.model.servconn.directaccess.DirectAccessFaxJob;
import yajhfc.model.servconn.directaccess.DirectAccessFaxJobList;
import yajhfc.model.servconn.directaccess.fritz.FritzFaxJob;
import yajhfc.model.servconn.directaccess.fritz.FritzFaxListConnection;
import yajhfc.server.ServerOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FritzFaxList
extends DirectAccessFaxJobList<RecvFormat> {
    public static final String DEFAULT_FAX_DATE_FORMAT = "dd.MM.yy_HH.mm";
    public static final String DEFAULT_FAX_PATTERN = "(\\d{2}\\.\\d{2}\\.\\d{2}_(?:\\d{2}\\.){1,2}\\d{2})\\_Telefax\\.(.+)\\.pdf";
    protected static final int GROUP_DATE_TIME = 1;
    protected static final int GROUP_SENDER = 2;
    protected Pattern faxPattern;
    protected DateFormat faxDateFormat;

    public FritzFaxList(FaxListConnection faxListConnection, FmtItemList<RecvFormat> fmtItemList, ServerOptions serverOptions, String string, String string2, String string3) {
        super(faxListConnection, fmtItemList, serverOptions, string);
        this.faxPattern = Pattern.compile(string2, 2);
        this.faxDateFormat = new SimpleDateFormat(string3);
    }

    @Override
    public void reloadSettings(ServerOptions serverOptions) {
    }

    @Override
    public TableType getJobType() {
        return TableType.RECEIVED;
    }

    @Override
    protected DirectAccessFaxJob<RecvFormat> createJob(String string) throws IOException {
        return new FritzFaxJob(this, string, string);
    }

    @Override
    protected String[] translateDirectoryEntries(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            String string2 = string.toLowerCase();
            if (!string2.contains("fax") || !string2.endsWith(".pdf")) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public HylaDirAccessor getDirAccessor() {
        return ((FritzFaxListConnection)this.parent).getDirAccessor();
    }

    public Pattern getFaxPattern() {
        return this.faxPattern;
    }

    public void setFaxPattern(Pattern pattern) {
        this.faxPattern = pattern;
    }

    public DateFormat getFaxDateFormat() {
        return this.faxDateFormat;
    }

    public void setFaxDateFormat(DateFormat dateFormat) {
        this.faxDateFormat = dateFormat;
    }
}

