/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.directaccess.jobq;

import gnu.inet.ftp.ServerResponseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.file.FileFormat;
import yajhfc.model.jobq.HylaDirAccessor;
import yajhfc.model.jobq.QueueFileFormat;
import yajhfc.model.servconn.FaxDocument;
import yajhfc.model.servconn.JobState;
import yajhfc.model.servconn.directaccess.DirectAccessFaxDoc;
import yajhfc.model.servconn.directaccess.DirectAccessFaxJob;
import yajhfc.model.servconn.directaccess.jobq.JobPropToQueueAndJobFmtMapping;
import yajhfc.model.servconn.directaccess.jobq.JobQueueFaxJobList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobQueueFaxJob
extends DirectAccessFaxJob<QueueFileFormat> {
    static final Logger log = Logger.getLogger(JobQueueFaxJob.class.getName());
    protected static final Map<String, FileFormat> fileEntries = new HashMap<String, FileFormat>();

    protected JobQueueFaxJob(JobQueueFaxJobList jobQueueFaxJobList, String string, String string2) throws IOException {
        super(jobQueueFaxJobList, string, string2);
    }

    @Override
    protected JobState calculateJobState() {
        String string = this.getRawData(QueueFileFormat.state);
        if (string == null || string.length() < 1) {
            return JobState.UNDEFINED;
        }
        return JobState.getJobStateFromQueueCode(string.charAt(0) - 48);
    }

    public Map<String, int[]> getDesiredItems() {
        return ((JobQueueFaxJobList)this.parent).desiredItems;
    }

    @Override
    public void delete() throws IOException, ServerResponseException {
        this.getDirAccessor().deleteFile("doneq/q" + this.jobID);
    }

    @Override
    protected Object parseValue(QueueFileFormat queueFileFormat, String string) {
        if (queueFileFormat.getDataType() == Boolean.class) {
            if (string == null || string.length() == 0) {
                return Boolean.FALSE;
            }
            try {
                return Integer.parseInt(string) != 0;
            }
            catch (NumberFormatException numberFormatException) {
                log.log(Level.INFO, "Invalid number for Boolean col " + queueFileFormat + ": " + string, numberFormatException);
                return Boolean.FALSE;
            }
        }
        return super.parseValue(queueFileFormat, string);
    }

    @Override
    public FaxDocument getCommunicationsLog() throws IOException {
        String string = (String)this.getData(QueueFileFormat.commid);
        if (Utils.debugMode) {
            log.fine(this.jobID + ": has CommID: " + string);
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = this.getLogFileName(string);
        if (Utils.debugMode) {
            log.fine(this.jobID + ": returning filename: " + string2);
        }
        return new DirectAccessFaxDoc<QueueFileFormat>(this, string2, FileFormat.PlainText);
    }

    protected String getLogFileName(String string) {
        return "log/c" + string;
    }

    @Override
    public Map<String, String> getJobProperties(String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            HashMap<String, int[]> hashMap2 = new HashMap<String, int[]>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                hashMap2.put(JobPropToQueueAndJobFmtMapping.getMappingFor((String)stringArray[i]).queueFormat.getHylaFmt(), new int[]{i});
            }
            String[] stringArray2 = this.readSpoolFile(this.getDirAccessor(), hashMap2, stringArray.length, false);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray2[i] == null) continue;
                hashMap.put(stringArray[i], stringArray2[i]);
            }
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, "Error retrieving the job properties", iOException);
        }
        return hashMap;
    }

    protected String translateFileName(String string) {
        return string;
    }

    @Override
    protected void readSpoolFile(HylaDirAccessor hylaDirAccessor) throws IOException {
        String[] stringArray = this.readSpoolFile(hylaDirAccessor, this.getDesiredItems(), this.parent.getColumns().getCompleteView().size(), true);
        if (Utils.debugMode) {
            log.finer(this.jobID + ": calculated documents: " + this.documents);
        }
        this.reloadData(stringArray);
    }

    protected String[] readSpoolFile(HylaDirAccessor hylaDirAccessor, Map<String, int[]> map, int n, boolean bl) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(hylaDirAccessor.getInputReader(this.fileName));
        String[] stringArray = new String[n];
        if (bl) {
            this.documents.clear();
        }
        StringBuilder stringBuilder = null;
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            if (stringBuilder != null) {
                stringBuilder.append(string);
            }
            if (string.endsWith("\\")) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string);
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                continue;
            }
            if (stringBuilder == null) {
                string2 = string;
            } else {
                string2 = stringBuilder.toString();
                stringBuilder = null;
            }
            int n2 = string2.indexOf(58);
            if (n2 >= 0) {
                String string3 = string2.substring(0, n2);
                int[] nArray = map.get(string3);
                if (nArray != null) {
                    for (int n3 : nArray) {
                        stringArray[n3] = string2.substring(n2 + 1);
                    }
                    continue;
                }
                if (bl && fileEntries.containsKey(string3)) {
                    String string4 = string2.substring(string2.lastIndexOf(58) + 1);
                    this.documents.add(new DirectAccessFaxDoc<QueueFileFormat>(this, this.translateFileName(string4), fileEntries.get(string3)));
                    continue;
                }
                if (!Utils.debugMode) continue;
                log.finest("Ignoring entry for queue file " + this.jobID + ": " + string2);
                continue;
            }
            log.info("Malformed queue file entry for q" + this.jobID + ": " + string2);
        }
        bufferedReader.close();
        return stringArray;
    }

    static {
        fileEntries.put("postscript", FileFormat.PostScript);
        fileEntries.put("!postscript", FileFormat.PostScript);
        fileEntries.put("pcl", FileFormat.PCL);
        fileEntries.put("!pcl", FileFormat.PCL);
        fileEntries.put("tiff", FileFormat.TIFF);
        fileEntries.put("!tiff", FileFormat.TIFF);
        fileEntries.put("data", FileFormat.Unknown);
        fileEntries.put("!data", FileFormat.Unknown);
        fileEntries.put("pdf", FileFormat.PDF);
        fileEntries.put("!pdf", FileFormat.PDF);
    }
}

