/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.directaccess.jobq;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import yajhfc.Utils;
import yajhfc.model.FmtItemList;
import yajhfc.model.JobFormat;
import yajhfc.model.jobq.QueueFileFormat;
import yajhfc.model.servconn.FaxJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobToQueueMapping {
    protected final JobFormat jobFmt;
    protected final QueueFileFormat[] sourceProps;
    private static final Map<JobFormat, JobToQueueMapping> jobToQueueMap = new EnumMap<JobFormat, JobToQueueMapping>(JobFormat.class);

    public Object mapParsedData(FaxJob<QueueFileFormat> faxJob) {
        return faxJob.getData(this.sourceProps[0]);
    }

    public void setMappedData(FaxJob<QueueFileFormat> faxJob, Object object, boolean bl) {
        faxJob.setData(this.sourceProps[0], object, bl);
    }

    public JobFormat getJobFormat() {
        return this.jobFmt;
    }

    public QueueFileFormat[] getSourceProperties() {
        return this.sourceProps;
    }

    protected JobToQueueMapping(JobFormat jobFormat, QueueFileFormat ... queueFileFormatArray) {
        this.jobFmt = jobFormat;
        this.sourceProps = queueFileFormatArray;
    }

    private static void put(JobToQueueMapping jobToQueueMapping) {
        jobToQueueMap.put(jobToQueueMapping.getJobFormat(), jobToQueueMapping);
    }

    public static JobToQueueMapping getMappingFor(JobFormat jobFormat) {
        return jobToQueueMap.get(jobFormat);
    }

    public static List<JobToQueueMapping> getReverseMappingFor(QueueFileFormat queueFileFormat) {
        ArrayList<JobToQueueMapping> arrayList = new ArrayList<JobToQueueMapping>();
        for (JobToQueueMapping jobToQueueMapping : jobToQueueMap.values()) {
            if (Utils.indexOfArray(jobToQueueMapping.getSourceProperties(), queueFileFormat) < 0) continue;
            arrayList.add(jobToQueueMapping);
        }
        return arrayList;
    }

    public static void getRequiredFormats(FmtItemList<JobFormat> fmtItemList, FmtItemList<QueueFileFormat> fmtItemList2) {
        fmtItemList2.clear();
        for (JobFormat jobFormat : fmtItemList.getCompleteView()) {
            JobToQueueMapping jobToQueueMapping = jobToQueueMap.get(jobFormat);
            for (QueueFileFormat queueFileFormat : jobToQueueMapping.getSourceProperties()) {
                fmtItemList2.add(queueFileFormat);
            }
        }
    }

    static {
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.A, QueueFileFormat.subaddr));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.B, QueueFileFormat.passwd));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.C, QueueFileFormat.company));
        JobToQueueMapping.put(new StringFormatMapping(JobFormat.D, "%2d:%-2d", QueueFileFormat.totdials, QueueFileFormat.maxdials));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.E, QueueFileFormat.desiredbr));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.F, QueueFileFormat.tagline));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.G, QueueFileFormat.desiredst));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.H, QueueFileFormat.desireddf));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.I, QueueFileFormat.schedpri));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.J, QueueFileFormat.jobtag));
        JobToQueueMapping.put(new CharLookupMapping(JobFormat.K, "D HF", QueueFileFormat.desiredec));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.L, QueueFileFormat.location));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.M, QueueFileFormat.mailaddr));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.N, QueueFileFormat.desiredtl));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.O, QueueFileFormat.useccover));
        JobToQueueMapping.put(new StringFormatMapping(JobFormat.P, "%2d:%-2d", QueueFileFormat.npages, QueueFileFormat.totpages));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.Q, QueueFileFormat.minbr));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.R, QueueFileFormat.receiver));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.S, QueueFileFormat.sender));
        JobToQueueMapping.put(new StringFormatMapping(JobFormat.T, "%2d:%-2d", QueueFileFormat.tottries, QueueFileFormat.maxtries));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.U, QueueFileFormat.chopthreshold));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.V, QueueFileFormat.doneop));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.W, QueueFileFormat.commid));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.X, new QueueFileFormat[]{QueueFileFormat.jobtype}){

            @Override
            public Object mapParsedData(FaxJob<QueueFileFormat> faxJob) {
                String string = (String)faxJob.getData(QueueFileFormat.jobtype);
                if (string == null || string.length() == 0) {
                    return "";
                }
                return String.valueOf(Character.toUpperCase(string.charAt(0)));
            }
        });
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.Y, QueueFileFormat.tts));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.Z, QueueFileFormat.tts));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.a, QueueFileFormat.state));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.a_desc, QueueFileFormat.state_desc));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.b, QueueFileFormat.ntries));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.c, QueueFileFormat.client));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.d, QueueFileFormat.totdials));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.e, QueueFileFormat.external));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.f, QueueFileFormat.ndials));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.g, QueueFileFormat.groupid));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.h, new QueueFileFormat[]{QueueFileFormat.pagechop}){

            @Override
            public Object mapParsedData(FaxJob<QueueFileFormat> faxJob) {
                String string = (String)faxJob.getData(QueueFileFormat.jobtype);
                if (string == null || string.length() == 0) {
                    return " ";
                }
                if ("default".equals(string)) {
                    return "D";
                }
                if ("all".equals(string)) {
                    return "A";
                }
                if ("last".equals(string)) {
                    return "L";
                }
                return " ";
            }
        });
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.i, QueueFileFormat.priority));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.j, QueueFileFormat.jobid));
        JobToQueueMapping.put(new DateFormatMapping(JobFormat.k, QueueFileFormat.killtime, DateFormat.getTimeInstance()));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.l, QueueFileFormat.pagelength));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.m, QueueFileFormat.modem));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.n, QueueFileFormat.notify));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.n_desc, QueueFileFormat.notify_desc));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.o, QueueFileFormat.owner));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.p, QueueFileFormat.npages));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.q, new QueueFileFormat[]{QueueFileFormat.retrytime}){

            @Override
            public Object mapParsedData(FaxJob<QueueFileFormat> faxJob) {
                Number number = (Number)faxJob.getData(this.sourceProps[0]);
                if (number != null && number.intValue() > 0) {
                    return new Date(number.longValue() * 1000L);
                }
                return null;
            }
        });
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.r, QueueFileFormat.resolution));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.s, QueueFileFormat.status));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.t, QueueFileFormat.tottries));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.u, QueueFileFormat.maxtries));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.v, QueueFileFormat.number));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.w, QueueFileFormat.pagewidth));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.x, QueueFileFormat.maxdials));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.y, QueueFileFormat.totpages));
        JobToQueueMapping.put(new DateFormatMapping(JobFormat.z, QueueFileFormat.tts, DateFormat.getDateTimeInstance()));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat._0, QueueFileFormat.usexvres));
        JobToQueueMapping.put(new JobToQueueMapping(JobFormat.virt_comment, QueueFileFormat.virt_comment));
        assert (jobToQueueMap.size() == JobFormat.values().length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DateFormatMapping
    extends JobToQueueMapping {
        protected final DateFormat format;

        protected DateFormatMapping(JobFormat jobFormat, QueueFileFormat queueFileFormat, DateFormat dateFormat) {
            super(jobFormat, queueFileFormat);
            this.format = dateFormat;
        }

        @Override
        public Object mapParsedData(FaxJob<QueueFileFormat> faxJob) {
            Date date = (Date)faxJob.getData(this.sourceProps[0]);
            if (date != null) {
                return this.format.format(date);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringFormatMapping
    extends JobToQueueMapping {
        protected final String formatString;

        protected StringFormatMapping(JobFormat jobFormat, String string, QueueFileFormat ... queueFileFormatArray) {
            super(jobFormat, queueFileFormatArray);
            this.formatString = string;
        }

        @Override
        public Object mapParsedData(FaxJob<QueueFileFormat> faxJob) {
            Object[] objectArray = new Object[this.sourceProps.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = faxJob.getData(this.sourceProps[i]);
            }
            return String.format(this.formatString, objectArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CharLookupMapping
    extends JobToQueueMapping {
        protected final String lookupString;

        protected CharLookupMapping(JobFormat jobFormat, String string, QueueFileFormat queueFileFormat) {
            super(jobFormat, queueFileFormat);
            this.lookupString = string;
        }

        @Override
        public Object mapParsedData(FaxJob<QueueFileFormat> faxJob) {
            Number number = (Number)faxJob.getData(this.sourceProps[0]);
            if (number != null) {
                return String.valueOf(this.lookupString.charAt(number.intValue()));
            }
            return null;
        }
    }
}

