/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.hylafax;

import gnu.hylafax.HylaFAXClient;
import gnu.inet.ftp.ServerResponseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.FmtItemList;
import yajhfc.model.TableType;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.servconn.defimpl.AbstractFaxJobList;
import yajhfc.model.servconn.hylafax.HylaFaxListConnection;
import yajhfc.model.servconn.hylafax.ManagedFaxJobList;
import yajhfc.server.ServerOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHylaFaxJobList<T extends FmtItem>
extends AbstractFaxJobList<T>
implements ManagedFaxJobList<T> {
    protected static final char SPLIT_CHAR = '\u0002';
    protected static final String FMT_PREFIX = "X\u0002";
    static final Logger log = Logger.getLogger(AbstractHylaFaxJobList.class.getName());
    protected final HylaFaxListConnection parent;
    protected Vector<?> lastJobListing = null;

    @Override
    public void disconnectCleanup() {
        this.setJobs(Collections.emptyList());
        this.lastJobListing = null;
    }

    @Override
    public void pollForNewJobs(HylaFAXClient hylaFAXClient) throws IOException, ServerResponseException {
        if (Utils.debugMode) {
            log.finer("Getting job listing with columns: " + this.columns.getCompleteView());
        }
        Vector<?> vector = this.getJobListing(hylaFAXClient);
        if (this.lastJobListing == null || !vector.equals(this.lastJobListing)) {
            log.fine("Job listings differ, reloading jobs");
            ArrayList arrayList = new ArrayList(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                arrayList.add(this.createFaxJob(Utils.fastSplit((String)vector.get(i), '\u0002')));
            }
            this.lastJobListing = vector;
            this.setJobs(arrayList);
        } else {
            log.fine("Job listings are the same.");
        }
    }

    @Override
    public void reloadSettings(ServerOptions serverOptions) {
    }

    protected AbstractHylaFaxJobList(HylaFaxListConnection hylaFaxListConnection, FmtItemList<T> fmtItemList) {
        super(fmtItemList, hylaFaxListConnection);
        this.parent = hylaFaxListConnection;
    }

    @Override
    public abstract TableType getJobType();

    protected abstract FaxJob<T> createFaxJob(String[] var1);

    protected abstract Vector<?> getJobListing(HylaFAXClient var1) throws IOException, ServerResponseException;

    protected static Vector filterPrefix(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            if (!string.startsWith(FMT_PREFIX)) continue;
            vector.set(i, string.substring(FMT_PREFIX.length()));
        }
        return vector;
    }
}

