/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.table;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import yajhfc.Utils;
import yajhfc.filters.Filter;
import yajhfc.model.FmtItem;
import yajhfc.model.FmtItemList;
import yajhfc.model.TableType;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.servconn.FaxJobList;
import yajhfc.model.servconn.FaxJobListListener;
import yajhfc.model.servconn.defimpl.SwingFaxJobListListener;
import yajhfc.virtualcolumnstore.VirtColChangeListener;
import yajhfc.virtualcolumnstore.VirtColPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaxListTableModel<T extends FmtItem>
extends AbstractTableModel {
    static final Logger log = Logger.getLogger(FaxListTableModel.class.getName());
    protected FaxJobList<T> jobs;
    protected Filter<FaxJob<T>, T> jobFilter = null;
    protected List<FaxJob<T>> visibleJobs;
    private static final Color defErrorColor = new Color(255, 230, 230);
    protected Color errorColor = defErrorColor;
    protected VirtColPersister persistence;
    protected VirtColChangeListener persistenceListener = new VirtColChangeListener(){

        @Override
        public void columnsChanged(Set<String> set, Set<String> set2, Set<String> set3) {
            FaxJob faxJob;
            Map map = FaxListTableModel.this.getIDMap();
            for (String string : set) {
                faxJob = map.get(string);
                if (faxJob == null) continue;
                FaxListTableModel.this.persistence.updateToFaxJob(faxJob, true);
            }
            for (String string : set2) {
                faxJob = map.get(string);
                if (faxJob == null) continue;
                FaxListTableModel.this.persistence.updateToFaxJob(faxJob, true);
            }
        }
    };
    private Map<String, FaxJob<T>> idMap;
    private FaxJobListListener<T> updateListener;

    protected Map<String, FaxJob<T>> getIDMap() {
        if (this.idMap == null) {
            this.idMap = FaxListTableModel.buildIDMap(this.getJobs().getJobs());
        }
        return this.idMap;
    }

    public VirtColPersister getPersistence() {
        return this.persistence;
    }

    public void setPersistence(VirtColPersister virtColPersister) {
        if (virtColPersister != this.persistence) {
            if (this.persistence != null) {
                this.persistence.removeVirtColChangeListener(this.persistenceListener);
            }
            this.persistence = virtColPersister;
            if (virtColPersister != null) {
                virtColPersister.addVirtColChangeListener(this.persistenceListener);
                virtColPersister.updateToAllFaxJobs(this.getJobs().getJobs(), true);
            }
        }
    }

    public static <U extends FmtItem> Map<String, FaxJob<U>> buildIDMap(List<FaxJob<U>> list) {
        HashMap<String, FaxJob<U>> hashMap = new HashMap<String, FaxJob<U>>(list.size());
        for (FaxJob<U> faxJob : list) {
            hashMap.put(VirtColPersister.getKeyForFaxJob(faxJob), faxJob);
        }
        return hashMap;
    }

    public void setJobFilter(Filter<FaxJob<T>, T> filter) {
        if (filter != this.jobFilter) {
            this.jobFilter = filter;
            this.refreshVisibleJobs();
        }
    }

    public Filter<FaxJob<T>, T> getJobFilter() {
        return this.jobFilter;
    }

    public Font getCellFont(int n, int n2) {
        return null;
    }

    public Color getCellBackgroundColor(int n, int n2) {
        if (Utils.getFaxOptions().markFailedJobs && this.getJob(n).isError()) {
            return this.errorColor;
        }
        return null;
    }

    public Color getCellForegroundColor(int n, int n2) {
        return null;
    }

    protected void refreshVisibleJobs() {
        this.refreshVisibleJobsWithoutEvent();
        log.fine("Jobs refreshed, firing table data changed");
        this.fireTableDataChanged();
    }

    private void refreshVisibleJobsWithoutEvent() {
        if (Utils.debugMode) {
            log.finest("refreshing jobs: jobFilter=" + this.jobFilter + "; jobs=" + (this.jobs == null ? "<jobs null>" : this.jobs.getJobs()));
        }
        if (this.jobs == null) {
            this.visibleJobs = null;
        } else if (this.jobFilter == null) {
            this.visibleJobs = this.jobs.getJobs();
        } else {
            this.visibleJobs = new ArrayList<FaxJob<T>>(this.jobs.getJobs().size());
            this.jobFilter.initFilter(this.getColumns());
            for (FaxJob<T> faxJob : this.jobs.getJobs()) {
                if (!this.jobFilter.matchesFilter(faxJob)) continue;
                this.visibleJobs.add(faxJob);
            }
            if (Utils.debugMode) {
                log.finest("refreshing jobs: resulting visibleJobs=" + this.visibleJobs);
            }
        }
    }

    public FmtItemList<T> getColumns() {
        return this.jobs != null ? this.jobs.getColumns() : null;
    }

    @Override
    public int getColumnCount() {
        if (this.getColumns() != null) {
            return this.getColumns().size();
        }
        return 0;
    }

    @Override
    public int getRowCount() {
        return this.visibleJobs == null ? 0 : this.visibleJobs.size();
    }

    public int getRealRowCount() {
        if (this.jobs == null) {
            return 0;
        }
        return this.jobs.getJobs().size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.getJob(n).getData(n2);
    }

    public FaxJob<T> getJob(int n) {
        return this.visibleJobs.get(n);
    }

    public FaxJob<T> getRealJob(int n) {
        return this.jobs.getJobs().get(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return !((FmtItem)this.jobs.getColumns().get(n2)).isReadOnly();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.getJob(n).setData(n2, object);
    }

    @Override
    public String getColumnName(int n) {
        return ((FmtItem)this.getColumns().get(n)).getDescription();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return ((FmtItem)this.getColumns().get(n)).getDataType();
    }

    public TableType getTableType() {
        return this.jobs.getJobType();
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void setErrorColor(Color color) {
        this.errorColor = color;
    }

    public FaxJobList<T> getJobs() {
        return this.jobs;
    }

    private FaxJobListListener<T> getUpdateListener() {
        if (this.updateListener == null) {
            this.updateListener = new SwingFaxJobListListener<T>(true, false, true){

                @Override
                protected void faxJobsUpdatedSwing(FaxJobList<T> faxJobList, List<FaxJob<T>> list, List<FaxJob<T>> list2) {
                    FaxListTableModel.this.refreshVisibleJobs();
                }

                @Override
                public void faxJobsUpdated(FaxJobList<T> faxJobList, List<FaxJob<T>> list, List<FaxJob<T>> list2) {
                    if (FaxListTableModel.this.persistence != null) {
                        FaxListTableModel.this.persistence.updateToAllFaxJobs(list2, false);
                    }
                    super.faxJobsUpdated(faxJobList, list, list2);
                }

                @Override
                protected void columnChangedSwing(FaxJobList<T> faxJobList, FaxJob<T> faxJob, T t, int n, Object object, Object object2) {
                    FaxListTableModel.this.fireTableCellUpdated(Utils.identityIndexOf(FaxListTableModel.this.jobs.getJobs(), faxJob), n);
                }

                @Override
                public void columnChanged(FaxJobList<T> faxJobList, FaxJob<T> faxJob, T t, int n, Object object, Object object2) {
                    if (FaxListTableModel.this.persistence != null && t.getVirtualColumnType().isSaveable()) {
                        FaxListTableModel.this.persistence.setValue(faxJob, t.getVirtualColumnType(), object2);
                    }
                    super.columnChanged(faxJobList, faxJob, t, n, object, object2);
                }
            };
        }
        return this.updateListener;
    }

    public void setJobs(FaxJobList<T> faxJobList) {
        if (this.jobs != faxJobList) {
            if (this.jobs != null) {
                this.jobs.removeFaxJobListListener(this.getUpdateListener());
            }
            this.jobs = faxJobList;
            this.idMap = null;
            if (faxJobList != null) {
                faxJobList.addFaxJobListListener(this.getUpdateListener());
                if (this.persistence != null) {
                    this.persistence.updateToAllFaxJobs(faxJobList.getJobs(), false);
                }
            }
            this.refreshVisibleJobsWithoutEvent();
            log.fine("New Jobs have been set, firing tableStructureChanged");
            this.fireTableStructureChanged();
        }
    }

    public FaxListTableModel(FaxJobList<T> faxJobList) {
        this.setJobs(faxJobList);
    }
}

