/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.options;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import yajhfc.FaxOptions;
import yajhfc.Utils;
import yajhfc.options.AbstractOptionsPanel;
import yajhfc.options.OptionsWin;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.SafeJFileChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminSettingsPage
extends AbstractOptionsPanel<FaxOptions> {
    protected final OptionsWin parentWin;
    JCheckBox checkUseWin32ShutdownManager;
    JCheckBox checkAdjustMenusForMacOSX;
    JCheckBox checkUseJDK16PSBugfix;
    JCheckBox checkRegardingAsUsrKey;
    JCheckBox checkAllowChangeFilter;
    JCheckBox checkSendFORMCommand;
    JFileChooser fileChooser;
    Action actImport;
    Action actExport;

    public AdminSettingsPage(OptionsWin optionsWin) {
        super(false);
        this.parentWin = optionsWin;
    }

    @Override
    protected void createOptionsUI() {
        double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0, -2.0, 5.0}, {5.0, -2.0, 10.0, -1.0, 5.0}};
        this.setLayout(new TableLayout(dArrayArray));
        JLabel jLabel = new JLabel("<html>" + Utils._("This page allows you to import/export settings and to set miscellaneous advanced settings (change them only if you know what you are doing; you may need to restart YajHFC for them to take effect).") + "</html>");
        this.add((Component)jLabel, "1,1,3,1");
        this.add((Component)this.createSettingsPanel(), "1,3");
        this.add((Component)this.createImportExportPanel(), "3,3");
    }

    private JPanel createSettingsPanel() {
        JPanel jPanel = new JPanel(null, false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(Utils._("Advanced settings") + ":"));
        Dimension dimension = new Dimension(5, 5);
        this.checkAllowChangeFilter = new JCheckBox(Utils._("Allow the user to change the fax job filter (View menu)"));
        this.checkRegardingAsUsrKey = new JCheckBox(Utils._("Use the fax's subject as HylaFAX USRKEY property"));
        this.checkUseJDK16PSBugfix = new JCheckBox(Utils._("Repair PostScript generated by JDK 1.6 PrintService classes"));
        this.checkUseWin32ShutdownManager = new JCheckBox(Utils._("Use ShutdownHook bug fix on Win32"));
        this.checkAdjustMenusForMacOSX = new JCheckBox(Utils._("Remove application menu entries from normal menu on Mac OS X"));
        this.checkSendFORMCommand = new JCheckBox(Utils._("Send FORM command"));
        jPanel.add(this.checkAllowChangeFilter);
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(this.checkRegardingAsUsrKey);
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(this.checkUseJDK16PSBugfix);
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(this.checkUseWin32ShutdownManager);
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(this.checkAdjustMenusForMacOSX);
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(this.checkSendFORMCommand);
        return jPanel;
    }

    JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new SafeJFileChooser();
            this.fileChooser.setFileHidingEnabled(false);
        }
        return this.fileChooser;
    }

    private JPanel createImportExportPanel() {
        this.actImport = new ExcDialogAbstractAction(Utils._("Import settings") + "..."){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = AdminSettingsPage.this.getFileChooser();
                jFileChooser.setDialogTitle(Utils._("Import settings"));
                if (jFileChooser.showOpenDialog(AdminSettingsPage.this) == 0) {
                    try {
                        Properties properties = new Properties();
                        FileInputStream fileInputStream = new FileInputStream(jFileChooser.getSelectedFile());
                        properties.load(fileInputStream);
                        fileInputStream.close();
                        FaxOptions faxOptions = new FaxOptions();
                        faxOptions.loadFromProperties(properties);
                        AdminSettingsPage.this.parentWin.reloadSettings(faxOptions);
                        JOptionPane.showMessageDialog(AdminSettingsPage.this, Utils._("Settings imported successfully."));
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog(AdminSettingsPage.this, Utils._("Error importing settings:"), exception);
                    }
                }
            }
        };
        this.actExport = new ExcDialogAbstractAction(Utils._("Export settings") + "..."){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = AdminSettingsPage.this.getFileChooser();
                jFileChooser.setDialogTitle(Utils._("Export settings"));
                if (jFileChooser.showSaveDialog(AdminSettingsPage.this) == 0) {
                    try {
                        Properties properties = new Properties();
                        FaxOptions faxOptions = new FaxOptions();
                        AdminSettingsPage.this.parentWin.foToEdit.storeToProperties(properties);
                        faxOptions.loadFromProperties(properties);
                        if (AdminSettingsPage.this.parentWin.saveSettings(faxOptions)) {
                            faxOptions.storeToProperties(properties);
                            FileOutputStream fileOutputStream = new FileOutputStream(jFileChooser.getSelectedFile());
                            properties.store(fileOutputStream, "YajHFC 0.6.1 (srfax v4) configuration file; exported from the options dialog");
                            fileOutputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog(AdminSettingsPage.this, Utils._("Error exporting settings:"), exception);
                    }
                }
            }
        };
        JPanel jPanel = new JPanel(null, false);
        jPanel.setLayout(new TableLayout(new double[][]{{5.0, -1.0, 5.0}, {5.0, -2.0, 5.0, -2.0, -1.0}}));
        jPanel.setBorder(BorderFactory.createTitledBorder(Utils._("Import/Export")));
        jPanel.add((Component)new JButton(this.actImport), "1,1");
        jPanel.add((Component)new JButton(this.actExport), "1,3");
        return jPanel;
    }

    @Override
    public void loadSettings(FaxOptions faxOptions) {
        this.checkAdjustMenusForMacOSX.setSelected(faxOptions.adjustMenusForMacOSX);
        this.checkAllowChangeFilter.setSelected(faxOptions.allowChangeFilter);
        this.checkRegardingAsUsrKey.setSelected(faxOptions.regardingAsUsrKey);
        this.checkUseJDK16PSBugfix.setSelected(faxOptions.useJDK16PSBugfix);
        this.checkUseWin32ShutdownManager.setSelected(faxOptions.useWin32ShutdownManager);
        this.checkSendFORMCommand.setSelected(faxOptions.sendFORMCommand);
    }

    @Override
    public void saveSettings(FaxOptions faxOptions) {
        faxOptions.adjustMenusForMacOSX = this.checkAdjustMenusForMacOSX.isSelected();
        faxOptions.allowChangeFilter = this.checkAllowChangeFilter.isSelected();
        faxOptions.regardingAsUsrKey = this.checkRegardingAsUsrKey.isSelected();
        faxOptions.useJDK16PSBugfix = this.checkUseJDK16PSBugfix.isSelected();
        faxOptions.useWin32ShutdownManager = this.checkUseWin32ShutdownManager.isSelected();
        faxOptions.sendFORMCommand = this.checkSendFORMCommand.isSelected();
    }
}

