/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.options;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import yajhfc.DateStyle;
import yajhfc.FaxOptions;
import yajhfc.Utils;
import yajhfc.YajLanguage;
import yajhfc.options.AbstractOptionsPanel;
import yajhfc.options.OptionsWin;
import yajhfc.send.SendWinStyle;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ComponentEnabler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonPanel
extends AbstractOptionsPanel<FaxOptions> {
    static final Logger log = Logger.getLogger(CommonPanel.class.getName());
    JPanel panelUpdates;
    JPanel panelUI;
    JPanel panelDateFormat;
    JPanel panelNewFaxAction;
    JCheckBox checkAutoCheckForUpdate;
    JComboBox comboLang;
    Vector<LF_Entry> lookAndFeels;
    JComboBox comboLookAndFeel;
    JComboBox comboSendWinStyle;
    JCheckBox checkShowTrayIcon;
    boolean changedLF;
    JCheckBox checkMinimizeToTray;
    JCheckBox checkMinimizeToTrayOnMainWinClose;
    JCheckBox checkNewFax_Beep;
    JCheckBox checkNewFax_BlinkTrayIcon;
    JCheckBox checkNewFax_MarkAsRead;
    JCheckBox checkNewFax_Open;
    JCheckBox checkNewFax_ToFront;
    JCheckBox checkNewFax_TrayNotification;
    JComboBox comboDateFormat;
    JComboBox comboTimeFormat;
    final OptionsWin parent;
    String oldLookAndFeel;

    public CommonPanel(OptionsWin optionsWin) {
        super(false);
        this.parent = optionsWin;
    }

    @Override
    protected void createOptionsUI() {
        double[][] dArrayArray = new double[][]{{5.0, 0.4, 5.0, -1.0, 5.0}, {5.0, -2.0, 5.0, -2.0, -1.0, 5.0}};
        this.setLayout(new TableLayout(dArrayArray));
        this.add((Component)this.getPanelUI(), "1,1");
        this.add((Component)this.getPanelNewFaxAction(), "3,1");
        this.add((Component)this.getPanelDateFormat(), "1,3");
        this.add((Component)this.getPanelUpdates(), "3,3");
    }

    private JPanel getPanelUpdates() {
        if (this.panelUpdates == null) {
            this.panelUpdates = new JPanel(new BorderLayout(), false);
            this.panelUpdates.setBorder(BorderFactory.createTitledBorder(Utils._("Update check")));
            this.checkAutoCheckForUpdate = new JCheckBox(Utils._("Automatically check for updates"));
            this.panelUpdates.add((Component)this.checkAutoCheckForUpdate, "Center");
        }
        return this.panelUpdates;
    }

    private JPanel getPanelUI() {
        if (this.panelUI == null) {
            double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0}, new double[11]};
            dArrayArray[1][10] = 5.0;
            for (int i = 0; i < 7; ++i) {
                dArrayArray[1][i] = i % 2 == 0 ? -2.0 : 0.16666666666666666;
            }
            dArrayArray[1][7] = 0.16666666666666666;
            dArrayArray[1][8] = 0.16666666666666666;
            dArrayArray[1][9] = -1.0;
            TableLayout tableLayout = new TableLayout(dArrayArray);
            tableLayout.setVGap(5);
            this.panelUI = new JPanel(tableLayout, false);
            this.panelUI.setBorder(BorderFactory.createTitledBorder(Utils._("User interface")));
            this.comboLang = new JComboBox<YajLanguage>(new Vector<YajLanguage>(YajLanguage.supportedLanguages));
            this.lookAndFeels = LF_Entry.getLookAndFeelList();
            this.comboLookAndFeel = new JComboBox<LF_Entry>(this.lookAndFeels);
            this.comboLookAndFeel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LF_Entry lF_Entry = (LF_Entry)CommonPanel.this.comboLookAndFeel.getSelectedItem();
                    log.fine("Look&Feel " + lF_Entry + " selected");
                    if (CommonPanel.this.changedLF || !lF_Entry.className.equals(CommonPanel.this.oldLookAndFeel)) {
                        log.info("Changing L&F of OptionsDialog to " + lF_Entry.className);
                        Utils.setLookAndFeel(lF_Entry.className);
                        SwingUtilities.updateComponentTreeUI(CommonPanel.this.parent);
                        CommonPanel.this.changedLF = true;
                    }
                }
            });
            this.comboSendWinStyle = new JComboBox<SendWinStyle>(SendWinStyle.values());
            this.checkShowTrayIcon = new JCheckBox(Utils._("Show tray icon"));
            this.checkShowTrayIcon.setToolTipText(Utils._("Show a system tray icon (works only with Java 6 or higher)"));
            this.checkMinimizeToTray = new JCheckBox(Utils._("Minimize to tray"));
            this.checkMinimizeToTray.setEnabled(false);
            this.checkMinimizeToTrayOnMainWinClose = new JCheckBox(Utils._("Minimize to tray when main window is closed"));
            this.checkMinimizeToTrayOnMainWinClose.setToolTipText(Utils._("Minimize to tray when main window is closed"));
            this.checkMinimizeToTrayOnMainWinClose.setEnabled(false);
            ComponentEnabler.installOn(this.checkShowTrayIcon, true, this.checkMinimizeToTray, this.checkMinimizeToTrayOnMainWinClose);
            Utils.addWithLabel(this.panelUI, (Component)this.comboLang, Utils._("Language:"), "1, 1, 1, 1, f, c");
            Utils.addWithLabel(this.panelUI, (Component)this.comboLookAndFeel, Utils._("Look and Feel:"), "1, 3, 1, 3, f, c");
            Utils.addWithLabel(this.panelUI, (Component)this.comboSendWinStyle, Utils._("Style of send dialog:"), "1, 5, 1, 5, f, c");
            this.panelUI.add((Component)this.checkShowTrayIcon, "1,7,1,7,f,c");
            this.panelUI.add((Component)this.checkMinimizeToTray, "1,8,1,8,f,c");
            this.panelUI.add((Component)this.checkMinimizeToTrayOnMainWinClose, "1,9,1,9,f,c");
        }
        return this.panelUI;
    }

    private JPanel getPanelNewFaxAction() {
        if (this.panelNewFaxAction == null) {
            double[][] dArrayArray = new double[][]{{5.0, 20.0, -1.0, 5.0}, new double[8]};
            double d = 0.16666666666666666;
            dArrayArray[1][0] = 5.0;
            dArrayArray[1][7] = 5.0;
            Arrays.fill(dArrayArray[1], 1, 7, d);
            dArrayArray[1][6] = -1.0;
            this.panelNewFaxAction = new JPanel(new TableLayout(dArrayArray), false);
            this.panelNewFaxAction.setBorder(BorderFactory.createTitledBorder(Utils._("Actions after receiving a new fax:")));
            this.checkNewFax_Beep = new JCheckBox(Utils._("Beep"));
            this.checkNewFax_ToFront = new JCheckBox(Utils._("Bring to front"));
            this.checkNewFax_Open = new JCheckBox(Utils._("Open in viewer"));
            this.checkNewFax_Open.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    CommonPanel.this.checkNewFax_MarkAsRead.setEnabled(CommonPanel.this.checkNewFax_Open.isSelected());
                }
            });
            this.checkNewFax_MarkAsRead = new JCheckBox(Utils._("And mark as read"));
            this.checkNewFax_MarkAsRead.setEnabled(false);
            this.checkNewFax_BlinkTrayIcon = new JCheckBox(Utils._("Show flashing tray icon"));
            this.checkNewFax_TrayNotification = new JCheckBox(Utils._("Display tray icon message"));
            this.panelNewFaxAction.add((Component)this.checkNewFax_Beep, "1,1,2,1");
            this.panelNewFaxAction.add((Component)this.checkNewFax_ToFront, "1,2,2,2");
            this.panelNewFaxAction.add((Component)this.checkNewFax_Open, "1,3,2,3");
            this.panelNewFaxAction.add((Component)this.checkNewFax_MarkAsRead, "2,4");
            this.panelNewFaxAction.add((Component)this.checkNewFax_BlinkTrayIcon, "1,5,2,5");
            this.panelNewFaxAction.add((Component)this.checkNewFax_TrayNotification, "1,6,2,6");
        }
        return this.panelNewFaxAction;
    }

    private JPanel getPanelDateFormat() {
        if (this.panelDateFormat == null) {
            double[][] dArrayArray = new double[][]{{5.0, 0.5, 5.0, -1.0, 5.0}, {5.0, -1.0, -2.0, 5.0}};
            this.panelDateFormat = new JPanel(new TableLayout(dArrayArray), false);
            this.panelDateFormat.setBorder(BorderFactory.createTitledBorder(Utils._("Date and Time Format:")));
            this.comboDateFormat = new JComboBox<DateStyle>(DateStyle.getAvailableDateStyles());
            this.comboDateFormat.setEditable(true);
            ClipboardPopup.DEFAULT_POPUP.addToComponent(this.comboDateFormat);
            this.comboTimeFormat = new JComboBox<DateStyle>(DateStyle.getAvailableTimeStyles());
            this.comboTimeFormat.setEditable(true);
            ClipboardPopup.DEFAULT_POPUP.addToComponent(this.comboTimeFormat);
            Utils.addWithLabel(this.panelDateFormat, (Component)this.comboDateFormat, Utils._("Date format:"), "1,2");
            Utils.addWithLabel(this.panelDateFormat, (Component)this.comboTimeFormat, Utils._("Time format:"), "3,2");
        }
        return this.panelDateFormat;
    }

    @Override
    public void loadSettings(FaxOptions faxOptions) {
        this.oldLookAndFeel = faxOptions.lookAndFeel;
        this.comboLang.setSelectedItem(faxOptions.locale);
        this.comboSendWinStyle.setSelectedItem((Object)faxOptions.sendWinStyle);
        int n = 0;
        for (int i = 0; i < this.lookAndFeels.size(); ++i) {
            if (!this.lookAndFeels.get((int)i).className.equals(faxOptions.lookAndFeel)) continue;
            n = i;
            break;
        }
        this.comboLookAndFeel.setSelectedIndex(n);
        this.setDateStyle(this.comboDateFormat, faxOptions.dateStyle, DateStyle.getAvailableDateStyles());
        this.setDateStyle(this.comboTimeFormat, faxOptions.timeStyle, DateStyle.getAvailableTimeStyles());
        this.checkShowTrayIcon.setSelected(faxOptions.showTrayIcon);
        this.checkMinimizeToTray.setSelected(faxOptions.minimizeToTray);
        this.checkMinimizeToTrayOnMainWinClose.setSelected(faxOptions.minimizeToTrayOnMainWinClose);
        this.checkAutoCheckForUpdate.setSelected(faxOptions.automaticallyCheckForUpdate);
        this.checkNewFax_Beep.setSelected((faxOptions.newFaxAction & 1) != 0);
        this.checkNewFax_ToFront.setSelected((faxOptions.newFaxAction & 2) != 0);
        this.checkNewFax_Open.setSelected((faxOptions.newFaxAction & 4) != 0);
        this.checkNewFax_MarkAsRead.setSelected((faxOptions.newFaxAction & 8) != 0);
        this.checkNewFax_BlinkTrayIcon.setSelected((faxOptions.newFaxAction & 0x10) != 0);
        this.checkNewFax_TrayNotification.setSelected(faxOptions.newFaxTrayNotification);
    }

    @Override
    public void saveSettings(FaxOptions faxOptions) {
        YajLanguage yajLanguage;
        faxOptions.sendWinStyle = (SendWinStyle)((Object)this.comboSendWinStyle.getSelectedItem());
        String string = ((LF_Entry)this.comboLookAndFeel.getSelectedItem()).className;
        if (!string.equals(faxOptions.lookAndFeel)) {
            faxOptions.lookAndFeel = string;
            Utils.setLookAndFeel(string);
            CommonPanel.refreshLF();
        }
        if (!(yajLanguage = (YajLanguage)this.comboLang.getSelectedItem()).equals(faxOptions.locale)) {
            faxOptions.locale = yajLanguage;
            JOptionPane.showMessageDialog(this, Utils._("You must restart the program for the change of the language to take effect."), Utils._("Options"), 1);
        }
        faxOptions.showTrayIcon = this.checkShowTrayIcon.isSelected();
        faxOptions.minimizeToTray = this.checkMinimizeToTray.isSelected();
        faxOptions.minimizeToTrayOnMainWinClose = this.checkMinimizeToTrayOnMainWinClose.isSelected();
        faxOptions.automaticallyCheckForUpdate = this.checkAutoCheckForUpdate.isSelected();
        int n = 0;
        if (this.checkNewFax_Beep.isSelected()) {
            n |= 1;
        }
        if (this.checkNewFax_ToFront.isSelected()) {
            n |= 2;
        }
        if (this.checkNewFax_Open.isSelected()) {
            n |= 4;
        }
        if (this.checkNewFax_MarkAsRead.isSelected()) {
            n |= 8;
        }
        if (this.checkNewFax_BlinkTrayIcon.isSelected()) {
            n |= 0x10;
        }
        faxOptions.newFaxAction = n;
        faxOptions.newFaxTrayNotification = this.checkNewFax_TrayNotification.isSelected();
        faxOptions.dateStyle = this.getDateStyle(this.comboDateFormat);
        faxOptions.timeStyle = this.getDateStyle(this.comboTimeFormat);
    }

    @Override
    public boolean validateSettings(OptionsWin optionsWin) {
        DateFormat dateFormat;
        try {
            dateFormat = DateStyle.getDateFormatFromString(this.getDateStyle(this.comboDateFormat));
            dateFormat.format(new Date());
        }
        catch (Exception exception) {
            optionsWin.focusComponent(this.comboDateFormat);
            JOptionPane.showMessageDialog(this, Utils._("Please enter a valid date format:") + '\n' + exception.getMessage(), Utils._("Error"), 0);
            return false;
        }
        try {
            dateFormat = DateStyle.getTimeFormatFromString(this.getDateStyle(this.comboTimeFormat));
            dateFormat.format(new Date());
        }
        catch (Exception exception) {
            optionsWin.focusComponent(this.comboTimeFormat);
            JOptionPane.showMessageDialog(this, Utils._("Please enter a valid time format.") + '\n' + exception.getMessage(), Utils._("Error"), 0);
            return false;
        }
        return true;
    }

    private void setDateStyle(JComboBox jComboBox, String string, DateStyle[] dateStyleArray) {
        Object object = string;
        for (DateStyle dateStyle : dateStyleArray) {
            if (!dateStyle.getSaveString().equals(object)) continue;
            object = dateStyle;
            break;
        }
        jComboBox.setSelectedItem(object);
    }

    private String getDateStyle(JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        if (object instanceof DateStyle) {
            return ((DateStyle)object).getSaveString();
        }
        return object.toString();
    }

    static void refreshLF() {
        for (Frame frame : Frame.getFrames()) {
            SwingUtilities.updateComponentTreeUI(frame);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LF_Entry {
        public String name;
        public String className;

        public LF_Entry(String string, String string2) {
            this.name = string;
            this.className = string2;
        }

        public LF_Entry(UIManager.LookAndFeelInfo lookAndFeelInfo) {
            this(lookAndFeelInfo.getName(), lookAndFeelInfo.getClassName());
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LF_Entry) {
                return ((LF_Entry)object).className.equals(this.className);
            }
            if (object instanceof String) {
                return object.equals(this.className);
            }
            return false;
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        public static Vector<LF_Entry> getLookAndFeelList() {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            Vector<LF_Entry> vector = new Vector<LF_Entry>(lookAndFeelInfoArray.length + 2);
            vector.add(new LF_Entry(Utils._("(System native)"), "!system!"));
            vector.add(new LF_Entry(Utils._("(Crossplatform)"), "!crossplatform!"));
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray) {
                vector.add(new LF_Entry(lookAndFeelInfo));
            }
            return vector;
        }
    }
}

