/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import yajhfc.FaxOptions;
import yajhfc.Utils;
import yajhfc.file.ExternalProcessConverter;
import yajhfc.file.FileConverter;
import yajhfc.file.FileConverters;
import yajhfc.file.FileFormat;
import yajhfc.options.AbstractOptionsPanel;
import yajhfc.options.OptionsWin;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.SafeJFileChooser;
import yajhfc.util.URIClickListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertersPage
extends AbstractOptionsPanel<FaxOptions> {
    ConverterTableModel tableModel;
    JTable formatsTable;
    private static final String WIKI_URL = "http://www.yajhfc.de/documentation/wiki/91-using-custom-file-filters";

    public ConvertersPage() {
        super(new BorderLayout());
    }

    @Override
    protected void createOptionsUI() {
        this.tableModel = new ConverterTableModel(FileConverters.getFileConverters());
        this.formatsTable = new JTable(this.tableModel);
        this.formatsTable.setDefaultRenderer(Row.class, new RowRenderer());
        this.formatsTable.setDefaultEditor(Row.class, new RowEditor());
        this.formatsTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.formatsTable.getColumnModel().getColumn(0).setMaxWidth(100);
        this.formatsTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        JLabel jLabel = new JLabel(Utils._("For information on how to use this page, please see the Wiki at:"));
        JLabel jLabel2 = new JLabel("<html><a href=\"http://www.yajhfc.de/documentation/wiki/91-using-custom-file-filters\">http://www.yajhfc.de/documentation/wiki/91-using-custom-file-filters</a></html>");
        jLabel2.addMouseListener(new URIClickListener(WIKI_URL));
        jLabel2.setCursor(Cursor.getPredefinedCursor(12));
        Box box = Box.createVerticalBox();
        box.add(jLabel);
        box.add(jLabel2);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        this.add((Component)box, "North");
        this.add((Component)new JScrollPane(this.formatsTable), "Center");
    }

    @Override
    public void loadSettings(FaxOptions faxOptions) {
        for (Map.Entry<String, String> entry : faxOptions.customFileConverters.entrySet()) {
            FileFormat fileFormat = Enum.valueOf(FileFormat.class, entry.getKey());
            this.tableModel.setCommandLine(fileFormat, entry.getValue());
        }
    }

    @Override
    public void saveSettings(FaxOptions faxOptions) {
        faxOptions.customFileConverters.clear();
        for (Row row : this.tableModel.getRows()) {
            if (!row.hasCommandLine()) continue;
            faxOptions.customFileConverters.put(row.format.name(), row.commandLine);
        }
        FileConverters.invalidateFileConverters();
    }

    @Override
    public boolean validateSettings(OptionsWin optionsWin) {
        if (this.formatsTable.isEditing()) {
            this.formatsTable.getCellEditor().stopCellEditing();
        }
        return true;
    }

    static class RowEditor
    extends DefaultCellEditor {
        Action browseAction = new ExcDialogAbstractAction("..."){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                String string = RowEditor.this.textField.getText();
                String string2 = Utils.extractExecutableFromCmdLine(string);
                JFileChooser jFileChooser = RowEditor.this.getFileChooser();
                jFileChooser.setSelectedFile(new File(string2));
                if (jFileChooser.showOpenDialog(RowEditor.this.getComponent()) == 0) {
                    string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                    if (string2.contains(" ")) {
                        RowEditor.this.textField.setText("\"" + string2 + "\" \"%s\"");
                    } else {
                        RowEditor.this.textField.setText(string2 + " \"%s\"");
                    }
                }
            }
        };
        private JFileChooser fileChooser;
        JTextField textField;

        JFileChooser getFileChooser() {
            if (this.fileChooser == null) {
                this.fileChooser = new SafeJFileChooser();
            }
            return this.fileChooser;
        }

        public RowEditor() {
            super(new JTextField());
            JPanel jPanel = new JPanel(new BorderLayout(), false);
            this.textField = (JTextField)this.editorComponent;
            this.textField.setBorder(null);
            this.textField.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
            jPanel.add((Component)this.textField, "Center");
            jPanel.add((Component)new JButton(this.browseAction), "East");
            this.editorComponent = jPanel;
        }
    }

    static class RowRenderer
    extends DefaultTableCellRenderer {
        Font italicFont;
        Font normalFont = UIManager.getFont("Table.font");
        boolean fontLock = false;

        public void setFont(Font font) {
            if (this.fontLock) {
                return;
            }
            super.setFont(font);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Row row = (Row)object;
            String string = null;
            if (object != null) {
                if (row.hasCommandLine()) {
                    string = row.commandLine;
                    this.setForeground(UIManager.getColor("textText"));
                    this.setFont(this.normalFont);
                } else {
                    string = row.defaultValue;
                    this.setForeground(UIManager.getColor("textInactiveText"));
                    this.setFont(this.italicFont);
                }
            }
            this.fontLock = true;
            Component component = super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            this.fontLock = false;
            return component;
        }

        public RowRenderer() {
            this.italicFont = this.normalFont.deriveFont(2);
        }
    }

    public static class Row {
        public final FileFormat format;
        public final String defaultValue;
        public String commandLine = null;
        public final boolean changeable;
        public final FileConverter defaultConverter;

        public String toString() {
            return this.commandLine;
        }

        public boolean hasCommandLine() {
            return this.commandLine != null && this.commandLine.length() > 0;
        }

        Row(FileFormat fileFormat, FileConverter fileConverter, MessageFormat messageFormat) {
            ExternalProcessConverter externalProcessConverter;
            this.format = fileFormat;
            if (fileConverter instanceof ExternalProcessConverter && (externalProcessConverter = (ExternalProcessConverter)fileConverter).isUserDefined()) {
                this.commandLine = externalProcessConverter.getCommandLine();
                fileConverter = externalProcessConverter.getInternalConverter();
            }
            if (fileConverter == null) {
                this.defaultValue = Utils._("(none)");
                this.changeable = true;
            } else {
                this.changeable = fileConverter.isOverridable();
                this.defaultValue = messageFormat.format(new Object[]{fileConverter == FileConverter.IDENTITY_CONVERTER ? "IDENTITY_CONVERTER" : fileConverter.getClass().getSimpleName()});
            }
            this.defaultConverter = fileConverter;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ConverterTableModel
    extends AbstractTableModel {
        private static final String[] columns = new String[]{Utils._("File format"), Utils._("Converter")};
        protected final Row[] rows;

        @Override
        public int getColumnCount() {
            return columns.length;
        }

        @Override
        public String getColumnName(int n) {
            return columns[n];
        }

        @Override
        public int getRowCount() {
            return this.rows.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.rows[n].format;
                }
                case 1: {
                    return this.rows[n];
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Row row = this.rows[n];
            switch (n2) {
                case 1: {
                    if (!row.changeable) break;
                    row.commandLine = object.toString();
                    this.fireTableCellUpdated(n, n2);
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            switch (n2) {
                case 0: {
                    return false;
                }
                case 1: {
                    return this.rows[n].changeable;
                }
            }
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return FileFormat.class;
                }
                case 1: {
                    return Row.class;
                }
            }
            return Object.class;
        }

        public Row[] getRows() {
            return this.rows;
        }

        public int indexOf(FileFormat fileFormat) {
            for (int i = 0; i < this.rows.length; ++i) {
                if (this.rows[i].format != fileFormat) continue;
                return i;
            }
            return -1;
        }

        public void setCommandLine(FileFormat fileFormat, String string) {
            int n = this.indexOf(fileFormat);
            if (n >= 0) {
                this.rows[n].commandLine = string;
                this.fireTableCellUpdated(n, 1);
            }
        }

        public ConverterTableModel(Map<FileFormat, FileConverter> map) {
            FileFormat[] fileFormatArray = FileFormat.values();
            this.rows = new Row[fileFormatArray.length - 1];
            MessageFormat messageFormat = new MessageFormat(Utils._("(internal {0})"));
            int n = 0;
            for (FileFormat fileFormat : fileFormatArray) {
                if (fileFormat == FileFormat.Unknown) continue;
                this.rows[n++] = new Row(fileFormat, map.get((Object)fileFormat), messageFormat);
            }
        }
    }
}

