/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.options;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import yajhfc.FileTextField;
import yajhfc.IDAndNameOptions;
import yajhfc.SenderIdentity;
import yajhfc.Utils;
import yajhfc.faxcover.Faxcover;
import yajhfc.options.AbstractOptionsPanel;
import yajhfc.options.CoverPanel;
import yajhfc.options.OptionsWin;
import yajhfc.phonebook.PBEntryField;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ComponentEnabler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityPanel
extends AbstractOptionsPanel<SenderIdentity> {
    Map<PBEntryField, JTextComponent> entryFields = new EnumMap<PBEntryField, JTextComponent>(PBEntryField.class);
    JTextField textName;
    JTextField textID;
    FileTextField ftfCustomDefCover;
    JCheckBox checkUseCustomDefCover;
    final CoverPanel parent;
    SenderIdentity idEdit;

    public IdentityPanel(CoverPanel coverPanel) {
        super(new BorderLayout());
        this.parent = coverPanel;
    }

    private JTextField createEntryTextField(PBEntryField pBEntryField) {
        JTextField jTextField = new JTextField();
        jTextField.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.entryFields.put(pBEntryField, jTextField);
        return jTextField;
    }

    private JPanel createTopPanel() {
        double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0, -2.0, 5.0}, {5.0, -2.0, -2.0, 5.0, -2.0}};
        JPanel jPanel = new JPanel(new TableLayout(dArrayArray));
        this.textName = new JTextField();
        this.textID = new JTextField("#####");
        this.textID.setEditable(false);
        Utils.addWithLabel(jPanel, (Component)this.textName, Utils._("Name for this identity:"), "1,2");
        Utils.addWithLabel(jPanel, (Component)this.textID, Utils._("ID:"), "3,2");
        jPanel.add((Component)new JSeparator(), "0,4,4,4");
        return jPanel;
    }

    @Override
    protected void createOptionsUI() {
        this.add((Component)this.createTopPanel(), "North");
        this.add((Component)this.createDataPanel(), "Center");
    }

    private JPanel createDataPanel() {
        int n;
        PBEntryField[] pBEntryFieldArray;
        int n2 = 0;
        int n3 = 0;
        PBEntryField[] pBEntryFieldArray2 = pBEntryFieldArray = PBEntryField.values();
        int n4 = pBEntryFieldArray2.length;
        for (n = 0; n < n4; ++n) {
            PBEntryField pBEntryField = pBEntryFieldArray2[n];
            if (pBEntryField.isShortLength()) {
                ++n3;
                continue;
            }
            ++n2;
        }
        int n5 = 5 + 3 * (n2 - 1 + (n3 + 1) / 2);
        double[][] dArrayArray = new double[][]{{5.0, 0.5, 5.0, -1.0, 5.0}, new double[n5]};
        for (n = 0; n < n5 - 1; ++n) {
            dArrayArray[1][n] = n % 3 == 0 ? 5.0 : -2.0;
        }
        dArrayArray[1][n5 - 1] = -1.0;
        JPanel jPanel = new JPanel(new TableLayout(dArrayArray), false);
        int n6 = 2;
        int n7 = 1;
        for (PBEntryField pBEntryField : pBEntryFieldArray) {
            TableLayoutConstraints tableLayoutConstraints;
            if (pBEntryField == PBEntryField.Comment) continue;
            JTextField jTextField = this.createEntryTextField(pBEntryField);
            if (pBEntryField.isShortLength()) {
                tableLayoutConstraints = new TableLayoutConstraints(n7, n6, n7, n6, 2, 1);
                if (n7 == 1) {
                    n7 = 3;
                } else {
                    n6 += 3;
                    n7 = 1;
                }
            } else {
                tableLayoutConstraints = new TableLayoutConstraints(1, n6, 3, n6, 2, 1);
                n7 = 1;
                n6 += 3;
            }
            Utils.addWithLabel(jPanel, (Component)jTextField, pBEntryField.getDescription() + ":", tableLayoutConstraints);
        }
        this.checkUseCustomDefCover = new JCheckBox(Utils._("Use a custom default cover page:"));
        this.ftfCustomDefCover = new FileTextField();
        this.ftfCustomDefCover.getJTextField().addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.ftfCustomDefCover.setFileFilters(Faxcover.getAcceptedFileFilters());
        this.ftfCustomDefCover.setEnabled(false);
        ComponentEnabler.installOn(this.checkUseCustomDefCover, true, this.ftfCustomDefCover);
        jPanel.add((Component)this.checkUseCustomDefCover, new TableLayoutConstraints(1, n6 - 1, 3, n6 - 1, 2, 1));
        jPanel.add((Component)this.ftfCustomDefCover, new TableLayoutConstraints(1, n6, 3, n6, 2, 1));
        return jPanel;
    }

    @Override
    public void loadSettings(SenderIdentity senderIdentity) {
        this.idEdit = senderIdentity;
        this.textName.setText(senderIdentity.name);
        this.textID.setText(String.valueOf(senderIdentity.id));
        this.ftfCustomDefCover.setText(senderIdentity.defaultCover);
        this.checkUseCustomDefCover.setSelected(senderIdentity.useCustomDefaultCover);
        for (Map.Entry<PBEntryField, JTextComponent> entry : this.entryFields.entrySet()) {
            entry.getValue().setText(senderIdentity.getField(entry.getKey()));
        }
    }

    @Override
    public void saveSettings(SenderIdentity senderIdentity) {
        senderIdentity.name = this.textName.getText();
        senderIdentity.defaultCover = this.ftfCustomDefCover.getText();
        senderIdentity.useCustomDefaultCover = this.checkUseCustomDefCover.isSelected();
        for (Map.Entry<PBEntryField, JTextComponent> entry : this.entryFields.entrySet()) {
            senderIdentity.setField(entry.getKey(), entry.getValue().getText());
        }
    }

    @Override
    public boolean validateSettings(OptionsWin optionsWin) {
        SenderIdentity senderIdentity = IDAndNameOptions.getItemByName(this.parent.getListModel().getList(), this.textName.getText());
        if (senderIdentity != null && senderIdentity.id != this.idEdit.id) {
            this.textName.requestFocusInWindow();
            JOptionPane.showMessageDialog(this, Utils._("There already exists another identity with this name!"), Utils._("Error"), 0);
            return false;
        }
        if (this.checkUseCustomDefCover.isSelected() && !new File(this.ftfCustomDefCover.getText()).canRead()) {
            optionsWin.focusComponent(this.ftfCustomDefCover.getJTextField());
            JOptionPane.showMessageDialog(optionsWin, Utils._("The selected default cover page can not be read."), Utils._("Error"), 0);
            return false;
        }
        return true;
    }
}

