/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.options;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import yajhfc.Utils;
import yajhfc.options.OptionsPageWrapper;
import yajhfc.options.OptionsWin;
import yajhfc.options.PanelTreeNode;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ListListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiEditPanel<T>
extends JPanel
implements OptionsPageWrapper.Callback<T> {
    PanelTreeNode settingsNode;
    JList list;
    Action actAdd;
    Action actRemove;
    Action actEdit;
    Action actDuplicate;
    Action actUp;
    Action actDown;
    Action actSort;
    ListListModel<T> itemsListModel;
    public static final Comparator<Object> LEXICAL_CASE_INSENSITIVE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            return object.toString().compareToIgnoreCase(object2.toString());
        }
    };

    public MultiEditPanel() {
        this(new ListListModel(new ArrayList()));
    }

    public MultiEditPanel(ListListModel<T> listListModel) {
        this.itemsListModel = listListModel;
        this.initialize();
    }

    public ListListModel<T> getItemsListModel() {
        return this.itemsListModel;
    }

    public PanelTreeNode getSettingsNode() {
        return this.settingsNode;
    }

    public void setSettingsNode(PanelTreeNode panelTreeNode) {
        this.settingsNode = panelTreeNode;
        panelTreeNode.initializeChildren();
    }

    protected abstract String getDeletePrompt(T var1);

    protected abstract String getDeletePrompt(int[] var1);

    protected abstract T createNewItem();

    protected abstract T duplicateItem(T var1);

    protected abstract PanelTreeNode createChildNode(T var1);

    protected abstract void updateChildNode(PanelTreeNode var1, T var2);

    private void initialize() {
        double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0, -2.0, 5.0}, {5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, -1.0, 5.0}};
        this.setLayout(new TableLayout(dArrayArray));
        this.list = new JList<T>(this.itemsListModel);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    MultiEditPanel.this.checkEnable();
                }
            }
        });
        this.actAdd = new ExcDialogAbstractAction(Utils._("Add"), Utils.loadIcon("general/Add")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                MultiEditPanel.this.itemsListModel.add(MultiEditPanel.this.createNewItem());
                MultiEditPanel.this.list.setSelectedIndex(MultiEditPanel.this.itemsListModel.getSize() - 1);
            }
        };
        this.actDuplicate = new ExcDialogAbstractAction(Utils._("Duplicate"), Utils.loadIcon("general/Copy")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                Object t = MultiEditPanel.this.getSelectedItem();
                if (t != null) {
                    MultiEditPanel.this.itemsListModel.add(MultiEditPanel.this.duplicateItem(t));
                    MultiEditPanel.this.list.setSelectedIndex(MultiEditPanel.this.itemsListModel.getSize() - 1);
                }
            }
        };
        this.actRemove = new ExcDialogAbstractAction(Utils._("Remove"), Utils.loadIcon("general/Delete")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                int[] nArray = MultiEditPanel.this.list.getSelectedIndices();
                if (nArray.length == 0 || MultiEditPanel.this.itemsListModel.getSize() <= 1) {
                    return;
                }
                String string = nArray.length == 1 ? MultiEditPanel.this.getDeletePrompt(MultiEditPanel.this.itemsListModel.getList().get(nArray[0])) : MultiEditPanel.this.getDeletePrompt(nArray);
                if (JOptionPane.showConfirmDialog(MultiEditPanel.this, string, Utils._("Remove"), 0) == 0) {
                    MultiEditPanel.this.itemsListModel.removeAll(nArray);
                }
            }
        };
        this.actEdit = new ExcDialogAbstractAction(Utils._("Edit") + "...", Utils.loadIcon("general/Edit")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                int n = MultiEditPanel.this.list.getSelectedIndex();
                OptionsWin optionsWin = (OptionsWin)SwingUtilities.getWindowAncestor(MultiEditPanel.this);
                if (n < 0 || optionsWin == null) {
                    return;
                }
                optionsWin.selectNode(MultiEditPanel.this.settingsNode.getChildren().get(n));
            }
        };
        this.actDown = new ExcDialogAbstractAction(Utils._("Down"), Utils.loadIcon("navigation/Down")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                int n = MultiEditPanel.this.list.getSelectedIndex();
                if (n < 0 || n > MultiEditPanel.this.itemsListModel.getSize() - 2) {
                    return;
                }
                MultiEditPanel.this.itemsListModel.moveDown(new int[]{n});
            }
        };
        this.actUp = new ExcDialogAbstractAction(Utils._("Up"), Utils.loadIcon("navigation/Up")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                int n = MultiEditPanel.this.list.getSelectedIndex();
                if (n < 1) {
                    return;
                }
                MultiEditPanel.this.itemsListModel.moveUp(new int[]{n});
            }
        };
        this.actSort = new ExcDialogAbstractAction(Utils._("Sort"), Utils.loadIcon("text/AlignJustify")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                MultiEditPanel.this.itemsListModel.sort(LEXICAL_CASE_INSENSITIVE_COMPARATOR);
            }
        };
        this.itemsListModel.addListDataListener(new ListDataListener(){

            public void intervalRemoved(ListDataEvent listDataEvent) {
                List<PanelTreeNode> list = MultiEditPanel.this.settingsNode.getChildren().subList(listDataEvent.getIndex0(), listDataEvent.getIndex1() + 1);
                int[] nArray = new int[list.size()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = i + listDataEvent.getIndex0();
                }
                Object[] objectArray = list.toArray();
                list.clear();
                MultiEditPanel.this.settingsNode.getTreeModel().nodesWereRemoved(MultiEditPanel.this.settingsNode, nArray, objectArray);
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                int n = listDataEvent.getIndex1() - listDataEvent.getIndex0() + 1;
                ArrayList<PanelTreeNode> arrayList = new ArrayList<PanelTreeNode>(n);
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    int n2;
                    nArray[i] = n2 = i + listDataEvent.getIndex0();
                    arrayList.add(MultiEditPanel.this.createChildNode(MultiEditPanel.this.itemsListModel.getList().get(n2)));
                }
                MultiEditPanel.this.settingsNode.getChildren().addAll(listDataEvent.getIndex0(), arrayList);
                MultiEditPanel.this.settingsNode.getTreeModel().nodesWereInserted(MultiEditPanel.this.settingsNode, nArray);
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                int n = listDataEvent.getIndex1() - listDataEvent.getIndex0() + 1;
                int[] nArray = new int[n];
                List<PanelTreeNode> list = MultiEditPanel.this.settingsNode.getChildren();
                for (int i = 0; i < n; ++i) {
                    int n2;
                    nArray[i] = n2 = i + listDataEvent.getIndex0();
                    MultiEditPanel.this.updateChildNode(list.get(n2), MultiEditPanel.this.itemsListModel.get(n2));
                }
                MultiEditPanel.this.settingsNode.getTreeModel().nodesChanged(MultiEditPanel.this.settingsNode, nArray);
            }
        });
        this.add((Component)new JScrollPane(this.list), "1,1,1,14,f,f");
        this.add((Component)new JButton(this.actAdd), "3,1");
        this.add((Component)new JButton(this.actDuplicate), "3,3");
        this.add((Component)new JButton(this.actEdit), "3,5");
        this.add((Component)new JButton(this.actUp), "3,7");
        this.add((Component)new JButton(this.actDown), "3,9");
        this.add((Component)new JButton(this.actSort), "3,11");
        this.add((Component)new JButton(this.actRemove), "3,13");
        this.checkEnable();
    }

    protected void checkEnable() {
        int n = this.list.getSelectedIndex();
        int n2 = this.itemsListModel.getSize();
        boolean bl = n >= 0;
        boolean bl2 = bl && n2 > 1;
        this.actDuplicate.setEnabled(bl);
        this.actRemove.setEnabled(bl2);
        this.actEdit.setEnabled(bl);
        this.actDown.setEnabled(bl && n < n2 - 1);
        this.actUp.setEnabled(n > 0);
    }

    @Override
    public void elementSaved(OptionsPageWrapper<T> optionsPageWrapper) {
        this.itemsListModel.changeNotify(optionsPageWrapper.getOptions());
    }

    public T getSelectedItem() {
        return (T)this.list.getSelectedValue();
    }
}

