/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.OverlayLayout;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import yajhfc.FaxOptions;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.JobFormat;
import yajhfc.model.RecvFormat;
import yajhfc.model.jobq.QueueFileFormat;
import yajhfc.options.AdminSettingsPage;
import yajhfc.options.CommonPanel;
import yajhfc.options.ConvertersPage;
import yajhfc.options.CoverPanel;
import yajhfc.options.FmtEditorPanel;
import yajhfc.options.LabelOptionsPage;
import yajhfc.options.PanelTreeNode;
import yajhfc.options.PathAndViewPanel;
import yajhfc.options.PluginPanel;
import yajhfc.options.ServerSettingsPanel;
import yajhfc.options.TextExtractorPanel;
import yajhfc.plugin.PluginManager;
import yajhfc.plugin.PluginUI;
import yajhfc.util.CancelAction;
import yajhfc.util.ExceptionDialog;

public class OptionsWin
extends JDialog {
    JPanel jContentPane = null;
    CommonPanel panelCommon;
    JPanel panelButtons;
    JButton buttonOK;
    JButton buttonCancel;
    JPanel panelPaths;
    JTree mainTree;
    PanelTreeNode rootNode;
    PanelTreeNode serverSettingsNode;
    JLabel treeSelLabel;
    JPanel tabPanel;
    FaxOptions foToEdit = null;
    PanelTreeNode selectedNode = null;
    boolean modalResult;
    public static final int border = 5;

    public boolean getModalResult() {
        return this.modalResult;
    }

    private void initialize() {
        this.setResizable(true);
        this.setTitle(Utils._("Options"));
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJContentPane());
        this.modalResult = false;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                OptionsWin.this.foToEdit.optWinBounds = OptionsWin.this.getBounds();
                if (OptionsWin.this.panelCommon.changedLF && !OptionsWin.this.modalResult) {
                    Utils.setLookAndFeel(OptionsWin.this.foToEdit.lookAndFeel);
                }
            }
        });
        if (this.foToEdit.optWinBounds != null) {
            this.setBounds(this.foToEdit.optWinBounds);
        } else {
            this.setSize(800, 600);
            Utils.setDefWinPos(this);
        }
        String string = this.foToEdit.servers.get((int)0).host;
        if (string == null || string.length() == 0) {
            if (this.serverSettingsNode.isLeaf()) {
                this.mainTree.setSelectionPath(new TreePath(new Object[]{this.rootNode, this.serverSettingsNode}));
            } else {
                this.mainTree.setSelectionPath(new TreePath(new Object[]{this.rootNode, this.serverSettingsNode, this.serverSettingsNode.getChildAt(0)}));
            }
        } else {
            this.mainTree.setSelectionRow(0);
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.jContentPane, 1));
            JComponent jComponent = this.getMainPanel();
            jComponent.setAlignmentX(0.0f);
            this.jContentPane.add(jComponent);
            jComponent = new JSeparator();
            jComponent.setAlignmentX(0.0f);
            this.jContentPane.add(jComponent);
            this.jContentPane.add(Box.createRigidArea(new Dimension(0, 5)));
            jComponent = this.getPanelButtons();
            jComponent.setAlignmentX(0.0f);
            this.jContentPane.add(jComponent);
        }
        return this.jContentPane;
    }

    private JPanel getPanelButtons() {
        if (this.panelButtons == null) {
            this.panelButtons = new JPanel(false);
            this.panelButtons.setLayout(new BoxLayout(this.panelButtons, 2));
            Dimension dimension = new Dimension(120, 30);
            this.panelButtons.add(Box.createHorizontalGlue());
            this.buttonOK = new JButton(Utils._("OK"));
            this.buttonOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (OptionsWin.this.saveSettings(OptionsWin.this.foToEdit)) {
                        OptionsWin.this.modalResult = true;
                        OptionsWin.this.dispose();
                    }
                }
            });
            this.buttonOK.setPreferredSize(dimension);
            this.panelButtons.add(this.buttonOK);
            this.panelButtons.add(Box.createRigidArea(new Dimension(5, 5)));
            CancelAction cancelAction = new CancelAction(this);
            this.buttonCancel = cancelAction.createCancelButton();
            this.buttonCancel.setPreferredSize(dimension);
            this.panelButtons.add(this.buttonCancel);
            this.panelButtons.add(Box.createRigidArea(new Dimension(5, 5)));
        }
        return this.panelButtons;
    }

    private void createRootNode() {
        this.rootNode = new PanelTreeNode(null, null, "root", null){

            public DefaultTreeModel getTreeModel() {
                return (DefaultTreeModel)OptionsWin.this.mainTree.getModel();
            }
        };
        this.panelCommon = new CommonPanel(this);
        PanelTreeNode panelTreeNode = new PanelTreeNode(this.rootNode, this.panelCommon, Utils._("General"), Utils.loadIcon("general/Preferences"));
        this.rootNode.addChild(panelTreeNode);
        PathAndViewPanel pathAndViewPanel = new PathAndViewPanel();
        PanelTreeNode panelTreeNode2 = new PanelTreeNode(this.rootNode, pathAndViewPanel, Utils._("Paths and viewers"), Utils.loadIcon("development/Host"));
        this.rootNode.addChild(panelTreeNode2);
        panelTreeNode2.addChild(new PanelTreeNode(panelTreeNode2, new TextExtractorPanel(pathAndViewPanel), Utils._("Recipient extraction"), Utils.loadCustomIcon("extract_recipient.gif")));
        ServerSettingsPanel serverSettingsPanel = new ServerSettingsPanel();
        this.serverSettingsNode = new PanelTreeNode(this.rootNode, serverSettingsPanel, Utils._("Servers"), Utils.loadCustomIcon("servers.png"));
        this.rootNode.addChild(this.serverSettingsNode);
        CoverPanel coverPanel = new CoverPanel();
        PanelTreeNode panelTreeNode3 = new PanelTreeNode(this.rootNode, coverPanel, Utils._("Cover page & Identities"), Utils.loadCustomIcon("envelopes.png"));
        this.rootNode.addChild(panelTreeNode3);
        serverSettingsPanel.setIdentitiesModel(coverPanel.getListModel());
        PanelTreeNode panelTreeNode4 = new PanelTreeNode(this.rootNode, new PluginPanel(), Utils._("Plugins & JDBC"), Utils.loadIcon("development/Jar"));
        this.rootNode.addChild(panelTreeNode4);
        PanelTreeNode panelTreeNode5 = new PanelTreeNode(this.rootNode, new LabelOptionsPage(Utils._("Please select on the left which table you want to edit.")), Utils._("Tables"), null);
        MessageFormat messageFormat = new MessageFormat(Utils._("Table \"{0}\""));
        panelTreeNode5.addChild(new PanelTreeNode(panelTreeNode5, new FmtEditorPanel((FmtItem[])RecvFormat.values(), "recvfmt"), Utils._("Received"), Utils.loadCustomIcon("received.gif"), messageFormat.format(new Object[]{Utils._("Received")})));
        panelTreeNode5.addChild(new PanelTreeNode(panelTreeNode5, new FmtEditorPanel((FmtItem[])JobFormat.values(), "sentfmt"), Utils._("Sent"), Utils.loadCustomIcon("sent.gif"), messageFormat.format(new Object[]{Utils._("Sent")})));
        panelTreeNode5.addChild(new PanelTreeNode(panelTreeNode5, new FmtEditorPanel((FmtItem[])JobFormat.values(), "sendingfmt"), Utils._("Transmitting"), Utils.loadCustomIcon("sending.gif"), messageFormat.format(new Object[]{Utils._("Transmitting")})));
        panelTreeNode5.addChild(new PanelTreeNode(panelTreeNode5, new FmtEditorPanel((FmtItem[])QueueFileFormat.values(), "archiveFmt"), Utils._("Archive"), Utils.loadCustomIcon("archive.gif"), messageFormat.format(new Object[]{Utils._("Archive")})));
        this.rootNode.addChild(panelTreeNode5);
        PanelTreeNode panelTreeNode6 = new PanelTreeNode(this.rootNode, new LabelOptionsPage(Utils._("These settings normally need not to be changed.")), Utils._("Advanced settings"), null);
        panelTreeNode6.addChild(new PanelTreeNode(panelTreeNode6, new AdminSettingsPage(this), Utils._("Administrative settings"), Utils.loadCustomIcon("adminsettings.gif")));
        panelTreeNode6.addChild(new PanelTreeNode(panelTreeNode6, new ConvertersPage(), Utils._("File converters"), Utils.loadCustomIcon("customfilters.png")));
        for (PluginUI pluginUI : PluginManager.pluginUIs) {
            try {
                PanelTreeNode panelTreeNode7;
                PanelTreeNode panelTreeNode8;
                switch (pluginUI.getOptionsPanelParent()) {
                    case 1: {
                        panelTreeNode8 = panelTreeNode6;
                        break;
                    }
                    case 5: {
                        panelTreeNode8 = panelTreeNode3;
                        break;
                    }
                    case 2: {
                        panelTreeNode8 = panelTreeNode;
                        break;
                    }
                    case 3: {
                        panelTreeNode8 = panelTreeNode2;
                        break;
                    }
                    case 6: {
                        panelTreeNode8 = panelTreeNode4;
                        break;
                    }
                    case 4: {
                        panelTreeNode8 = this.serverSettingsNode;
                        break;
                    }
                    case 7: {
                        panelTreeNode8 = panelTreeNode5;
                        break;
                    }
                    default: {
                        panelTreeNode8 = this.rootNode;
                    }
                }
                if ((panelTreeNode7 = pluginUI.createOptionsPanel(panelTreeNode8)) == null) continue;
                panelTreeNode8.addChild(panelTreeNode7);
            }
            catch (Exception exception) {
                Logger.getLogger(OptionsWin.class.getName()).log(Level.SEVERE, "Error creating options panel " + pluginUI, exception);
            }
        }
        if (panelTreeNode6.getChildCount() > 0) {
            this.rootNode.addChild(panelTreeNode6);
        }
    }

    private JComponent getMainPanel() {
        this.createRootNode();
        this.mainTree = new JTree(new DefaultTreeModel(this.rootNode));
        this.mainTree.setRootVisible(false);
        this.mainTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                PanelTreeNode panelTreeNode = (PanelTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
                if (panelTreeNode != null && panelTreeNode != OptionsWin.this.selectedNode) {
                    if (OptionsWin.this.selectedNode != null) {
                        if (!OptionsWin.this.selectedNode.getOptionsPage().pageIsHidden(OptionsWin.this)) {
                            OptionsWin.this.mainTree.setSelectionPath(treeSelectionEvent.getOldLeadSelectionPath());
                            return;
                        }
                        OptionsWin.this.selectedNode.getOptionsPage().getPanel().setVisible(false);
                    }
                    if (!panelTreeNode.settingsAndUILoaded) {
                        JComponent jComponent = panelTreeNode.getOptionsPage().getPanel();
                        OptionsWin.this.tabPanel.add(jComponent);
                        jComponent.setVisible(true);
                        jComponent.setOpaque(true);
                        panelTreeNode.getOptionsPage().loadSettings(OptionsWin.this.foToEdit);
                        panelTreeNode.settingsAndUILoaded = true;
                    } else {
                        panelTreeNode.getOptionsPage().getPanel().setVisible(true);
                    }
                    panelTreeNode.getOptionsPage().pageIsShown(OptionsWin.this);
                    OptionsWin.this.treeSelLabel.setText(panelTreeNode.getLongLabel());
                    OptionsWin.this.selectedNode = panelTreeNode;
                }
            }
        });
        this.mainTree.setCellRenderer(new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                PanelTreeNode panelTreeNode = (PanelTreeNode)object;
                if (panelTreeNode.getIcon() != null) {
                    this.setIcon(panelTreeNode.getIcon());
                }
                return this;
            }
        });
        this.mainTree.addMouseListener(new MouseAdapter(){

            private void maybeShowPopup(MouseEvent mouseEvent) {
                PanelTreeNode panelTreeNode;
                TreePath treePath;
                if (mouseEvent.isPopupTrigger() && (treePath = OptionsWin.this.mainTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && (panelTreeNode = (PanelTreeNode)treePath.getLastPathComponent()).getPopupMenu() != null) {
                    OptionsWin.this.mainTree.setSelectionPath(treePath);
                    panelTreeNode.getPopupMenu().show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }
        });
        this.mainTree.getSelectionModel().setSelectionMode(1);
        this.mainTree.setRowHeight(20);
        this.mainTree.setAlignmentX(0.0f);
        this.tabPanel = new JPanel(false);
        this.tabPanel.setLayout(new OverlayLayout(this.tabPanel));
        this.initializeTree(this.rootNode, null);
        this.tabPanel.setMinimumSize(new Dimension(0, 0));
        this.treeSelLabel = new JLabel("Current selection");
        this.treeSelLabel.setFont(this.treeSelLabel.getFont().deriveFont(1, 16.0f));
        this.treeSelLabel.setHorizontalAlignment(2);
        this.treeSelLabel.setHorizontalTextPosition(2);
        this.treeSelLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.treeSelLabel.setAlignmentX(0.0f);
        this.tabPanel.setAlignmentX(0.0f);
        Box box = Box.createVerticalBox();
        box.add(this.treeSelLabel);
        box.add(new JSeparator(0));
        box.add(this.tabPanel);
        JSplitPane jSplitPane = new JSplitPane(1, new JScrollPane(this.mainTree), box);
        jSplitPane.setDividerLocation(this.mainTree.getPreferredSize().width + 8);
        return jSplitPane;
    }

    private void initializeTree(PanelTreeNode panelTreeNode, TreePath treePath) {
        if (panelTreeNode.getOptionsPage() != null) {
            panelTreeNode.getOptionsPage().initializeTreeNode(panelTreeNode, this.foToEdit);
        }
        if (panelTreeNode.getChildren() != null) {
            TreePath treePath2 = treePath == null ? new TreePath(panelTreeNode) : treePath.pathByAddingChild(panelTreeNode);
            for (PanelTreeNode panelTreeNode2 : panelTreeNode.getChildren()) {
                this.initializeTree(panelTreeNode2, treePath2);
            }
            this.mainTree.expandPath(treePath2);
        }
    }

    public OptionsWin(FaxOptions faxOptions, Frame frame) {
        super(frame);
        this.foToEdit = faxOptions;
        this.initialize();
    }

    public void reloadSettings(FaxOptions faxOptions) {
        this.reloadSettings(this.rootNode, faxOptions);
    }

    private void reloadSettings(PanelTreeNode panelTreeNode, FaxOptions faxOptions) {
        if (panelTreeNode.settingsAndUILoaded) {
            panelTreeNode.getOptionsPage().loadSettings(faxOptions);
        }
        if (panelTreeNode.getChildren() != null) {
            for (PanelTreeNode panelTreeNode2 : panelTreeNode.getChildren()) {
                this.reloadSettings(panelTreeNode2, faxOptions);
            }
        }
    }

    public boolean saveSettings(FaxOptions faxOptions) {
        if (this.selectedNode != null && !this.selectedNode.getOptionsPage().pageIsHidden(this)) {
            return false;
        }
        if (!this.validateInput(this.rootNode)) {
            return false;
        }
        try {
            this.saveSettings(faxOptions, this.rootNode);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog(this, Utils._("Error saving the settings:"), exception);
            return false;
        }
        return true;
    }

    private void saveSettings(FaxOptions faxOptions, PanelTreeNode panelTreeNode) {
        if (panelTreeNode.settingsAndUILoaded) {
            panelTreeNode.getOptionsPage().saveSettings(faxOptions);
        }
        if (panelTreeNode.getChildren() != null) {
            for (PanelTreeNode panelTreeNode2 : panelTreeNode.getChildren()) {
                this.saveSettings(faxOptions, panelTreeNode2);
            }
        }
    }

    private boolean validateInput(PanelTreeNode panelTreeNode) {
        if (panelTreeNode.settingsAndUILoaded && !panelTreeNode.getOptionsPage().validateSettings(this)) {
            return false;
        }
        if (panelTreeNode.getChildren() != null) {
            for (PanelTreeNode panelTreeNode2 : panelTreeNode.getChildren()) {
                if (this.validateInput(panelTreeNode2)) continue;
                return false;
            }
        }
        return true;
    }

    private TreePath getPathToNode(TreeNode treeNode) {
        if (treeNode == this.rootNode) {
            return new TreePath(treeNode);
        }
        return this.getPathToNode(treeNode.getParent()).pathByAddingChild(treeNode);
    }

    public void selectNode(TreeNode treeNode) {
        this.mainTree.setSelectionPath(this.getPathToNode(treeNode));
    }

    public TreePath getSelectedPath() {
        return this.mainTree.getSelectionPath();
    }

    public void focusComponent(Component component) {
        this.focusTab(component);
        component.requestFocusInWindow();
    }

    private void focusTab(Component component) {
        Container container = component.getParent();
        if (container == null || container instanceof Window) {
            return;
        }
        if (container == this.tabPanel) {
            this.selectTreeNodeForPanel(this.rootNode, component, null);
        } else {
            this.focusTab(container);
        }
    }

    private void selectTreeNodeForPanel(PanelTreeNode panelTreeNode, Component component, TreePath treePath) {
        TreePath treePath2;
        TreePath treePath3 = treePath2 = treePath == null ? new TreePath(panelTreeNode) : treePath.pathByAddingChild(panelTreeNode);
        if (panelTreeNode.settingsAndUILoaded && panelTreeNode.getOptionsPage().getPanel() == component) {
            this.mainTree.setSelectionPath(treePath2);
        } else if (panelTreeNode.getChildren() != null) {
            for (PanelTreeNode panelTreeNode2 : panelTreeNode.getChildren()) {
                this.selectTreeNodeForPanel(panelTreeNode2, component, treePath2);
            }
        }
    }

    public PanelTreeNode getRootNode() {
        return this.rootNode;
    }
}

