/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.options;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import yajhfc.FaxOptions;
import yajhfc.Utils;
import yajhfc.model.IconMap;
import yajhfc.options.AbstractOptionsPanel;
import yajhfc.plugin.PluginManager;
import yajhfc.plugin.PluginTableModel;
import yajhfc.plugin.PluginType;
import yajhfc.util.ExampleFileFilter;
import yajhfc.util.JTableTABAction;
import yajhfc.util.SafeJFileChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginPanel
extends AbstractOptionsPanel<FaxOptions> {
    JTable tablePlugins;
    PluginTableModel pluginTableModel;
    JButton buttonAddJDBC;
    JButton buttonAddPlugin;
    JButton buttonRemovePlugin;

    public PluginPanel() {
        super(false);
    }

    @Override
    public void loadSettings(FaxOptions faxOptions) {
        this.pluginTableModel.addAllItems(PluginManager.getKnownPlugins());
    }

    @Override
    public void saveSettings(FaxOptions faxOptions) {
        if (PluginManager.updatePluginList(this.pluginTableModel.getEntries())) {
            JOptionPane.showMessageDialog(this, Utils._("You will need to restart the program for the changes to the list of plugins and JDBC drivers to take full effect."), Utils._("Plugins & JDBC"), 1);
        }
    }

    @Override
    protected void createOptionsUI() {
        double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0, -2.0, 5.0}, {5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -1.0, 5.0}};
        this.setLayout(new TableLayout(dArrayArray));
        this.pluginTableModel = new PluginTableModel();
        this.tablePlugins = new JTable(this.pluginTableModel);
        this.tablePlugins.setDefaultRenderer(IconMap.class, new IconMap.TableCellRenderer());
        this.tablePlugins.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = PluginPanel.this.tablePlugins.getSelectedRow();
                    PluginPanel.this.buttonRemovePlugin.setEnabled(n >= 0);
                }
            }
        });
        this.tablePlugins.getColumnModel().getColumn(0).setPreferredWidth(300);
        JTableTABAction.replaceTABWithNextRow(this.tablePlugins);
        JScrollPane jScrollPane = new JScrollPane(this.tablePlugins);
        ActionListener actionListener = new ActionListener(){
            JFileChooser fileChooser;

            private File chooseFile(String string) {
                if (this.fileChooser == null) {
                    this.fileChooser = new SafeJFileChooser();
                    this.fileChooser.setAcceptAllFileFilterUsed(false);
                    this.fileChooser.addChoosableFileFilter(new ExampleFileFilter("jar", Utils._("JAR files")));
                }
                this.fileChooser.setDialogTitle(string);
                if (this.fileChooser.showOpenDialog(PluginPanel.this) == 0) {
                    return this.fileChooser.getSelectedFile();
                }
                return null;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("addJDBC")) {
                    File file = this.chooseFile(Utils._("Add JDBC driver"));
                    if (file == null) {
                        return;
                    }
                    PluginPanel.this.pluginTableModel.addItem(file, PluginType.JDBCDRIVER);
                } else if (string.equals("addPlugin")) {
                    File file = this.chooseFile(Utils._("Add plugin"));
                    if (file == null) {
                        return;
                    }
                    if (!PluginManager.isValidPlugin(file)) {
                        JOptionPane.showMessageDialog(PluginPanel.this, MessageFormat.format(Utils._("The file {0} is not a valid YajHFC plugin!"), file), Utils._("Add plugin"), 2);
                        return;
                    }
                    PluginPanel.this.pluginTableModel.addItem(file, PluginType.PLUGIN);
                } else if (string.equals("remove")) {
                    int n = PluginPanel.this.tablePlugins.getSelectedRow();
                    if (n >= 0) {
                        PluginPanel.this.pluginTableModel.removeItemAt(n);
                    }
                } else assert (false);
            }
        };
        this.buttonAddJDBC = new JButton(Utils._("Add JDBC driver") + "...", Utils.loadIcon("development/JarAdd"));
        this.buttonAddJDBC.addActionListener(actionListener);
        this.buttonAddJDBC.setActionCommand("addJDBC");
        this.buttonAddPlugin = new JButton(Utils._("Add plugin") + "...", Utils.loadIcon("development/J2EEApplicationClientAdd"));
        this.buttonAddPlugin.addActionListener(actionListener);
        this.buttonAddPlugin.setActionCommand("addPlugin");
        this.buttonRemovePlugin = new JButton(Utils._("Remove item"), Utils.loadIcon("general/Remove"));
        this.buttonRemovePlugin.addActionListener(actionListener);
        this.buttonRemovePlugin.setActionCommand("remove");
        this.buttonRemovePlugin.setEnabled(false);
        this.add((Component)jScrollPane, "1,1,1,7,f,f");
        this.add((Component)this.buttonAddPlugin, "3,1");
        this.add((Component)this.buttonAddJDBC, "3,3");
        this.add((Component)this.buttonRemovePlugin, "3,5");
    }
}

