/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.options;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import yajhfc.FaxOptions;
import yajhfc.IDAndNameOptions;
import yajhfc.SenderIdentity;
import yajhfc.Utils;
import yajhfc.cache.Cache;
import yajhfc.model.servconn.FaxListConnectionType;
import yajhfc.options.AbstractOptionsPanel;
import yajhfc.options.ModemsPanel;
import yajhfc.options.MultiEditPanel;
import yajhfc.options.OptionsPageWrapper;
import yajhfc.options.OptionsWin;
import yajhfc.options.PanelTreeNode;
import yajhfc.options.SendPanel;
import yajhfc.options.SingleServerSettingsPanel;
import yajhfc.server.ServerOptions;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ListListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSettingsPanel
extends AbstractOptionsPanel<FaxOptions> {
    JCheckBox checkPCLBug;
    JSpinner spinSocketTimeout;
    JSpinner spinStatusInterval;
    JSpinner spinTableInterval;
    JPanel panelGlobal;
    private MultiEditPanel<ServerOptions> panelServers;
    JCheckBox checkUseCache;
    Action actClearCache;
    JLabel labelCacheSize;
    SingleServerSettingsPanel singleServerPanel = new SingleServerSettingsPanel(this);
    ModemsPanel modemPanel = new ModemsPanel();
    SendPanel sendPanel = new SendPanel();

    public ServerSettingsPanel() {
        super(false);
    }

    public ListListModel<ServerOptions> getServers() {
        return this.getPanelServers().itemsListModel;
    }

    void updateCacheSize() {
        long l = 0L;
        for (ServerOptions serverOptions : this.getServers()) {
            l += Cache.getCacheLocation(serverOptions.id).length();
        }
        this.labelCacheSize.setText(MessageFormat.format(Utils._("{0} KB"), (l + 512L) / 1024L));
    }

    @Override
    protected void createOptionsUI() {
        double[][] dArrayArray = new double[][]{{5.0, -2.0, 5.0, -1.0, 5.0}, {5.0, -2.0, 5.0, -2.0, -1.0, 5.0}};
        this.setLayout(new TableLayout(dArrayArray));
        this.add((Component)this.getPanelGlobal(), "1,1,1,1,f,f");
        this.add((Component)this.createPanelCache(), "1,3,1,3,f,f");
        this.add(this.getPanelServers(), "3,1,3,4,f,f");
    }

    @Override
    public void loadSettings(FaxOptions faxOptions) {
        this.checkPCLBug.setSelected(faxOptions.pclBug);
        this.spinTableInterval.setValue((double)faxOptions.tableUpdateInterval / 1000.0);
        this.spinStatusInterval.setValue((double)faxOptions.statusUpdateInterval / 1000.0);
        this.spinSocketTimeout.setValue((double)faxOptions.socketTimeout / 1000.0);
        this.checkUseCache.setSelected(faxOptions.useFaxListCache);
        this.updateCacheSize();
    }

    @Override
    public void saveSettings(FaxOptions faxOptions) {
        faxOptions.tableUpdateInterval = (int)((Double)this.spinTableInterval.getValue() * 1000.0);
        faxOptions.statusUpdateInterval = (int)((Double)this.spinStatusInterval.getValue() * 1000.0);
        faxOptions.socketTimeout = (int)((Double)this.spinSocketTimeout.getValue() * 1000.0);
        faxOptions.pclBug = this.checkPCLBug.isSelected();
        faxOptions.useFaxListCache = this.checkUseCache.isSelected();
        this.panelServers.saveSettingsCalled(null, faxOptions);
    }

    @Override
    public void initializeTreeNode(PanelTreeNode panelTreeNode, FaxOptions faxOptions) {
        this.getPanelServers().setSettingsNode(panelTreeNode);
        ListListModel<ServerOptions> listListModel = this.getServers();
        listListModel.clear();
        for (ServerOptions serverOptions : faxOptions.servers) {
            listListModel.add(new ServerOptions(serverOptions));
        }
        if (listListModel.getSize() == 0) {
            ServerOptions serverOptions = new ServerOptions(faxOptions);
            serverOptions.name = Utils._("Default");
            listListModel.add(serverOptions);
        }
    }

    public void setIdentitiesModel(ListListModel<SenderIdentity> listListModel) {
        this.sendPanel.setIdentitiesModel(listListModel);
    }

    private MultiEditPanel<ServerOptions> getPanelServers() {
        if (this.panelServers == null) {
            this.panelServers = new MultiEditPanel<ServerOptions>(){
                MessageFormat serverFormat = new MessageFormat(Utils._("Server {0}"));
                MessageFormat modemFormat = new MessageFormat(Utils._("Modems for server {0}"));
                MessageFormat sendFormat = new MessageFormat(Utils._("Delivery settings for server {0}"));
                private boolean listSaved = false;

                @Override
                protected PanelTreeNode createChildNode(ServerOptions serverOptions) {
                    String string = serverOptions.toString();
                    PanelTreeNode panelTreeNode = new PanelTreeNode(this.settingsNode, new OptionsPageWrapper<ServerOptions>(ServerSettingsPanel.this.singleServerPanel, serverOptions, this), string, Utils.loadIcon("development/Server"), this.serverFormat.format(new Object[]{string}));
                    if (serverOptions.faxListConnectionType != FaxListConnectionType.SRFAX) {
                        panelTreeNode.addChild(new PanelTreeNode(panelTreeNode, new OptionsPageWrapper<ServerOptions>(ServerSettingsPanel.this.sendPanel, serverOptions, this), Utils._("Delivery"), Utils.loadIcon("general/SendMail"), this.sendFormat.format(new Object[]{string})));
                        panelTreeNode.addChild(new PanelTreeNode(panelTreeNode, new OptionsPageWrapper<ServerOptions>(ServerSettingsPanel.this.modemPanel, serverOptions, this), Utils._("Modems"), Utils.loadCustomIcon("modem.png"), this.modemFormat.format(new Object[]{string})));
                    }
                    return panelTreeNode;
                }

                @Override
                protected void updateChildNode(PanelTreeNode panelTreeNode, ServerOptions serverOptions) {
                    String string = serverOptions.toString();
                    panelTreeNode.setLabel(string);
                    Object[] objectArray = new Object[]{string};
                    FieldPosition fieldPosition = new FieldPosition(0);
                    StringBuffer stringBuffer = new StringBuffer();
                    panelTreeNode.setLongLabel(this.serverFormat.format((Object)objectArray, stringBuffer, fieldPosition).toString());
                    if (serverOptions.faxListConnectionType != FaxListConnectionType.SRFAX) {
                        stringBuffer.setLength(0);
                        panelTreeNode.getChildren().get(0).setLongLabel(this.sendFormat.format((Object)objectArray, stringBuffer, fieldPosition).toString());
                        stringBuffer.setLength(0);
                        panelTreeNode.getChildren().get(1).setLongLabel(this.modemFormat.format((Object)objectArray, stringBuffer, fieldPosition).toString());
                    }
                }

                @Override
                protected ServerOptions createNewItem() {
                    return new ServerOptions(Utils.getFaxOptions());
                }

                @Override
                protected ServerOptions duplicateItem(ServerOptions serverOptions) {
                    ServerOptions serverOptions2 = new ServerOptions(serverOptions);
                    serverOptions2.generateNewID();
                    serverOptions2.name = MessageFormat.format(Utils._("Copy of {0}"), serverOptions2.name);
                    return serverOptions2;
                }

                @Override
                protected String getDeletePrompt(ServerOptions serverOptions) {
                    return MessageFormat.format(Utils._("Do you really want to remove the server \"{0}\"?"), serverOptions);
                }

                @Override
                protected String getDeletePrompt(int[] nArray) {
                    return MessageFormat.format(Utils._("Do you really want to remove the selected {0} servers?"), nArray.length);
                }

                @Override
                public void saveSettingsCalled(OptionsPageWrapper<ServerOptions> optionsPageWrapper, FaxOptions faxOptions) {
                    if (this.listSaved) {
                        return;
                    }
                    ListListModel listListModel = this.itemsListModel;
                    faxOptions.servers.clear();
                    faxOptions.servers.addAll(listListModel.getList());
                    this.listSaved = true;
                }

                @Override
                public boolean validateSettingsCalled(OptionsPageWrapper<ServerOptions> optionsPageWrapper, OptionsWin optionsWin) {
                    List list = this.itemsListModel.getList();
                    if (list.size() == 0) {
                        JOptionPane.showMessageDialog(optionsWin, "Need at least one server!");
                        return false;
                    }
                    if (IDAndNameOptions.checkForDuplicates(list)) {
                        JOptionPane.showMessageDialog(optionsWin, "Duplicate IDs found, please cancel this dialog (should never happen)!");
                        return false;
                    }
                    return true;
                }
            };
            this.panelServers.setBorder(BorderFactory.createTitledBorder(Utils._("Servers")));
        }
        return this.panelServers;
    }

    private JPanel createPanelCache() {
        this.actClearCache = new ExcDialogAbstractAction(Utils._("Clear cache")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                for (ServerOptions serverOptions : ServerSettingsPanel.this.getServers()) {
                    Cache.getCacheLocation(serverOptions.id).delete();
                }
                Cache.useForNextLogin = false;
                ServerSettingsPanel.this.updateCacheSize();
            }
        };
        this.checkUseCache = new JCheckBox(Utils._("Locally cache fax lists"));
        this.labelCacheSize = new JLabel("XXX");
        double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0}, {5.0, -2.0, 5.0, -2.0, -2.0, 5.0, -2.0, -1.0, 5.0}};
        JPanel jPanel = new JPanel(new TableLayout(dArrayArray), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(Utils._("Cache settings")));
        jPanel.add((Component)this.checkUseCache, "1,1");
        jPanel.add((Component)new JLabel(Utils._("Current Cache size:")), "1,3");
        jPanel.add((Component)this.labelCacheSize, "1,4");
        jPanel.add((Component)new JButton(this.actClearCache), "1,6");
        return jPanel;
    }

    private JPanel getPanelGlobal() {
        if (this.panelGlobal == null) {
            double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0}, new double[22]};
            dArrayArray[1][21] = -1.0;
            for (int i = 0; i < 21; ++i) {
                dArrayArray[1][i] = i % 3 == 0 ? 5.0 : -2.0;
            }
            this.panelGlobal = new JPanel(new TableLayout(dArrayArray), false);
            this.panelGlobal.setBorder(BorderFactory.createTitledBorder(Utils._("Global settings")));
            this.checkPCLBug = new JCheckBox("<html>" + Utils._("Use PCL file type bugfix") + "</html>");
            this.spinStatusInterval = new JSpinner(new SpinnerNumberModel(1.0, 0.5, 86400.0, 1.0));
            this.spinTableInterval = new JSpinner(new SpinnerNumberModel(3.0, 0.5, 86400.0, 1.0));
            this.spinSocketTimeout = new JSpinner(new SpinnerNumberModel(90.0, 0.0, 86400.0, 1.0));
            this.spinSocketTimeout.setToolTipText(Utils._("The maximum time to wait for a interaction with the server to complete. Values below 5 are not recommended; 0 disables this timeout."));
            this.panelGlobal.add((Component)this.checkPCLBug, "1, 2");
            Utils.addWithLabel(this.panelGlobal, (Component)this.spinTableInterval, "<html>" + Utils._("Table refresh interval (secs.):") + "</html>", "1, 5, 1, 5 f, c");
            Utils.addWithLabel(this.panelGlobal, (Component)this.spinStatusInterval, "<html>" + Utils._("Server status refresh interval (secs.):") + "</html>", "1, 8, 1, 8, f, c");
            Utils.addWithLabel(this.panelGlobal, (Component)this.spinSocketTimeout, "<html>" + Utils._("Server socket timeout (secs):") + "</html>", "1, 11, 1, 11, f, c");
        }
        return this.panelGlobal;
    }
}

