/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.options;

import com.google.gson.JsonObject;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import yajhfc.FaxTimezone;
import yajhfc.FileTextField;
import yajhfc.HylaClientManager;
import yajhfc.IDAndNameOptions;
import yajhfc.Utils;
import yajhfc.model.servconn.FaxListConnectionType;
import yajhfc.options.AbstractOptionsPanel;
import yajhfc.options.OptionsWin;
import yajhfc.options.ServerSettingsPanel;
import yajhfc.server.ServerOptions;
import yajhfc.ui.swing.SwingYajOptionPane;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ComponentEnabler;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ProgressDialog;
import yajhfc.util.ProgressWorker;
import yajhfc.util.SRFaxAPI;
import yajhfc.util.SpinnerDateOffsetEditor;
import yajhfc.virtualcolumnstore.AvailablePersistenceMethod;
import yajhfc.virtualcolumnstore.VirtColPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleServerSettingsPanel
extends AbstractOptionsPanel<ServerOptions> {
    JPanel panelPersistence;
    JPanel panelServer;
    JPanel panelServerRetrieval;
    JPanel panelSRFax;
    Map<String, String> persistenceConfigs = new HashMap<String, String>();
    JPasswordField textAdminPassword;
    JTextField textHost;
    JPasswordField textPassword;
    JTextField textPort;
    JTextField textUser;
    JTextField textDayRange;
    JCheckBox checkAskAdminPassword;
    JCheckBox checkAskPassword;
    JCheckBox checkAskUsername;
    JCheckBox checkPasv;
    JCheckBox checkUseDisconnected;
    JCheckBox checkShowRead;
    JCheckBox checkShowUnread;
    JCheckBox checkIncludeSubUsers;
    JSpinner spinOffset;
    JComboBox comboPersistenceMethods;
    JButton buttonConfigPersistence;
    Action actTestConnection;
    JComboBox comboCharset;
    JComboBox comboTZone;
    JCheckBox checkUseArchive;
    FileTextField ftfArchiveLocation;
    JLabel archiveLabel;
    FileTextField ftfSpoolLocation;
    JButton configButton;
    Map<FaxListConnectionType, String> configs = new EnumMap<FaxListConnectionType, String>(FaxListConnectionType.class);
    JComboBox comboConnectionType;
    JLabel labelSpoolLocation;
    JLabel hostLbl;
    JLabel portLbl;
    JLabel usernameLbl;
    JTextField textName;
    JTextField textID;
    final ServerSettingsPanel parent;
    ServerOptions soEdit;

    public SingleServerSettingsPanel(ServerSettingsPanel serverSettingsPanel) {
        super(false);
        this.parent = serverSettingsPanel;
    }

    @Override
    protected void createOptionsUI() {
        double[][] dArrayArray = new double[][]{{5.0, 0.4, 5.0, -1.0, 5.0, -2.0, 5.0}, {5.0, -2.0, -2.0, 5.0, -2.0, 5.0, -1.0, 5.0}};
        this.setLayout(new TableLayout(dArrayArray));
        this.textName = new JTextField();
        this.textID = new JTextField("#####");
        this.textID.setEditable(false);
        Utils.addWithLabel((JPanel)this, (Component)this.textName, Utils._("Name for this server:"), "1,2,3,2,f,c");
        Utils.addWithLabel((JPanel)this, (Component)this.textID, Utils._("ID:"), "5,2,f,c");
        this.add((Component)this.getPanelServerRetrieval(), "1,4,1,4,f,t");
        this.add((Component)this.getPanelServer(), "3,4,5,4,f,t");
        this.add((Component)this.createPanelConnectionType(), "3,6,5,6,f,t");
        this.add((Component)this.getPanelPersistence(), "1,6,1,6,f,t");
        this.add((Component)this.getPanelSRFax(), "1,4,1,4,f,t");
    }

    @Override
    public void loadSettings(ServerOptions serverOptions) {
        this.soEdit = serverOptions;
        this.textName.setText(serverOptions.name);
        this.textID.setText(String.valueOf(serverOptions.id));
        this.textUser.setText(serverOptions.user);
        this.textPassword.setText(serverOptions.pass.getPassword());
        this.textAdminPassword.setText(serverOptions.AdminPassword.getPassword());
        this.persistenceConfigs.clear();
        this.persistenceConfigs.put(serverOptions.persistenceMethod, serverOptions.persistenceConfig);
        int n = 0;
        for (int i = 0; i < VirtColPersister.persistenceMethods.size(); ++i) {
            if (!VirtColPersister.persistenceMethods.get(i).getKey().equals(serverOptions.persistenceMethod)) continue;
            n = i;
            break;
        }
        this.comboPersistenceMethods.setSelectedIndex(n);
        this.comboCharset.setSelectedItem(Charset.forName(serverOptions.hylaFAXCharacterEncoding));
        this.comboTZone.setSelectedItem((Object)serverOptions.tzone);
        this.checkPasv.setSelected(serverOptions.pasv);
        this.checkAskPassword.setSelected(serverOptions.askPassword);
        this.checkAskAdminPassword.setSelected(serverOptions.askAdminPassword);
        this.checkAskUsername.setSelected(serverOptions.askUsername);
        this.checkUseDisconnected.setSelected(serverOptions.useDisconnectedMode);
        this.spinOffset.setValue(serverOptions.dateOffsetSecs);
        this.checkUseArchive.setSelected(serverOptions.showArchive);
        this.ftfArchiveLocation.setText(serverOptions.archiveLocation);
        this.comboConnectionType.setSelectedItem((Object)serverOptions.faxListConnectionType);
        this.ftfSpoolLocation.setText(serverOptions.directAccessSpoolPath);
        if (serverOptions.faxListConnectionType == FaxListConnectionType.SRFAX) {
            this.textHost.setText(serverOptions.SRFaxEmail);
            this.textPort.setText(String.valueOf(serverOptions.SRFaxNumber));
            this.textDayRange.setText(serverOptions.SRFaxDayRange + "");
            this.checkShowRead.setSelected(serverOptions.SRFaxShowRead);
            this.checkShowUnread.setSelected(serverOptions.SRFaxShowUnread);
            this.checkIncludeSubUsers.setSelected(serverOptions.SRFaxIncludeSubUsers);
        } else {
            this.textHost.setText(serverOptions.host);
            this.textPort.setText(String.valueOf(serverOptions.port));
        }
        this.configs.put(serverOptions.faxListConnectionType, serverOptions.connectionConfig);
        this.checkEnable();
    }

    @Override
    public void saveSettings(ServerOptions serverOptions) {
        this.saveSettingsWithOutPersistence(serverOptions);
        String string = ((AvailablePersistenceMethod)this.comboPersistenceMethods.getSelectedItem()).getKey();
        String string2 = this.persistenceConfigs.get(string);
        if (string2 == null) {
            string2 = "";
        }
        serverOptions.persistenceMethod = string;
        serverOptions.persistenceConfig = string2;
        serverOptions.showArchive = this.checkUseArchive.isSelected();
        serverOptions.archiveLocation = this.ftfArchiveLocation.getText();
        serverOptions.faxListConnectionType = (FaxListConnectionType)((Object)this.comboConnectionType.getSelectedItem());
        serverOptions.directAccessSpoolPath = this.ftfSpoolLocation.getText();
        serverOptions.connectionConfig = this.configs.get((Object)serverOptions.faxListConnectionType);
    }

    protected void saveSettingsWithOutPersistence(ServerOptions serverOptions) {
        if ((FaxListConnectionType)((Object)this.comboConnectionType.getSelectedItem()) == FaxListConnectionType.SRFAX) {
            serverOptions.host = "srfax.com";
            serverOptions.SRFaxEmail = this.textHost.getText();
            serverOptions.SRFaxNumber = this.textPort.getText().trim();
            serverOptions.SRFaxDayRange = Integer.parseInt(this.textDayRange.getText().trim());
            serverOptions.SRFaxShowRead = this.checkShowRead.isSelected();
            serverOptions.SRFaxShowUnread = this.checkShowUnread.isSelected();
            serverOptions.SRFaxIncludeSubUsers = this.checkIncludeSubUsers.isSelected();
        } else {
            serverOptions.host = this.textHost.getText();
            serverOptions.port = Integer.parseInt(this.textPort.getText().trim());
        }
        serverOptions.dateOffsetSecs = (Integer)this.spinOffset.getValue();
        serverOptions.name = this.textName.getText();
        serverOptions.user = this.textUser.getText();
        serverOptions.pass.setPassword(new String(this.textPassword.getPassword()));
        serverOptions.AdminPassword.setPassword(new String(this.textAdminPassword.getPassword()));
        serverOptions.pasv = this.checkPasv.isSelected();
        serverOptions.askPassword = this.checkAskPassword.isSelected();
        serverOptions.askAdminPassword = this.checkAskAdminPassword.isSelected();
        serverOptions.askUsername = this.checkAskUsername.isSelected();
        serverOptions.useDisconnectedMode = this.checkUseDisconnected.isSelected();
        serverOptions.hylaFAXCharacterEncoding = ((Charset)this.comboCharset.getSelectedItem()).name();
        serverOptions.tzone = (FaxTimezone)((Object)this.comboTZone.getSelectedItem());
    }

    @Override
    public boolean validateSettings(OptionsWin optionsWin) {
        File file;
        ServerOptions serverOptions = IDAndNameOptions.getItemByName(this.parent.getServers().getList(), this.textName.getText());
        if (serverOptions != null && serverOptions.id != this.soEdit.id) {
            this.textName.requestFocusInWindow();
            JOptionPane.showMessageDialog(this, Utils._("There already exists another server with this name!"), Utils._("Error"), 0);
            return false;
        }
        if (this.textHost.getText().length() == 0) {
            this.textHost.requestFocusInWindow();
            JOptionPane.showMessageDialog(this, Utils._("Please enter a host name."), Utils._("Error"), 0);
            return false;
        }
        if (this.textUser.getText().length() == 0) {
            this.textUser.requestFocusInWindow();
            JOptionPane.showMessageDialog(this, Utils._("Please enter a user name."), Utils._("Error"), 0);
            return false;
        }
        String string = this.textPort.getText();
        boolean bl = true;
        if (string.length() == 0) {
            bl = false;
        } else {
            try {
                int n = Integer.parseInt(string);
                bl = n > 0 && n < 65536;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        if (!bl && this.comboConnectionType.getSelectedItem() != FaxListConnectionType.SRFAX) {
            this.textPort.requestFocusInWindow();
            JOptionPane.showMessageDialog(this, Utils._("Please enter a valid port number."), Utils._("Error"), 0);
            return false;
        }
        if (this.comboConnectionType.getSelectedItem() == FaxListConnectionType.SRFAX) {
            if (string.trim().length() != 10) {
                JOptionPane.showMessageDialog(this, Utils._("Please enter a 10 digit number."), Utils._("Error"), 0);
                return false;
            }
            if (!this.checkShowRead.isSelected() && !this.checkShowUnread.isSelected()) {
                JOptionPane.showMessageDialog(this, Utils._("Please select read and/or unread faxes."), Utils._("Error"), 0);
                return false;
            }
            try {
                Long.parseLong(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, Utils._("Please enter a 10 digit number."), Utils._("Error"), 0);
                return false;
            }
            try {
                Integer.parseInt(this.textDayRange.getText());
            }
            catch (Exception exception) {
                this.textDayRange.requestFocusInWindow();
                JOptionPane.showMessageDialog(this, Utils._("Please enter a valid number of days."), Utils._("Error"), 0);
                return false;
            }
        }
        if (this.checkUseArchive.isSelected() && !(file = new File(this.ftfArchiveLocation.getText())).exists()) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Utils._("Directory {0} does not exist!"), file), Utils._("Archive directory"), 0);
            this.ftfArchiveLocation.getJTextField().requestFocusInWindow();
            return false;
        }
        if (this.comboConnectionType.getSelectedItem() == FaxListConnectionType.DIRECTACCESS) {
            File[] fileArray;
            File file2 = new File(this.ftfSpoolLocation.getText());
            for (File file3 : fileArray = new File[]{file2, new File(file2, "recvq"), new File(file2, "doneq"), new File(file2, "docq")}) {
                if (file3.exists()) continue;
                JOptionPane.showMessageDialog(this, MessageFormat.format(Utils._("Directory {0} does not exist!"), file3), Utils._("Invalid spool directory"), 0);
                this.ftfSpoolLocation.getJTextField().requestFocusInWindow();
                return false;
            }
        }
        return true;
    }

    private JPanel createPanelConnectionType() {
        this.ftfSpoolLocation = new FileTextField();
        this.ftfSpoolLocation.setFileSelectionMode(1);
        this.ftfSpoolLocation.getJTextField().addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.comboConnectionType = new JComboBox<FaxListConnectionType>(FaxListConnectionType.values());
        this.comboConnectionType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = SingleServerSettingsPanel.this.comboConnectionType.getSelectedItem();
                boolean bl = object == FaxListConnectionType.DIRECTACCESS;
                boolean bl2 = ((FaxListConnectionType)((Object)object)).canConfigure();
                SingleServerSettingsPanel.this.ftfSpoolLocation.setEnabled(bl);
                SingleServerSettingsPanel.this.labelSpoolLocation.setEnabled(bl);
                SingleServerSettingsPanel.this.ftfSpoolLocation.setVisible(bl);
                SingleServerSettingsPanel.this.labelSpoolLocation.setVisible(bl);
                SingleServerSettingsPanel.this.configButton.setVisible(bl2);
                SingleServerSettingsPanel.this.configButton.setEnabled(bl2);
                if (object == FaxListConnectionType.SRFAX) {
                    SingleServerSettingsPanel.this.hostLbl.setText(Utils._("SRFax Email Address:"));
                    SingleServerSettingsPanel.this.portLbl.setText(Utils._("SRFax Fax Number:"));
                    SingleServerSettingsPanel.this.usernameLbl.setText(Utils._("SRFax Account Number:"));
                    SingleServerSettingsPanel.this.panelServerRetrieval.setVisible(false);
                    SingleServerSettingsPanel.this.panelPersistence.setVisible(false);
                    SingleServerSettingsPanel.this.panelSRFax.setVisible(true);
                    SingleServerSettingsPanel.this.checkPasv.setEnabled(false);
                    SingleServerSettingsPanel.this.checkUseArchive.setSelected(false);
                    SingleServerSettingsPanel.this.checkUseArchive.setEnabled(false);
                    SingleServerSettingsPanel.this.textDayRange.setText(SingleServerSettingsPanel.this.soEdit.SRFaxDayRange + "");
                    SingleServerSettingsPanel.this.textPort.setText(SingleServerSettingsPanel.this.soEdit.SRFaxNumber);
                    SingleServerSettingsPanel.this.checkAskAdminPassword.setSelected(true);
                    SingleServerSettingsPanel.this.checkAskAdminPassword.setEnabled(false);
                    SingleServerSettingsPanel.this.textHost.setText(SingleServerSettingsPanel.this.soEdit.SRFaxEmail);
                } else {
                    SingleServerSettingsPanel.this.hostLbl.setText(Utils._("Host name:"));
                    SingleServerSettingsPanel.this.portLbl.setText(Utils._("Port:"));
                    SingleServerSettingsPanel.this.usernameLbl.setText(Utils._("Username:"));
                    SingleServerSettingsPanel.this.panelServerRetrieval.setVisible(true);
                    SingleServerSettingsPanel.this.panelPersistence.setVisible(true);
                    SingleServerSettingsPanel.this.panelSRFax.setVisible(false);
                    SingleServerSettingsPanel.this.checkPasv.setEnabled(true);
                    SingleServerSettingsPanel.this.checkUseArchive.setEnabled(true);
                    SingleServerSettingsPanel.this.textPort.setText(SingleServerSettingsPanel.this.soEdit.port + "");
                    SingleServerSettingsPanel.this.checkAskAdminPassword.setEnabled(true);
                    SingleServerSettingsPanel.this.textHost.setText(SingleServerSettingsPanel.this.soEdit.host);
                }
            }
        });
        this.checkUseArchive = new JCheckBox(Utils._("Show archive table"));
        this.checkUseArchive.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SingleServerSettingsPanel.this.checkEnable();
            }
        });
        this.ftfArchiveLocation = new FileTextField();
        this.ftfArchiveLocation.setFileSelectionMode(1);
        this.ftfArchiveLocation.getJTextField().addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.configButton = new JButton(Utils._("Configure access method..."));
        this.configButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FaxListConnectionType faxListConnectionType = (FaxListConnectionType)((Object)SingleServerSettingsPanel.this.comboConnectionType.getSelectedItem());
                String string = faxListConnectionType.showConfigDialog(SwingUtilities.getWindowAncestor(SingleServerSettingsPanel.this), SingleServerSettingsPanel.this.configs.get((Object)faxListConnectionType));
                if (string != null) {
                    SingleServerSettingsPanel.this.configs.put(faxListConnectionType, string);
                }
            }
        });
        this.configButton.setVisible(false);
        double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0}, {5.0, -2.0, -2.0, 5.0, -2.0, -2.0, 5.0, -2.0, 5.0, -2.0, -2.0, -1.0, 5.0}};
        JPanel jPanel = new JPanel(new TableLayout(dArrayArray), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(Utils._("Fax lists")));
        Utils.addWithLabel(jPanel, (Component)this.comboConnectionType, Utils._("Access method for the fax lists"), "1,2");
        this.labelSpoolLocation = Utils.addWithLabel(jPanel, (Component)this.ftfSpoolLocation, Utils._("Location of spool directory for direct access (must contain recvq, doneq and docq)"), "1,5");
        jPanel.add((Component)this.configButton, "1,4,1,5,f,f");
        jPanel.add((Component)this.checkUseArchive, "1,7");
        this.archiveLabel = Utils.addWithLabel(jPanel, (Component)this.ftfArchiveLocation, Utils._("Location of archive directory:"), "1,10,1,10,f,f");
        return jPanel;
    }

    private JPanel getPanelServer() {
        if (this.panelServer == null) {
            double[][] dArrayArray = new double[][]{{5.0, 0.22, 5.0, 0.22, 5.0, -1.0, 5.0, -2.0, 5.0}, new double[20]};
            for (int i = 0; i < 19; ++i) {
                dArrayArray[1][i] = i % 3 == 0 ? 5.0 : -2.0;
            }
            dArrayArray[1][13] = 0.0;
            dArrayArray[1][16] = 0.0;
            dArrayArray[1][19] = -1.0;
            this.panelServer = new JPanel(new TableLayout(dArrayArray), false);
            this.panelServer.setBorder(BorderFactory.createTitledBorder(Utils._("Connection settings:")));
            this.textHost = new JTextField();
            this.textHost.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
            this.textPort = new JTextField();
            this.textPort.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
            this.textUser = new JTextField();
            this.textUser.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
            this.textPassword = new JPasswordField();
            this.textAdminPassword = new JPasswordField();
            this.checkAskPassword = new JCheckBox(Utils._("Always ask"));
            ComponentEnabler.installOn(this.checkAskPassword, false, this.textPassword);
            this.checkAskAdminPassword = new JCheckBox(Utils._("Always ask"));
            ComponentEnabler.installOn(this.checkAskAdminPassword, false, this.textAdminPassword);
            this.checkAskUsername = new JCheckBox(Utils._("Always ask"));
            this.checkAskUsername.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (SingleServerSettingsPanel.this.checkAskUsername.isSelected()) {
                        SingleServerSettingsPanel.this.checkAskPassword.setSelected(true);
                        SingleServerSettingsPanel.this.checkAskAdminPassword.setSelected(true);
                        SingleServerSettingsPanel.this.checkAskPassword.setEnabled(false);
                        SingleServerSettingsPanel.this.checkAskAdminPassword.setEnabled(false);
                    } else {
                        SingleServerSettingsPanel.this.checkAskPassword.setEnabled(true);
                        SingleServerSettingsPanel.this.checkAskAdminPassword.setEnabled(true);
                    }
                }
            });
            this.checkPasv = new JCheckBox(Utils._("Use passive mode to fetch faxes"));
            this.actTestConnection = new ExcDialogAbstractAction(Utils._("Test connection")){

                protected void actualActionPerformed(ActionEvent actionEvent) {
                    OptionsWin optionsWin = (OptionsWin)SwingUtilities.getWindowAncestor(SingleServerSettingsPanel.this);
                    if (!SingleServerSettingsPanel.this.validateSettings(optionsWin)) {
                        return;
                    }
                    ServerOptions serverOptions = new ServerOptions(Utils.getFaxOptions());
                    SingleServerSettingsPanel.this.saveSettings(serverOptions);
                    new TestConnectionWorker(optionsWin, serverOptions).startWork();
                }
            };
            this.hostLbl = Utils.addWithLabel(this.panelServer, (Component)this.textHost, Utils._("Host name:"), "1, 2, 5, 2, f, c");
            this.portLbl = Utils.addWithLabel(this.panelServer, (Component)this.textPort, Utils._("Port:"), "7, 2, f, c");
            this.usernameLbl = Utils.addWithLabel(this.panelServer, (Component)this.textUser, Utils._("Username:"), "1, 5, 5, 5, f, c");
            this.panelServer.add((Component)this.checkAskUsername, "6,5,7,5,f,c");
            Utils.addWithLabel(this.panelServer, (Component)this.textPassword, Utils._("Password:"), "1, 8, 5, 8, f, c");
            this.panelServer.add((Component)this.checkAskPassword, "6, 8, 7, 8, f, c");
            Utils.addWithLabel(this.panelServer, (Component)this.textAdminPassword, Utils._("Admin Password:"), "1, 11, 5, 11, f, c");
            this.panelServer.add((Component)this.checkAskAdminPassword, "6, 11, 7, 11, f, c");
            this.panelServer.add((Component)this.checkPasv, "1, 14, 7, 14");
            this.panelServer.add((Component)new JButton(this.actTestConnection), "1,17,7,17,f,f");
        }
        return this.panelServer;
    }

    private JPanel getPanelServerRetrieval() {
        if (this.panelServerRetrieval == null) {
            double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0}, new double[14]};
            dArrayArray[1][13] = -1.0;
            for (int i = 0; i < 13; ++i) {
                dArrayArray[1][i] = i % 3 == 0 ? 5.0 : -2.0;
            }
            this.panelServerRetrieval = new JPanel(new TableLayout(dArrayArray), false);
            this.panelServerRetrieval.setBorder(BorderFactory.createTitledBorder(Utils._("General settings:")));
            this.spinOffset = SpinnerDateOffsetEditor.createJSpinner();
            this.checkUseDisconnected = new JCheckBox("<html>" + Utils._("Create new session for every action") + "</html>");
            this.checkUseDisconnected.setToolTipText(Utils._("Connect to the server and log in for every action (e.g. view a fax, update tables, ...) and disconnect afterwards. This impairs performance but might work around some bugs."));
            Vector<Charset> vector = new Vector<Charset>(Charset.availableCharsets().values());
            Collections.sort(vector);
            this.comboCharset = new JComboBox<Charset>(vector);
            this.comboTZone = new JComboBox<FaxTimezone>(FaxTimezone.values());
            Utils.addWithLabel(this.panelServerRetrieval, (Component)this.spinOffset, Utils._("Date/Time offset:"), "1,2,1,2,f,c");
            this.spinOffset.setToolTipText(Utils._("Offset to be added to dates received from the HylaFAX server before displaying them."));
            this.panelServerRetrieval.add((Component)this.checkUseDisconnected, "1,5");
            Utils.addWithLabel(this.panelServerRetrieval, (Component)this.comboCharset, Utils._("Character set:"), "1,8,1,8,f,c");
            Utils.addWithLabel(this.panelServerRetrieval, (Component)this.comboTZone, Utils._("Time zone:"), "1,11,f,c");
        }
        return this.panelServerRetrieval;
    }

    void checkEnable() {
        boolean bl = this.checkUseArchive.isSelected();
        this.ftfArchiveLocation.setEnabled(bl);
        this.archiveLabel.setEnabled(bl);
    }

    private JPanel getPanelPersistence() {
        if (this.panelPersistence == null) {
            double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0}, {5.0, -2.0, -2.0, 5.0, -2.0, 5.0}};
            this.panelPersistence = new JPanel(new TableLayout(dArrayArray), false);
            this.panelPersistence.setBorder(BorderFactory.createTitledBorder(Utils._("Read/unread state + comment")));
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AvailablePersistenceMethod availablePersistenceMethod = (AvailablePersistenceMethod)SingleServerSettingsPanel.this.comboPersistenceMethods.getSelectedItem();
                    if ("combo".equals(actionEvent.getActionCommand())) {
                        String string;
                        boolean bl = availablePersistenceMethod != null && availablePersistenceMethod.canConfigure();
                        SingleServerSettingsPanel.this.buttonConfigPersistence.setEnabled(bl);
                        if (bl && (string = SingleServerSettingsPanel.this.persistenceConfigs.get(availablePersistenceMethod.getKey())) == null) {
                            this.doConfigure(availablePersistenceMethod);
                        }
                    } else if ("config".equals(actionEvent.getActionCommand())) {
                        if (availablePersistenceMethod != null) {
                            this.doConfigure(availablePersistenceMethod);
                        }
                    } else assert (false);
                }

                private void doConfigure(AvailablePersistenceMethod availablePersistenceMethod) {
                    String string = availablePersistenceMethod.showConfigDialog(SwingUtilities.getWindowAncestor(SingleServerSettingsPanel.this), SingleServerSettingsPanel.this.persistenceConfigs.get(availablePersistenceMethod.getKey()));
                    if (string != null) {
                        SingleServerSettingsPanel.this.persistenceConfigs.put(availablePersistenceMethod.getKey(), string);
                    }
                }
            };
            this.comboPersistenceMethods = new JComboBox<Object>(VirtColPersister.persistenceMethods.toArray());
            this.comboPersistenceMethods.addActionListener(actionListener);
            this.comboPersistenceMethods.setActionCommand("combo");
            this.buttonConfigPersistence = new JButton(Utils._("Configure..."));
            this.buttonConfigPersistence.addActionListener(actionListener);
            this.buttonConfigPersistence.setActionCommand("config");
            Utils.addWithLabel(this.panelPersistence, (Component)this.comboPersistenceMethods, Utils._("Save location:"), "1,2");
            this.panelPersistence.add((Component)this.buttonConfigPersistence, "1,4");
        }
        return this.panelPersistence;
    }

    private JPanel getPanelSRFax() {
        if (this.panelSRFax == null) {
            double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0}, {5.0, -2.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0}};
            this.panelSRFax = new JPanel(new TableLayout(dArrayArray), false);
            this.panelSRFax.setBorder(BorderFactory.createTitledBorder(Utils._("SRFax Options")));
            this.textDayRange = new JTextField();
            this.textDayRange.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
            Utils.addWithLabel(this.panelSRFax, (Component)this.textDayRange, Utils._("Show faxes from last __ days (0 for ALL)"), "1,2");
            this.checkShowRead = new JCheckBox(Utils._("Show read faxes"), true);
            this.checkShowUnread = new JCheckBox(Utils._("Show unread faxes"), true);
            this.checkIncludeSubUsers = new JCheckBox(Utils._("Include faxes received by a sub user"), true);
            this.panelSRFax.add((Component)this.checkShowRead, "1,4");
            this.panelSRFax.add((Component)this.checkShowUnread, "1,6");
            this.panelSRFax.add((Component)this.checkIncludeSubUsers, "1,8");
        }
        return this.panelSRFax;
    }

    protected static final class TestConnectionWorker
    extends ProgressWorker
    implements ActionListener {
        private final Dialog ow;
        private final ServerOptions tempFO;
        private HylaClientManager tempHCM;
        private volatile boolean cancelled = false;

        protected TestConnectionWorker(Dialog dialog, ServerOptions serverOptions) {
            this.ow = dialog;
            this.tempFO = serverOptions;
            this.setProgressMonitor(new ProgressDialog((Dialog)dialog, (String)Utils._((String)"Test connection"), (ActionListener)this).progressPanel);
        }

        public void startWork() {
            this.startWork(this.ow, MessageFormat.format(Utils._("Testing connection to {0}"), this.tempFO.host));
        }

        public void doWork() {
            block8: {
                this.updateNote(Utils._("Logging in..."));
                if (this.tempFO.faxListConnectionType == FaxListConnectionType.SRFAX) {
                    try {
                        JsonObject jsonObject = SRFaxAPI.sendPost("Get_Fax_Usage", this.tempFO.user, this.tempFO.pass.getPassword());
                        if (jsonObject.get("Status").getAsString().compareTo("Success") == 0) {
                            this.showMessageDialog(Utils._("Connection to the SRFax server successful."), Utils._("Test connection"), 1);
                            break block8;
                        }
                        this.showMessageDialog(jsonObject.get("Result").getAsString(), Utils._("Test connection"), 1);
                    }
                    catch (Exception exception) {
                        this.showMessageDialog(Utils._("Connection to the SRFax server failed."), Utils._("Test connection"), 1);
                        exception.printStackTrace();
                    }
                } else {
                    this.tempHCM = new HylaClientManager(this.tempFO);
                    if (!this.cancelled && this.tempHCM.forceLogin(new SwingYajOptionPane(this.ow)) != null) {
                        if (!this.cancelled) {
                            this.updateNote(Utils._("Login successful, logging out."));
                        }
                        this.tempHCM.forceLogout();
                        if (!this.cancelled) {
                            this.progressMonitor.close();
                            this.showMessageDialog(Utils._("Connection to the HylaFAX server successful."), Utils._("Test connection"), 1);
                        }
                    }
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.cancelled = true;
            if (this.tempHCM != null) {
                this.tempHCM.setShowErrorsUsingGUI(false);
            }
            this.interrupt();
            this.getProgressMonitor().close();
        }
    }
}

