/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.options;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import yajhfc.FaxOptions;
import yajhfc.FileTextField;
import yajhfc.TextViewPanel;
import yajhfc.Utils;
import yajhfc.file.FileConverters;
import yajhfc.file.FormattedFile;
import yajhfc.file.textextract.HylaToTextConverter;
import yajhfc.file.textextract.PDFToTextConverter;
import yajhfc.file.textextract.PSToTextConverter;
import yajhfc.file.textextract.RecipientExtractionMode;
import yajhfc.options.AbstractOptionsPanel;
import yajhfc.options.OptionsWin;
import yajhfc.options.PathAndViewPanel;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.JTableTABAction;
import yajhfc.util.ProgressDialog;
import yajhfc.util.ProgressWorker;
import yajhfc.util.SafeJFileChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextExtractorPanel
extends AbstractOptionsPanel<FaxOptions> {
    JComboBox comboExtractRecipients;
    JComboBox comboExtractionMethod;
    JLabel labelPath;
    FileTextField ftfPath;
    Action actView;
    Action actRemoveRow;
    Action actUseDefault;
    TagNameTableModel tagTableModel;
    JTable tagTable;
    JCheckBox checkMandatoryColon;
    JLabel labelTagNameWarning;
    Map<String, String> pathMap = new HashMap<String, String>();
    private HylaToTextConverter lastSelection = null;
    PathAndViewPanel pathAndViewPanel;

    public TextExtractorPanel(PathAndViewPanel pathAndViewPanel) {
        super(true);
        this.pathAndViewPanel = pathAndViewPanel;
    }

    @Override
    public void loadSettings(FaxOptions faxOptions) {
        this.pathMap.clear();
        this.pathMap.put(PDFToTextConverter.class.getName(), faxOptions.pdftotextPath);
        this.pathMap.put(PSToTextConverter.class.getName(), faxOptions.pstotextPath);
        this.comboExtractRecipients.setSelectedItem((Object)faxOptions.extractRecipients);
        this.lastSelection = null;
        this.comboExtractionMethod.setSelectedItem(HylaToTextConverter.findByString(faxOptions.hylaToTextConverter));
        if (this.comboExtractionMethod.getSelectedIndex() < 0) {
            this.comboExtractionMethod.setSelectedIndex(0);
        }
        this.lastSelection = null;
        this.selectNewPath((HylaToTextConverter)this.comboExtractionMethod.getSelectedItem());
        this.checkMandatoryColon.setSelected(faxOptions.recipientExtractionTagMandatoryColon);
        this.tagTableModel.setListContents(faxOptions.recipientExtractionTags);
    }

    @Override
    public void saveSettings(FaxOptions faxOptions) {
        this.savePath();
        faxOptions.extractRecipients = (RecipientExtractionMode)((Object)this.comboExtractRecipients.getSelectedItem());
        faxOptions.hylaToTextConverter = ((HylaToTextConverter)this.comboExtractionMethod.getSelectedItem()).name();
        faxOptions.pdftotextPath = this.pathMap.get(PDFToTextConverter.class.getName());
        faxOptions.pstotextPath = this.pathMap.get(PSToTextConverter.class.getName());
        faxOptions.recipientExtractionTagMandatoryColon = this.checkMandatoryColon.isSelected();
        faxOptions.recipientExtractionTags.clear();
        faxOptions.recipientExtractionTags.addAll(this.tagTableModel.getTags());
    }

    @Override
    public boolean validateSettings(OptionsWin optionsWin) {
        this.savePath();
        if (this.tagTable.isEditing()) {
            this.tagTable.getCellEditor().stopCellEditing();
        }
        int n = 0;
        int n2 = 0;
        for (String string : this.tagTableModel.getTags()) {
            if (string.length() <= 1) {
                JOptionPane.showMessageDialog(optionsWin, Utils._("Empty tag names are not allowed."));
                return false;
            }
            switch (string.charAt(0)) {
                case 'F': {
                    ++n;
                    break;
                }
                case 'M': {
                    ++n2;
                }
            }
        }
        if (n == 0) {
            JOptionPane.showMessageDialog(optionsWin, Utils._("You have to define at least one tag name for fax numbers."));
            return false;
        }
        if (n2 == 0) {
            JOptionPane.showMessageDialog(optionsWin, Utils._("You have to define at least one tag name for email addresses."));
            return false;
        }
        return true;
    }

    void savePath() {
        String string;
        if (this.lastSelection != null && this.pathMap.containsKey(string = this.lastSelection.getClass().getName())) {
            this.pathMap.put(string, this.ftfPath.getText());
        }
    }

    void selectNewPath(HylaToTextConverter hylaToTextConverter) {
        this.savePath();
        String string = hylaToTextConverter.getClass().getName();
        if (this.pathMap.containsKey(string)) {
            this.ftfPath.setEnabled(true);
            this.labelPath.setEnabled(true);
            this.labelPath.setText(MessageFormat.format(Utils._("Path to {0}:"), hylaToTextConverter.getDescription()));
            this.ftfPath.setText(this.pathMap.get(string));
        } else {
            this.ftfPath.setEnabled(false);
            this.labelPath.setEnabled(false);
            this.labelPath.setText(Utils._("No path settings necessary"));
            this.ftfPath.setText("");
        }
        this.lastSelection = hylaToTextConverter;
    }

    @Override
    protected void createOptionsUI() {
        JLabel jLabel = new JLabel("<html>" + Utils._("By activating this option YajHFC will try to extract the recipients from documents given on the command line or fax printer.") + "<br>" + Utils._("To find recipients it searches for <tt>@@recipient:<i>faxnumber</i>@@</tt> tags in the files.") + "<br>" + Utils._("This behaviour can be overridden by the <tt>--extract-recipients</tt> command line option.") + "<br><br>" + Utils._("If you want to use this feature a PDF/PostScript to text conversion method must be selected below.") + "</html>");
        this.comboExtractionMethod = new JComboBox<HylaToTextConverter>(new Vector<HylaToTextConverter>(HylaToTextConverter.availableConverters));
        this.comboExtractionMethod.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HylaToTextConverter hylaToTextConverter = (HylaToTextConverter)TextExtractorPanel.this.comboExtractionMethod.getSelectedItem();
                if (hylaToTextConverter == null) {
                    return;
                }
                TextExtractorPanel.this.selectNewPath(hylaToTextConverter);
            }
        });
        this.comboExtractRecipients = new JComboBox<RecipientExtractionMode>(RecipientExtractionMode.values());
        this.ftfPath = new FileTextField();
        ClipboardPopup.DEFAULT_POPUP.addToComponent(this.ftfPath.getJTextField());
        this.actView = new ExcDialogAbstractAction(Utils._("Test...")){
            private JFileChooser chooser;

            protected void actualActionPerformed(ActionEvent actionEvent) {
                Object object;
                OptionsWin optionsWin = (OptionsWin)SwingUtilities.getWindowAncestor(TextExtractorPanel.this);
                if (!TextExtractorPanel.this.validateSettings(optionsWin) || TextExtractorPanel.this.pathAndViewPanel.isUICreated() && !TextExtractorPanel.this.pathAndViewPanel.validateSettings(optionsWin)) {
                    return;
                }
                FaxOptions faxOptions = Utils.getFaxOptions().clone();
                if (TextExtractorPanel.this.pathAndViewPanel.isUICreated()) {
                    TextExtractorPanel.this.pathAndViewPanel.saveSettings(faxOptions);
                }
                TextExtractorPanel.this.saveSettings(faxOptions);
                if (this.chooser == null) {
                    this.chooser = new SafeJFileChooser();
                    for (FileFilter fileFilter : object = FileConverters.getConvertableFileFilters()) {
                        this.chooser.addChoosableFileFilter(fileFilter);
                    }
                    FileFilter fileFilter = this.chooser.getAcceptAllFileFilter();
                    this.chooser.removeChoosableFileFilter(fileFilter);
                    this.chooser.addChoosableFileFilter(fileFilter);
                    this.chooser.setFileFilter(object[0]);
                    this.chooser.setDialogTitle(Utils._("Select a file to view as text"));
                }
                if (this.chooser.showOpenDialog(TextExtractorPanel.this) == 0) {
                    object = ((HylaToTextConverter)TextExtractorPanel.this.comboExtractionMethod.getSelectedItem()).getInstanceForOptions(faxOptions);
                    new ViewAsTextWorker(optionsWin, (HylaToTextConverter)object, this.chooser.getSelectedFile()).startWork();
                }
            }
        };
        double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0}, {5.0, -2.0, -2.0, 5.0}};
        JPanel jPanel = new JPanel(new TableLayout(dArrayArray));
        jPanel.setBorder(BorderFactory.createTitledBorder(Utils._("Settings for the selected conversion method")));
        this.labelPath = Utils.addWithLabel(jPanel, (Component)this.ftfPath, "path", "1,2");
        double[][] dArrayArray2 = new double[][]{{5.0, -1.0, 5.0, 0.4, 5.0}, {5.0, -2.0, 5.0, -2.0, 5.0, -2.0, -1.0, -2.0, 5.0}};
        JPanel jPanel2 = new JPanel(new TableLayout(dArrayArray2));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Utils._("Recognized tag names")));
        this.actRemoveRow = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                int n = TextExtractorPanel.this.tagTable.getSelectedRow();
                if (n >= 0 && TextExtractorPanel.this.tagTableModel.rowIsRemovable(n)) {
                    if (TextExtractorPanel.this.tagTable.isEditing()) {
                        TextExtractorPanel.this.tagTable.getCellEditor().cancelCellEditing();
                    }
                    TextExtractorPanel.this.tagTableModel.removeRow(n);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        };
        this.actRemoveRow.putValue("Name", Utils._("Remove row"));
        this.actUseDefault = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                TextExtractorPanel.this.tagTableModel.setListContents(FaxOptions.DEFAULT_RECIPIENT_EXTRACTION_TAGS);
            }
        };
        this.actUseDefault.putValue("Name", Utils._("Reset"));
        this.tagTableModel = new TagNameTableModel();
        this.tagTable = new JTable(this.tagTableModel);
        this.tagTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TextExtractorPanel.this.actRemoveRow.setEnabled(listSelectionEvent.getFirstIndex() >= 0 && TextExtractorPanel.this.tagTableModel.rowIsRemovable(listSelectionEvent.getFirstIndex()));
            }
        });
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.actRemoveRow);
        this.tagTable.setComponentPopupMenu(jPopupMenu);
        JComboBox<String> jComboBox = new JComboBox<String>(TagNameTableModel.getAvailableTagTypes());
        this.tagTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jComboBox));
        this.tagTable.getActionMap().put(this.actRemoveRow.getClass().getName(), this.actRemoveRow);
        this.tagTable.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.actRemoveRow.getClass().getName());
        JTableTABAction.wrapDefTabAction(this.tagTable);
        this.checkMandatoryColon = new JCheckBox(Utils._("Colon (:) after name is mandatory"));
        this.labelTagNameWarning = new JLabel("<html>" + Utils._("Some tag names contain characters other than A-Z or 0-9. This is not recommended.") + "</html>");
        this.labelTagNameWarning.setForeground(Color.RED);
        this.labelTagNameWarning.setVisible(false);
        this.tagTableModel.addTableModelListener(new TableModelListener(){
            private Pattern validatePattern = Pattern.compile(".[a-zA-Z0-9]*");

            public void tableChanged(TableModelEvent tableModelEvent) {
                boolean bl = false;
                for (String string : TextExtractorPanel.this.tagTableModel.getTags()) {
                    bl = bl || !this.validatePattern.matcher(string).matches();
                }
                TextExtractorPanel.this.labelTagNameWarning.setVisible(bl);
            }
        });
        jPanel2.add((Component)new JScrollPane(this.tagTable), "1,1,1,7,f,f");
        jPanel2.add((Component)this.checkMandatoryColon, "3,1,f,c");
        jPanel2.add((Component)new JButton(this.actRemoveRow), "3,3,f,c");
        jPanel2.add((Component)new JButton(this.actUseDefault), "3,5,f,c");
        jPanel2.add((Component)this.labelTagNameWarning, "3,7,f,b");
        double[][] dArrayArray3 = new double[][]{{5.0, -2.0, 5.0, -2.0, 5.0, -1.0, 5.0}, {5.0, -2.0, 10.0, -2.0, 10.0, -2.0, -2.0, 5.0, -2.0, -2.0, 5.0, -2.0, 5.0, -1.0, 5.0}};
        this.setLayout(new TableLayout(dArrayArray3));
        this.add((Component)jLabel, "1,1,5,1,f,t");
        this.add((Component)new JSeparator(), "0,3,6,3,f,c");
        Utils.addWithLabel((JPanel)this, (Component)this.comboExtractRecipients, Utils._("Extract recipients from documents:"), "1,6");
        Utils.addWithLabel((JPanel)this, (Component)this.comboExtractionMethod, Utils._("PS/PDF to text conversion method:"), "1,9");
        this.add((Component)new JButton(this.actView), "3,9");
        this.add((Component)jPanel, "1,11,5,11,f,f");
        this.add((Component)jPanel2, "1,13,5,13,f,f");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TagNameTableModel
    extends AbstractTableModel {
        private final List<String> tags = new ArrayList<String>();
        protected static final String TAG_TYPE_MAIL = Utils._("e-mail address");
        protected static final String TAG_TYPE_FAX = Utils._("Fax number");
        protected static final String TAG_TYPE_SUBJECT = Utils._("Subject");

        public static String[] getAvailableTagTypes() {
            return new String[]{TAG_TYPE_FAX, TAG_TYPE_MAIL, TAG_TYPE_SUBJECT};
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return Utils._("Tag name");
                }
                case 1: {
                    return Utils._("Type");
                }
            }
            return "X";
        }

        @Override
        public int getRowCount() {
            return this.tags.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n >= this.tags.size()) {
                return "";
            }
            String string = this.tags.get(n);
            if (string.length() < 1) {
                return "";
            }
            switch (n2) {
                case 0: {
                    return string.substring(1);
                }
                case 1: {
                    switch (string.charAt(0)) {
                        default: {
                            return TAG_TYPE_FAX;
                        }
                        case 'M': {
                            return TAG_TYPE_MAIL;
                        }
                        case 'S': 
                    }
                    return TAG_TYPE_SUBJECT;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string;
            if (object.equals(this.getValueAt(n, n2))) {
                return;
            }
            String string2 = n >= this.tags.size() ? " " : this.tags.get(n);
            switch (n2) {
                case 0: {
                    if ("".equals(object) && this.rowIsRemovable(n)) {
                        this.removeRow(n);
                        return;
                    }
                    string = string2.charAt(0) + (String)object;
                    break;
                }
                case 1: {
                    int n3 = TAG_TYPE_FAX.equals(object) ? 70 : (TAG_TYPE_MAIL.equals(object) ? 77 : (TAG_TYPE_SUBJECT.equals(object) ? 83 : 70));
                    char[] cArray = string2.toCharArray();
                    cArray[0] = n3;
                    string = new String(cArray);
                    break;
                }
                default: {
                    return;
                }
            }
            if (n >= this.tags.size()) {
                this.tags.add(string);
                this.fireTableRowsInserted(n + 1, n + 1);
            } else {
                this.tags.set(n, string);
            }
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public void setListContents(String[] stringArray) {
            this.tags.clear();
            Collections.addAll(this.tags, stringArray);
            Collections.sort(this.tags);
            this.fireTableDataChanged();
        }

        public void setListContents(Collection<String> collection) {
            this.tags.clear();
            this.tags.addAll(collection);
            Collections.sort(this.tags);
            this.fireTableDataChanged();
        }

        public void removeRow(int n) {
            this.tags.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public boolean rowIsRemovable(int n) {
            return n < this.tags.size();
        }

        public List<String> getTags() {
            return this.tags;
        }
    }

    protected static final class ViewAsTextWorker
    extends ProgressWorker
    implements ActionListener {
        private final Dialog ow;
        private final HylaToTextConverter extractor;
        private final File file;
        private String title;
        private String result = null;

        protected ViewAsTextWorker(Dialog dialog, HylaToTextConverter hylaToTextConverter, File file) {
            this.ow = dialog;
            this.extractor = hylaToTextConverter;
            this.file = file;
            this.title = MessageFormat.format(Utils._("View as text using {0}"), hylaToTextConverter);
            this.setProgressMonitor(new ProgressDialog((Dialog)dialog, (String)this.title, (ActionListener)this).progressPanel);
        }

        public void startWork() {
            this.startWork(this.ow, Utils._("Converting file to text..."));
        }

        public void doWork() {
            this.updateNote(Utils._("Running converter..."));
            try {
                CharSequence[] charSequenceArray = this.extractor.convertFilesToText(Collections.singletonList(new FormattedFile(this.file)));
                StringBuilder stringBuilder = new StringBuilder();
                for (CharSequence charSequence : charSequenceArray) {
                    stringBuilder.append(charSequence).append('\n');
                }
                this.result = stringBuilder.toString();
            }
            catch (Exception exception) {
                this.showExceptionDialog(Utils._("Error converting file to text"), exception);
            }
        }

        protected void done() {
            if (this.result != null) {
                TextViewPanel.displayDialog(this.ow, this.title, Collections.singletonList(new TextViewPanel.Text(this.file.toString(), this.result)), true);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.interrupt();
            this.getProgressMonitor().close();
        }
    }
}

