/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Password;
import yajhfc.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectionSettings {
    static final Logger log = Logger.getLogger(AbstractConnectionSettings.class.getName());
    private static final String separator = ";";
    private static final char escapeChar = '~';
    public static final String noField = "<none>";
    public static final String noField_translated = Utils._("<none>");
    protected static final Map<Class<? extends AbstractConnectionSettings>, Map<String, SettingField>> availableFieldMaps = new HashMap<Class<? extends AbstractConnectionSettings>, Map<String, SettingField>>();

    public static boolean isNoField(String string) {
        return string == null || string.length() == 0 || string.equals(noField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, SettingField> getAvailableFieldsMap() {
        Map<Class<? extends AbstractConnectionSettings>, Map<String, SettingField>> map = availableFieldMaps;
        synchronized (map) {
            Map<String, SettingField> map2 = availableFieldMaps.get(this.getClass());
            if (map2 == null) {
                map2 = new TreeMap<String, SettingField>();
                availableFieldMaps.put(this.getClass(), map2);
                this.readAvailableFields(map2);
            }
            return map2;
        }
    }

    protected void readAvailableFields(Map<String, SettingField> map) {
        map.clear();
        for (Field field : this.getClass().getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (Password.class.isAssignableFrom(field.getType())) {
                PasswordField passwordField = new PasswordField(field, true);
                PasswordField passwordField2 = new PasswordField(field, false);
                map.put(passwordField.getName(), passwordField);
                map.put(passwordField2.getName(), passwordField2);
                continue;
            }
            if (Modifier.isFinal(field.getModifiers())) continue;
            map.put(field.getName(), new ReflectionField(field));
        }
    }

    public Set<String> getAvailableFields() {
        return this.getAvailableFieldsMap().keySet();
    }

    public void setField(String string, Object object) throws IllegalArgumentException, IllegalAccessException {
        SettingField settingField = this.getAvailableFieldsMap().get(string);
        if (settingField == null) {
            throw new IllegalArgumentException("Field " + string + " not found.");
        }
        settingField.set(this, object);
    }

    public Object getField(String string) throws IllegalArgumentException, IllegalAccessException {
        SettingField settingField = this.getAvailableFieldsMap().get(string);
        if (settingField == null) {
            throw new IllegalArgumentException("Field " + string + " not found.");
        }
        return settingField.get(this);
    }

    public void copyFrom(AbstractConnectionSettings abstractConnectionSettings) {
        if (abstractConnectionSettings == null) {
            return;
        }
        for (SettingField settingField : this.getAvailableFieldsMap().values()) {
            if (!settingField.isFieldSaved()) continue;
            try {
                settingField.set(this, settingField.get(abstractConnectionSettings));
            }
            catch (Exception exception) {}
        }
    }

    public String saveToString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (SettingField settingField : this.getAvailableFieldsMap().values()) {
            if (!settingField.isFieldSaved()) continue;
            try {
                String string = settingField.get(this).toString();
                string = Utils.escapeChars(string, separator, '~');
                stringBuilder.append(settingField.getName());
                stringBuilder.append('=');
                stringBuilder.append(string);
                stringBuilder.append(separator);
            }
            catch (Exception exception) {}
        }
        return stringBuilder.toString();
    }

    public void loadFromString(String string) {
        String[] stringArray;
        if (string == null) {
            return;
        }
        for (String string2 : stringArray = Utils.fastSplit(string, separator.charAt(0))) {
            int n = string2.indexOf(61);
            if (n < 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = Utils.unEscapeChars(string2.substring(n + 1), separator, '~');
            try {
                SettingField settingField = this.getAvailableFieldsMap().get(string3);
                if (settingField == null) {
                    log.warning("Field not found: " + string3);
                    continue;
                }
                Class<?> clazz = settingField.getType();
                if (clazz == String.class || clazz == Password.class) {
                    settingField.set(this, string4);
                    continue;
                }
                if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                    settingField.set(this, Boolean.valueOf(string4));
                    continue;
                }
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    settingField.set(this, Integer.valueOf(string4));
                    continue;
                }
                log.log(Level.WARNING, "Unsupported field type " + clazz.getName() + " of field " + string3);
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Exception loading fields:", exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PasswordField
    implements SettingField {
        protected final Field field;
        protected final boolean save;
        protected final String name;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        private Password getPassword(AbstractConnectionSettings abstractConnectionSettings) throws IllegalArgumentException, IllegalAccessException {
            return (Password)this.field.get(abstractConnectionSettings);
        }

        @Override
        public Object get(AbstractConnectionSettings abstractConnectionSettings) {
            try {
                if (this.save) {
                    return this.getPassword(abstractConnectionSettings).getObfuscatedPassword();
                }
                return this.getPassword(abstractConnectionSettings).getPassword();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.log(Level.WARNING, "Could not read value:", illegalArgumentException);
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                log.log(Level.WARNING, "Could not read value:", illegalAccessException);
                return null;
            }
        }

        @Override
        public void set(AbstractConnectionSettings abstractConnectionSettings, Object object) {
            try {
                if (this.save) {
                    this.getPassword(abstractConnectionSettings).setObfuscatedPassword((String)object);
                } else {
                    this.getPassword(abstractConnectionSettings).setPassword((String)object);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.log(Level.WARNING, "Could not write value:", illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.log(Level.WARNING, "Could not write value:", illegalAccessException);
            }
        }

        @Override
        public boolean isFieldSaved() {
            return this.save;
        }

        public PasswordField(Field field, boolean bl) {
            this.field = field;
            this.save = bl;
            this.name = bl ? field.getName() + "-obfuscated" : field.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ReflectionField
    implements SettingField {
        protected final Field field;

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        @Override
        public Object get(AbstractConnectionSettings abstractConnectionSettings) {
            try {
                return this.field.get(abstractConnectionSettings);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.log(Level.WARNING, "Could not read value:", illegalArgumentException);
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                log.log(Level.WARNING, "Could not read value:", illegalAccessException);
                return null;
            }
        }

        @Override
        public void set(AbstractConnectionSettings abstractConnectionSettings, Object object) {
            try {
                this.field.set(abstractConnectionSettings, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.log(Level.WARNING, "Could not write value:", illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.log(Level.WARNING, "Could not write value:", illegalAccessException);
            }
        }

        @Override
        public boolean isFieldSaved() {
            return true;
        }

        public ReflectionField(Field field) {
            this.field = field;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SettingField {
        public String getName();

        public Object get(AbstractConnectionSettings var1);

        public void set(AbstractConnectionSettings var1, Object var2);

        public Class<?> getType();

        public boolean isFieldSaved();
    }
}

