/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook;

import java.awt.Dialog;
import java.io.File;
import java.util.ArrayList;
import yajhfc.Utils;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookType;
import yajhfc.phonebook.csv.CSVPhoneBook;
import yajhfc.phonebook.jdbc.JDBCPhoneBook;
import yajhfc.phonebook.ldap.LDAPPhoneBook;
import yajhfc.phonebook.srfax.SRFaxPhoneBook;
import yajhfc.phonebook.xml.XMLPhoneBook;
import yajhfc.phonebook.xml.XMLSettings;

public class PhoneBookFactory {
    public static final ArrayList<PhoneBookType> PhonebookTypes = new ArrayList();
    public static final String DEFAULT_PHONEBOOK_NAME;

    public static PhoneBook instanceForDescriptor(String string, Dialog dialog) {
        int n = string.indexOf(58);
        if (n <= 0) {
            return new XMLPhoneBook(dialog);
        }
        return PhoneBookFactory.instanceForPrefix(string.substring(0, n), dialog);
    }

    public static PhoneBook instanceForPrefix(String string, Dialog dialog) {
        for (PhoneBookType phoneBookType : PhonebookTypes) {
            if (!string.equals(phoneBookType.getPrefix())) continue;
            return phoneBookType.createInstance(dialog);
        }
        return null;
    }

    public static File getDefaultPhonebook() {
        return new File(Utils.getConfigDir(), "default.phonebook");
    }

    public static String getDefaultPhonebookDescriptor() {
        XMLSettings xMLSettings = new XMLSettings();
        xMLSettings.fileName = PhoneBookFactory.getDefaultPhonebook().getAbsolutePath();
        xMLSettings.caption = DEFAULT_PHONEBOOK_NAME;
        return "XML:" + xMLSettings.saveToString();
    }

    static {
        PhonebookTypes.add(new PhoneBookType(XMLPhoneBook.class));
        PhonebookTypes.add(new PhoneBookType(JDBCPhoneBook.class));
        PhonebookTypes.add(new PhoneBookType(LDAPPhoneBook.class));
        PhonebookTypes.add(new PhoneBookType(CSVPhoneBook.class));
        PhonebookTypes.add(new PhoneBookType(SRFaxPhoneBook.class));
        DEFAULT_PHONEBOOK_NAME = Utils._("Personal phone book");
    }
}

