/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook;

import java.util.Comparator;
import yajhfc.Utils;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBookEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortOrder
implements Comparator<PhoneBookEntry> {
    protected final PBEntryField[] fields;
    protected final boolean[] descending;

    public int getFieldCount() {
        return this.fields.length;
    }

    public PBEntryField getFields(int n) {
        return this.fields[n];
    }

    public boolean getDescending(int n) {
        return this.descending[n];
    }

    @Override
    public int compare(PhoneBookEntry phoneBookEntry, PhoneBookEntry phoneBookEntry2) {
        for (int i = 0; i < this.fields.length; ++i) {
            String string = phoneBookEntry.getField(this.fields[i]);
            String string2 = phoneBookEntry2.getField(this.fields[i]);
            if (string == null) {
                if (string2 == null) continue;
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            int n = string.compareToIgnoreCase(string2);
            if (n == 0) continue;
            return this.descending[i] ? -n : n;
        }
        return 0;
    }

    public String serialize() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.fields.length; ++i) {
            stringBuilder.append(this.descending[i] ? (char)'-' : '+').append(this.fields[i].name()).append(',');
        }
        return stringBuilder.toString();
    }

    public static SortOrder deserialize(String string) {
        String[] stringArray = Utils.fastSplit(string, ',');
        PBEntryField[] pBEntryFieldArray = new PBEntryField[stringArray.length];
        boolean[] blArray = new boolean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            blArray[i] = stringArray[i].charAt(0) == '-';
            pBEntryFieldArray[i] = Enum.valueOf(PBEntryField.class, stringArray[i].substring(1));
        }
        return new SortOrder(pBEntryFieldArray, blArray);
    }

    public SortOrder(PBEntryField[] pBEntryFieldArray, boolean[] blArray) {
        this.fields = pBEntryFieldArray;
        this.descending = blArray;
    }
}

