/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import yajhfc.Utils;
import yajhfc.phonebook.DefaultPhoneBookEntry;
import yajhfc.phonebook.DistributionList;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.PhonebookEventListener;
import yajhfc.phonebook.convrules.PBEntryFieldContainer;
import yajhfc.phonebook.xml.XMLPhoneBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperDistributionList
extends DefaultPhoneBookEntry
implements DistributionList {
    private static final Logger log = Logger.getLogger(WrapperDistributionList.class.getName());
    protected PhoneBookEntry wrapped;
    protected XMLPhoneBook itemsList;
    public static final PBEntryField SIGNATURE_FIELD = PBEntryField.Company;
    public static final String SIGNATURE = "@!$DistributionList$!@";
    public static final int MIN_COMMENT_LEN = 5000;

    public WrapperDistributionList(PhoneBookEntry phoneBookEntry) {
        this.wrapped = phoneBookEntry;
    }

    protected XMLPhoneBook getItemsList() {
        if (this.itemsList == null) {
            this.itemsList = new XMLPhoneBook(this.getParent().parentDialog);
            String string = this.wrapped.getField(PBEntryField.Comment);
            if (string != null && string.length() > 0) {
                try {
                    this.itemsList.loadFromInputSource(new InputSource(new StringReader(string)));
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, "Invalid distribution list:", exception);
                }
            }
        }
        return this.itemsList;
    }

    @Override
    public void commit() {
        if (this.itemsList != null && this.itemsList.wasChanged()) {
            try {
                StringWriter stringWriter = new StringWriter();
                this.itemsList.saveToResult(new StreamResult(stringWriter));
                this.wrapped.setField(PBEntryField.Comment, stringWriter.toString());
                this.wrapped.setField(SIGNATURE_FIELD, SIGNATURE);
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Error saving distribution list:", exception);
            }
        }
        this.wrapped.commit();
    }

    @Override
    public void delete() {
        this.wrapped.delete();
    }

    @Override
    public String getField(PBEntryField pBEntryField) {
        if (pBEntryField == PBEntryField.Name) {
            return this.wrapped.getField(pBEntryField);
        }
        return "";
    }

    @Override
    public PhoneBook getParent() {
        return this.wrapped.getParent();
    }

    @Override
    public void setField(PBEntryField pBEntryField, String string) {
        if (pBEntryField == PBEntryField.Name) {
            this.wrapped.setField(pBEntryField, string);
        }
    }

    @Override
    public void addEntries(Collection<? extends PBEntryFieldContainer> collection) {
        this.getItemsList().addEntries(collection);
    }

    @Override
    public PhoneBookEntry addNewEntry() {
        return this.getItemsList().addNewEntry();
    }

    @Override
    public PhoneBookEntry addNewEntry(PBEntryFieldContainer pBEntryFieldContainer) {
        return this.getItemsList().addNewEntry(pBEntryFieldContainer);
    }

    @Override
    public void addPhonebookEventListener(PhonebookEventListener phonebookEventListener) {
        this.getItemsList().addPhonebookEventListener(phonebookEventListener);
    }

    @Override
    public List<PhoneBookEntry> getEntries() {
        return this.getItemsList().getEntries();
    }

    @Override
    public boolean isReadOnly() {
        return this.getParent().isReadOnly();
    }

    @Override
    public void removePhonebookEventListener(PhonebookEventListener phonebookEventListener) {
        this.getItemsList().removePhonebookEventListener(phonebookEventListener);
    }

    @Override
    public String toString() {
        String string = this.wrapped.getField(PBEntryField.Name);
        return string == null || string.length() == 0 ? Utils._("<no name>") : string;
    }

    @Override
    public void updateDisplay() {
        this.wrapped.updateDisplay();
    }

    public PhoneBookEntry getWrappedEntry() {
        return this.wrapped;
    }

    public static boolean areDistributionListsSupported(PhoneBook phoneBook) {
        int n = phoneBook.getMaxLength(PBEntryField.Comment);
        int n2 = phoneBook.getMaxLength(SIGNATURE_FIELD);
        return !(!phoneBook.isFieldAvailable(PBEntryField.Name) || !phoneBook.isFieldAvailable(PBEntryField.Comment) || !phoneBook.isFieldAvailable(SIGNATURE_FIELD) || n != 0 && n < 5000 || n2 != 0 && n2 < SIGNATURE.length());
    }

    public static boolean isDistributionList(PhoneBookEntry phoneBookEntry) {
        return SIGNATURE.equals(phoneBookEntry.getField(SIGNATURE_FIELD));
    }
}

