/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.convrules;

import yajhfc.Utils;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.convrules.ConcatRule;
import yajhfc.phonebook.convrules.EntryToStringRule;
import yajhfc.phonebook.convrules.ZIPCodeRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LocationRule {
    LOCATION(new Object[0], new Object[0]),
    STREET_LOCATION(new Object[]{PBEntryField.Street, ", "}, new Object[0]),
    LOCATION_COUNTRY(new Object[0], new Object[]{", ", PBEntryField.Country}),
    STREET_LOCATION_COUNTRY(new Object[]{PBEntryField.Street, ", "}, new Object[]{", ", PBEntryField.Country});

    private final Object[] prefix;
    private final Object[] suffix;
    private final String description;

    public EntryToStringRule generateRule(ZIPCodeRule zIPCodeRule) {
        int n = this.prefix.length;
        int n2 = this.suffix.length;
        Object[] objectArray = new Object[n + n2 + 1];
        if (n > 0) {
            System.arraycopy(this.prefix, 0, objectArray, 0, n);
        }
        objectArray[n] = zIPCodeRule;
        if (n2 > 0) {
            System.arraycopy(this.suffix, 0, objectArray, n + 1, n2);
        }
        return new ConcatRule(objectArray);
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    private LocationRule(Object[] objectArray, Object[] objectArray2) {
        StringBuilder stringBuilder = new StringBuilder();
        ConcatRule.objectArrayToString(stringBuilder, objectArray);
        stringBuilder.append(Utils._("[Location with ZIP code]"));
        ConcatRule.objectArrayToString(stringBuilder, objectArray2);
        this.description = stringBuilder.toString();
        this.prefix = objectArray;
        this.suffix = objectArray2;
    }
}

