/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.ldap;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import yajhfc.Utils;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.ldap.LDAPSettings;
import yajhfc.util.CancelAction;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.IntVerifier;
import yajhfc.util.PasswordDialog;

public final class ConnectionDialog
extends JDialog
implements ActionListener {
    JTextField textServerName;
    JTextField textPort;
    JTextField textBaseDN;
    JTextField textBindDN;
    JTextField textFilter;
    JTextField textDisplayCaption;
    JTextField textCountLimit;
    JCheckBox checkAskForPassword;
    JCheckBox checkDoAuth;
    JCheckBox checkSearchSubtree;
    JCheckBox checkInitiallyShowAll;
    JPasswordField textPassword;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton buttonTest;
    private EnumMap<PBEntryField, JTextField> mappingFields = new EnumMap(PBEntryField.class);
    private static final int border = 10;
    public boolean clickedOK;

    private JTextField addTextField(JPanel jPanel, PBEntryField pBEntryField, TableLayoutConstraints tableLayoutConstraints) {
        JTextField jTextField = new JTextField(20);
        jTextField.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        String string = pBEntryField.getDescription() + ":";
        Utils.addWithLabelHorz(jPanel, (Component)jTextField, string, tableLayoutConstraints);
        this.mappingFields.put(pBEntryField, jTextField);
        return jTextField;
    }

    private void initialize() {
        int n = 29 + (PBEntryField.FIELD_COUNT + 1) / 2 * 2;
        double[][] dArrayArray = new double[][]{{10.0, -2.0, 10.0, 0.5, 10.0, -2.0, 10.0, -1.0, 10.0}, new double[n]};
        double d = 1.0 / (double)(n - 9) * 2.0;
        for (int i = 0; i < n; ++i) {
            dArrayArray[1][i] = (i & 1) == 0 ? 10.0 : d;
        }
        dArrayArray[1][n - 2] = -2.0;
        dArrayArray[1][n - 4] = -2.0;
        dArrayArray[1][21] = -2.0;
        dArrayArray[1][15] = -2.0;
        dArrayArray[1][11] = -2.0;
        dArrayArray[1][1] = -1.0;
        TableLayout tableLayout = new TableLayout(dArrayArray);
        JPanel jPanel = new JPanel(tableLayout);
        this.textServerName = new JTextField(10);
        this.textServerName.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textPort = new JTextField(5);
        this.textPort.setInputVerifier(new IntVerifier());
        this.textPort.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textBaseDN = new JTextField(2);
        this.textBaseDN.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.checkDoAuth = new JCheckBox(Utils._("Use authentication"));
        this.textBindDN = new JTextField(20);
        this.textBindDN.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textPassword = new JPasswordField(2);
        this.textDisplayCaption = new JTextField(16);
        this.textDisplayCaption.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.checkAskForPassword = new JCheckBox(Utils._("Always ask"));
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = ConnectionDialog.this.checkDoAuth.isSelected();
                ConnectionDialog.this.textBindDN.setEnabled(bl);
                ConnectionDialog.this.checkAskForPassword.setEnabled(bl);
                ConnectionDialog.this.textPassword.setEnabled(bl && !ConnectionDialog.this.checkAskForPassword.isSelected());
            }
        };
        this.checkAskForPassword.addChangeListener(changeListener);
        this.checkDoAuth.addChangeListener(changeListener);
        changeListener.stateChanged(null);
        this.textFilter = new JTextField(2);
        this.textFilter.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textFilter.setToolTipText(Utils._("RFC 2254 Filter expression (e.g. \"objectClass=person\") selecting the directory entries to include. Leave blank to include all."));
        this.checkSearchSubtree = new JCheckBox(Utils._("Also search subtrees"));
        this.textCountLimit = new JTextField(5);
        this.textCountLimit.setInputVerifier(new IntVerifier());
        this.textCountLimit.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textCountLimit.setToolTipText(Utils._("The maximum number of items loaded"));
        this.checkInitiallyShowAll = new JCheckBox(Utils._("Load all entries when opened"));
        this.checkInitiallyShowAll.setToolTipText(Utils._("If checked, all entries in the directory are loaded when the phone book is opened. If not, entries are loaded only if a quick search is performed."));
        CancelAction cancelAction = new CancelAction(this);
        this.buttonCancel = cancelAction.createCancelButton();
        this.buttonOK = new JButton(Utils._("OK"));
        this.buttonOK.setActionCommand("ok");
        this.buttonOK.addActionListener(this);
        this.buttonTest = new JButton(Utils._("Test connection"));
        this.buttonTest.setActionCommand("test");
        this.buttonTest.addActionListener(this);
        Utils.addWithLabelHorz(jPanel, (Component)this.textServerName, Utils._("Server name:"), "3, 1, f, c");
        Utils.addWithLabelHorz(jPanel, (Component)this.textPort, Utils._("Port:"), "7, 1, f, c");
        Utils.addWithLabelHorz(jPanel, (Component)this.textBaseDN, Utils._("Root (Base DN):"), "3, 3, 5, 3, f, c");
        jPanel.add((Component)this.buttonTest, "7, 3");
        jPanel.add((Component)this.checkDoAuth, "1, 5, 3, 5, f, c");
        Utils.addWithLabelHorz(jPanel, (Component)this.textBindDN, Utils._("User name (Bind DN):"), "3, 7, 7, 7, f, c");
        Utils.addWithLabelHorz(jPanel, (Component)this.textPassword, Utils._("Password:"), "3, 9, 5, 9, f, c");
        jPanel.add((Component)this.checkAskForPassword, "7, 9, f, c");
        jPanel.add((Component)new JSeparator(0), "0, 11, 8, 11");
        Utils.addWithLabelHorz(jPanel, (Component)this.textDisplayCaption, Utils._("Phone book name to display:"), "3, 13, 7, 13, f, c");
        jPanel.add((Component)new JSeparator(0), "0, 15, 8, 15");
        Utils.addWithLabelHorz(jPanel, (Component)this.textFilter, Utils._("Object filter:"), "3, 17, 5, 17, f, c");
        jPanel.add((Component)this.checkSearchSubtree, "7, 17");
        jPanel.add((Component)this.checkInitiallyShowAll, "1,19,3,19,f,c");
        Utils.addWithLabelHorz(jPanel, (Component)this.textCountLimit, Utils._("Count limit:"), "7,19,f,c");
        jPanel.add((Component)new JSeparator(0), "0, 21, 8, 21");
        jPanel.add((Component)new JLabel("<html>" + Utils._("Please enter which LDAP attributes correspond to the phone book entry fields of YajHFC (default should usually work):") + "</html>"), "1, 23, 7, 23, f, c");
        int n2 = 25;
        int n3 = 3;
        for (PBEntryField pBEntryField : PBEntryField.values()) {
            this.addTextField(jPanel, pBEntryField, new TableLayoutConstraints(n3, n2, n3, n2, 2, 1));
            if (n3 == 3) {
                n3 = 7;
                continue;
            }
            n3 = 3;
            n2 += 2;
        }
        Box box = new Box(2);
        box.add(Box.createHorizontalGlue());
        box.add(this.buttonOK);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.buttonCancel);
        box.add(Box.createHorizontalGlue());
        jPanel.add((Component)new JSeparator(0), new TableLayoutConstraints(0, n - 4, 8, n - 4));
        jPanel.add((Component)box, new TableLayoutConstraints(0, n - 2, 8, n - 2));
        this.setContentPane(jPanel);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.pack();
    }

    private boolean inputMaybeValid() {
        boolean bl;
        try {
            int n = Integer.parseInt(this.textPort.getText());
            bl = n > 0 && n < 65536;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (!bl || this.textServerName.getDocument().getLength() == 0) {
            JOptionPane.showMessageDialog(this, Utils._("You have to specify a server name and port."), Utils._("Error"), 0);
            return false;
        }
        return true;
    }

    private boolean testConnection() {
        if (!this.inputMaybeValid()) {
            return false;
        }
        try {
            Object object;
            String[] stringArray;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            hashtable.put("java.naming.provider.url", "ldap://" + this.textServerName.getText() + ":" + this.textPort.getText() + "/" + LDAPSettings.sanitizeDN(this.textBaseDN.getText()));
            if (this.checkDoAuth.isSelected()) {
                hashtable.put("java.naming.security.authentication", "simple");
                hashtable.put("java.naming.security.principal", LDAPSettings.sanitizeDN(this.textBindDN.getText()));
                if (this.checkAskForPassword.isSelected()) {
                    stringArray = PasswordDialog.showPasswordDialog(this, Utils._("LDAP password"), Utils._("Please enter the LDAP password:"), this.textBindDN.getText(), false);
                    if (stringArray == null) {
                        return false;
                    }
                    object = stringArray[1];
                } else {
                    object = new String(this.textPassword.getPassword());
                }
                hashtable.put("java.naming.security.credentials", object);
            } else {
                hashtable.put("java.naming.security.authentication", "none");
            }
            object = new InitialDirContext(hashtable);
            stringArray = new SearchControls();
            if (this.checkSearchSubtree.isSelected()) {
                stringArray.setSearchScope(2);
            } else {
                stringArray.setSearchScope(1);
            }
            stringArray.setReturningAttributes(new String[0]);
            String string = this.textFilter.getText();
            if (string.length() == 0) {
                string = "(objectClass=*)";
            }
            NamingEnumeration<SearchResult> namingEnumeration = object.search("", string, (SearchControls)stringArray);
            namingEnumeration.close();
            object.close();
            return true;
        }
        catch (NamingException namingException) {
            ExceptionDialog.showExceptionDialog(this, Utils._("Could not connect to the LDAP server:"), namingException);
            return false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            if (!this.inputMaybeValid()) {
                return;
            }
            this.clickedOK = true;
            this.setVisible(false);
        } else if (string.equals("test") && this.testConnection()) {
            JOptionPane.showMessageDialog(this, Utils._("Connection to the LDAP server succeeded."));
        }
    }

    private void readFromConnectionSettings(LDAPSettings lDAPSettings) {
        this.textBaseDN.setText(lDAPSettings.baseDN);
        this.textBindDN.setText(lDAPSettings.bindDN);
        this.textFilter.setText(lDAPSettings.objectFilter);
        this.textPassword.setText(lDAPSettings.credential.getPassword());
        this.textPort.setText(Integer.toString(lDAPSettings.port));
        this.textServerName.setText(lDAPSettings.serverName);
        this.textDisplayCaption.setText(lDAPSettings.displayCaption);
        this.textCountLimit.setText(Integer.toString(lDAPSettings.countLimit));
        for (Map.Entry<PBEntryField, JTextField> entry : this.mappingFields.entrySet()) {
            entry.getValue().setText(lDAPSettings.getMappingFor(entry.getKey()));
        }
        this.checkAskForPassword.setSelected(lDAPSettings.askForCredential);
        this.checkDoAuth.setSelected(lDAPSettings.useAuth);
        this.checkSearchSubtree.setSelected(lDAPSettings.searchSubTree);
        this.checkInitiallyShowAll.setSelected(lDAPSettings.initiallyLoadAll);
    }

    private void writeToConnectionSettings(LDAPSettings lDAPSettings) {
        lDAPSettings.baseDN = this.textBaseDN.getText();
        lDAPSettings.bindDN = this.textBindDN.getText();
        lDAPSettings.objectFilter = this.textFilter.getText();
        lDAPSettings.credential.setPassword(new String(this.textPassword.getPassword()));
        lDAPSettings.port = Integer.parseInt(this.textPort.getText());
        lDAPSettings.serverName = this.textServerName.getText();
        lDAPSettings.displayCaption = this.textDisplayCaption.getText();
        lDAPSettings.countLimit = Integer.parseInt(this.textCountLimit.getText());
        for (Map.Entry<PBEntryField, JTextField> entry : this.mappingFields.entrySet()) {
            lDAPSettings.setMappingFor(entry.getKey(), entry.getValue().getText());
        }
        lDAPSettings.askForCredential = this.checkAskForPassword.isSelected();
        lDAPSettings.useAuth = this.checkDoAuth.isSelected();
        lDAPSettings.searchSubTree = this.checkSearchSubtree.isSelected();
        lDAPSettings.initiallyLoadAll = this.checkInitiallyShowAll.isSelected();
    }

    public ConnectionDialog(Frame frame) {
        super(frame, Utils._("New LDAP phone book"));
        this.initialize();
    }

    public ConnectionDialog(Dialog dialog) {
        super(dialog, Utils._("New LDAP phone book"));
        this.initialize();
    }

    public boolean browseForPhonebook(LDAPSettings lDAPSettings) {
        this.readFromConnectionSettings(lDAPSettings);
        this.clickedOK = false;
        this.setVisible(true);
        if (this.clickedOK) {
            this.writeToConnectionSettings(lDAPSettings);
        }
        this.dispose();
        return this.clickedOK;
    }
}

