/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.ldap;

import java.util.logging.Logger;
import yajhfc.Password;
import yajhfc.Utils;
import yajhfc.phonebook.GeneralConnectionSettings;
import yajhfc.phonebook.PBEntryField;

public class LDAPSettings
extends GeneralConnectionSettings {
    public String serverName = "";
    public int port = 389;
    public String baseDN = "";
    public boolean useAuth = false;
    public String bindDN = "";
    public final Password credential = new Password();
    public boolean askForCredential = false;
    public boolean initiallyLoadAll = true;
    public int countLimit = 1000;
    public String objectFilter = "(facsimileTelephoneNumber=*)";
    public boolean searchSubTree = true;
    public String displayCaption = "";
    private static final int STATE_NORMAL = 0;
    private static final int STATE_INQUOTE = 1;
    private static final int STATE_CURCHARESCAPED = 2;
    private static final int STATE_STRIPSPACES = 3;

    public String[] getAttributes() {
        int n = 0;
        PBEntryField[] pBEntryFieldArray = PBEntryField.values();
        for (PBEntryField pBEntryField : pBEntryFieldArray) {
            if (LDAPSettings.isNoField(this.getMappingFor(pBEntryField))) continue;
            ++n;
        }
        Object[] objectArray = new String[n];
        int n2 = 0;
        for (PBEntryField pBEntryField : pBEntryFieldArray) {
            String string = this.getMappingFor(pBEntryField);
            if (LDAPSettings.isNoField(string)) continue;
            objectArray[n2++] = string;
        }
        return objectArray;
    }

    public LDAPSettings() {
        super("");
        this.setMappingFor(PBEntryField.Name, "sn");
        this.setMappingFor(PBEntryField.GivenName, "givenName");
        this.setMappingFor(PBEntryField.Location, "l");
        this.setMappingFor(PBEntryField.Position, "title");
        this.setMappingFor(PBEntryField.Company, "o");
        this.setMappingFor(PBEntryField.VoiceNumber, "telephoneNumber");
        this.setMappingFor(PBEntryField.FaxNumber, "facsimileTelephoneNumber");
        this.setMappingFor(PBEntryField.Comment, "description");
        this.setMappingFor(PBEntryField.Department, "ou");
        this.setMappingFor(PBEntryField.EMailAddress, "mail");
        this.setMappingFor(PBEntryField.Street, "street");
        this.setMappingFor(PBEntryField.State, "st");
        this.setMappingFor(PBEntryField.ZIPCode, "postalCode");
        this.setMappingFor(PBEntryField.Country, "c");
        this.setMappingFor(PBEntryField.WebSite, "URL");
    }

    public LDAPSettings(String string) {
        this();
        this.loadFromString(string);
    }

    public LDAPSettings(LDAPSettings lDAPSettings) {
        this();
        this.copyFrom(lDAPSettings);
    }

    public static String sanitizeDN(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (n) {
                default: {
                    stringBuilder.append(c);
                    switch (c) {
                        case '\"': {
                            n = 1;
                            continue block10;
                        }
                        case '\\': {
                            n = 2;
                            continue block10;
                        }
                        case ',': 
                        case ';': {
                            n = 3;
                            continue block10;
                        }
                    }
                    continue block10;
                }
                case 1: {
                    stringBuilder.append(c);
                    if (c != '\"') continue block10;
                    n = 0;
                    continue block10;
                }
                case 2: {
                    stringBuilder.append(c);
                    n = 0;
                    continue block10;
                }
                case 3: {
                    if (Character.isWhitespace(c)) continue block10;
                    stringBuilder.append(c);
                    n = 0;
                }
            }
        }
        if (Utils.debugMode) {
            Logger.getLogger(LDAPSettings.class.getName()).fine("Changed DN from \"" + string + "\" to \"" + stringBuilder + "\"");
        }
        return stringBuilder.toString();
    }
}

