/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.filters.Filter;
import yajhfc.phonebook.DistributionList;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.PhoneBookEntryList;
import yajhfc.phonebook.PhonebookEvent;
import yajhfc.phonebook.PhonebookEventListener;
import yajhfc.phonebook.convrules.PBEntryFieldContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoneBookSorter
implements PhonebookEventListener,
PhoneBookEntryList {
    protected final PhoneBook phoneBook;
    protected final ArrayList<Row> originalList = new ArrayList();
    protected final ArrayList<Row> sortedList = new ArrayList();
    protected final List<PhoneBookEntry> sortedView = Collections.unmodifiableList(this.sortedList);
    protected List<PhoneBookEntry> filteredList = null;
    protected final List<PhonebookEventListener> listeners = new ArrayList<PhonebookEventListener>();
    protected RowComparator comparator;
    protected Filter<PhoneBookEntry, PBEntryField> filter;
    private static final Comparator<Row> SORT_INDEX_COMPARATOR = new Comparator<Row>(){

        @Override
        public int compare(Row row, Row row2) {
            return row.sortedIndex - row2.sortedIndex;
        }
    };
    private static final Row[] dummy = new Row[0];

    public PhoneBookSorter(PhoneBook phoneBook) {
        this(phoneBook, null, null);
    }

    public PhoneBookSorter(PhoneBook phoneBook, Comparator<PhoneBookEntry> comparator, Filter<PhoneBookEntry, PBEntryField> filter) {
        this.phoneBook = phoneBook;
        this.comparator = comparator == null ? null : new RowComparator(comparator);
        this.filter = filter;
        this.refresh();
        phoneBook.addPhonebookEventListener(this);
    }

    public PhoneBook getPhoneBook() {
        return this.phoneBook;
    }

    public Comparator<PhoneBookEntry> getComparator() {
        return this.comparator.wrapped;
    }

    public Filter<PhoneBookEntry, PBEntryField> getFilter() {
        return this.filter;
    }

    public void setFilter(Filter<PhoneBookEntry, PBEntryField> filter) {
        if (this.filter != filter) {
            this.filter = filter;
            List<PhoneBookEntry> list = this.getEntries();
            this.refreshFilter();
            if (!Utils.listQuickEquals(list, this.getEntries())) {
                this.firePhonebookReloaded();
            }
        }
    }

    public void setComparator(Comparator<PhoneBookEntry> comparator) {
        if (this.comparator == null && comparator != null || this.comparator.wrapped != comparator) {
            this.comparator = comparator == null ? null : new RowComparator(comparator);
            this.refreshRowSort(this.originalList.toArray(dummy));
            this.refreshFilterSort();
            this.firePhonebookReloaded();
        }
    }

    private static Row getRowForEntry(Row[] rowArray, PhoneBookEntry phoneBookEntry) {
        for (Row row : rowArray) {
            if (row.entry != phoneBookEntry) continue;
            return row;
        }
        return null;
    }

    private void refreshFilter() {
        List<PhoneBookEntry> list = this.phoneBook.applyFilter(this.filter);
        if (list == null) {
            this.filteredList = null;
        } else {
            this.filteredList = new ArrayList<PhoneBookEntry>(list.size());
            Row[] rowArray = this.originalList.toArray(new Row[this.originalList.size()]);
            for (PhoneBookEntry phoneBookEntry : list) {
                Row row = PhoneBookSorter.getRowForEntry(rowArray, phoneBookEntry);
                if (row != null) {
                    this.filteredList.add(row);
                    continue;
                }
                Logger.getLogger(PhoneBookSorter.class.getName()).warning("No Row found for entry: " + phoneBookEntry + " (" + phoneBookEntry.getClass() + ")");
                this.filteredList.add(phoneBookEntry);
            }
        }
        this.refreshFilterSort();
    }

    private void refreshFilterSort() {
        if (this.filteredList != null) {
            if (this.comparator == null) {
                Collections.sort(this.filteredList);
            } else {
                Collections.sort(this.filteredList, this.comparator.wrapped);
            }
        }
    }

    public void refresh() {
        List<PhoneBookEntry> list = this.phoneBook.getEntries();
        Row[] rowArray = new Row[list.size()];
        this.originalList.clear();
        this.originalList.ensureCapacity(rowArray.length);
        int n = 0;
        for (PhoneBookEntry phoneBookEntry : list) {
            rowArray[n] = PhoneBookSorter.createRow(phoneBookEntry, n);
            this.originalList.add(rowArray[n]);
            ++n;
        }
        this.refreshRowSort(rowArray);
        this.refreshFilter();
        this.firePhonebookReloaded();
    }

    private void refreshRowSort(Row[] rowArray) {
        Arrays.sort(rowArray, this.comparator);
        this.sortedList.clear();
        this.sortedList.ensureCapacity(rowArray.length);
        for (int i = 0; i < rowArray.length; ++i) {
            rowArray[i].sortedIndex = i;
            this.sortedList.add(rowArray[i]);
        }
    }

    protected PhonebookEvent eventObjectForRows(Row[] rowArray) {
        int[] nArray = new int[rowArray.length];
        PhoneBookEntry[] phoneBookEntryArray = new PhoneBookEntry[rowArray.length];
        for (int i = 0; i < rowArray.length; ++i) {
            nArray[i] = rowArray[i].sortedIndex;
            phoneBookEntryArray[i] = rowArray[i].entry;
        }
        return new PhonebookEvent(this, phoneBookEntryArray, nArray);
    }

    @Override
    public void elementsRemoved(PhonebookEvent phonebookEvent) {
        if (phonebookEvent.getEntries().length > this.phoneBook.getEntries().size() / 2) {
            this.refresh();
        } else {
            int n;
            int[] nArray = phonebookEvent.getIndices();
            Row[] rowArray = new Row[nArray.length];
            for (n = nArray.length - 1; n >= 0; --n) {
                rowArray[n] = this.originalList.remove(nArray[n]);
            }
            Arrays.sort(rowArray, SORT_INDEX_COMPARATOR);
            for (n = rowArray.length - 1; n >= 0; --n) {
                this.sortedList.remove(rowArray[n].sortedIndex);
            }
            for (n = rowArray[0].sortedIndex; n < this.sortedList.size(); ++n) {
                this.sortedList.get((int)n).sortedIndex = n;
            }
            if (this.isShowingFilteredResults()) {
                this.refreshFilter();
            } else {
                this.fireEntriesRemoved(this.eventObjectForRows(rowArray));
            }
        }
    }

    @Override
    public void elementsAdded(PhonebookEvent phonebookEvent) {
        if (phonebookEvent.getEntries().length > this.phoneBook.getEntries().size() / 2) {
            this.refresh();
        } else {
            int n;
            int[] nArray = phonebookEvent.getIndices();
            PhoneBookEntry[] phoneBookEntryArray = phonebookEvent.getEntries();
            Row[] rowArray = new Row[phoneBookEntryArray.length];
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MAX_VALUE;
            int n4 = this.originalList.size();
            for (n = 0; n < phoneBookEntryArray.length; ++n) {
                int n5;
                int n6 = nArray[n];
                Row row = rowArray[n] = PhoneBookSorter.createRow(phoneBookEntryArray[n], n6);
                this.originalList.add(n6, row);
                if (n6 < n3) {
                    n3 = n6;
                }
                if ((n5 = Utils.sortedInsert(this.sortedList, row, this.comparator)) >= n2) continue;
                n2 = n5;
            }
            for (n = n2; n < this.sortedList.size(); ++n) {
                this.sortedList.get((int)n).sortedIndex = n;
            }
            if (n3 < n4) {
                for (n = n3; n < this.originalList.size(); ++n) {
                    this.originalList.get((int)n).originalIndex = n;
                }
            }
            if (this.isShowingFilteredResults()) {
                this.refreshFilter();
            } else {
                Arrays.sort(rowArray, SORT_INDEX_COMPARATOR);
                this.fireEntriesAdded(this.eventObjectForRows(rowArray));
            }
        }
    }

    @Override
    public void elementsChanged(PhonebookEvent phonebookEvent) {
        if (this.isShowingFilteredResults() || phonebookEvent.getEntries().length > this.phoneBook.getEntries().size() / 2) {
            this.refreshRowSort(this.originalList.toArray(dummy));
            this.refreshFilter();
            this.firePhonebookReloaded();
        } else {
            int n;
            int n2;
            int n3;
            int[] nArray = phonebookEvent.getIndices();
            Row[] rowArray = new Row[nArray.length];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                rowArray[n3] = this.originalList.get(nArray[n3]);
            }
            Arrays.sort(rowArray, SORT_INDEX_COMPARATOR);
            for (n3 = rowArray.length - 1; n3 >= 0; --n3) {
                n2 = rowArray[n3].sortedIndex;
                this.sortedList.remove(n2);
            }
            n3 = rowArray[0].sortedIndex;
            n2 = rowArray[rowArray.length - 1].sortedIndex;
            for (n = 0; n < rowArray.length; ++n) {
                Row row = rowArray[n];
                int n4 = Utils.sortedInsert(this.sortedList, row, this.comparator);
                if (n4 >= n3) continue;
                n3 = n4;
            }
            for (n = n3; n < this.sortedList.size(); ++n) {
                this.sortedList.get((int)n).sortedIndex = n;
            }
            for (n = 0; n < rowArray.length; ++n) {
                int n5 = rowArray[n].sortedIndex;
                if (n5 <= n2) continue;
                n2 = n5;
            }
            this.fireEntriesChanged(PhonebookEvent.createForInterval(this, n3, n2));
        }
    }

    @Override
    public void phonebookReloaded(PhonebookEvent phonebookEvent) {
        this.refresh();
    }

    @Override
    public List<PhoneBookEntry> getEntries() {
        if (this.isShowingFilteredResults()) {
            return this.filteredList;
        }
        return this.sortedView;
    }

    public List<PhoneBookEntry> getSortedEntries() {
        return this.sortedView;
    }

    public List<PhoneBookEntry> getFilteredEntries() {
        return this.filteredList;
    }

    public boolean isShowingFilteredResults() {
        return this.filteredList != null;
    }

    @Override
    public void addEntries(Collection<? extends PBEntryFieldContainer> collection) {
        this.phoneBook.addEntries(collection);
    }

    @Override
    public PhoneBookEntry addNewEntry() {
        return this.phoneBook.addNewEntry();
    }

    @Override
    public PhoneBookEntry addNewEntry(PBEntryFieldContainer pBEntryFieldContainer) {
        return this.phoneBook.addNewEntry(pBEntryFieldContainer);
    }

    @Override
    public boolean isReadOnly() {
        return this.phoneBook.isReadOnly();
    }

    @Override
    public void addPhonebookEventListener(PhonebookEventListener phonebookEventListener) {
        this.listeners.add(phonebookEventListener);
    }

    @Override
    public void removePhonebookEventListener(PhonebookEventListener phonebookEventListener) {
        this.listeners.remove(phonebookEventListener);
    }

    protected void fireEntriesAdded(PhonebookEvent phonebookEvent) {
        for (PhonebookEventListener phonebookEventListener : this.listeners) {
            phonebookEventListener.elementsAdded(phonebookEvent);
        }
    }

    protected void fireEntriesChanged(PhonebookEvent phonebookEvent) {
        for (PhonebookEventListener phonebookEventListener : this.listeners) {
            phonebookEventListener.elementsChanged(phonebookEvent);
        }
    }

    protected void fireEntriesRemoved(PhonebookEvent phonebookEvent) {
        for (PhonebookEventListener phonebookEventListener : this.listeners) {
            phonebookEventListener.elementsRemoved(phonebookEvent);
        }
    }

    protected void firePhonebookReloaded() {
        this.firePhonebookReloaded(new PhonebookEvent(this, null, null));
    }

    protected void firePhonebookReloaded(PhonebookEvent phonebookEvent) {
        for (PhonebookEventListener phonebookEventListener : this.listeners) {
            phonebookEventListener.phonebookReloaded(phonebookEvent);
        }
    }

    public String toString() {
        return this.phoneBook.toString();
    }

    public void detach() {
        this.phoneBook.removePhonebookEventListener(this);
        this.sortedList.clear();
        this.originalList.clear();
        this.filteredList = null;
    }

    static Row createRow(PhoneBookEntry phoneBookEntry, int n) {
        if (phoneBookEntry instanceof DistributionList) {
            return new DistListRow((DistributionList)phoneBookEntry, n);
        }
        return new Row(phoneBookEntry, n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DistListRow
    extends Row
    implements DistributionList {
        @Override
        public List<PhoneBookEntry> getEntries() {
            return ((DistributionList)this.entry).getEntries();
        }

        @Override
        public void addEntries(Collection<? extends PBEntryFieldContainer> collection) {
            ((DistributionList)this.entry).addEntries(collection);
        }

        @Override
        public PhoneBookEntry addNewEntry() {
            return ((DistributionList)this.entry).addNewEntry();
        }

        @Override
        public PhoneBookEntry addNewEntry(PBEntryFieldContainer pBEntryFieldContainer) {
            return ((DistributionList)this.entry).addNewEntry(pBEntryFieldContainer);
        }

        @Override
        public void addPhonebookEventListener(PhonebookEventListener phonebookEventListener) {
            ((DistributionList)this.entry).addPhonebookEventListener(phonebookEventListener);
        }

        @Override
        public void removePhonebookEventListener(PhonebookEventListener phonebookEventListener) {
            ((DistributionList)this.entry).removePhonebookEventListener(phonebookEventListener);
        }

        @Override
        public boolean isReadOnly() {
            return ((DistributionList)this.entry).isReadOnly();
        }

        public DistListRow(DistributionList distributionList, int n) {
            super(distributionList, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Row
    implements Comparable<PhoneBookEntry>,
    PhoneBookEntry {
        public final PhoneBookEntry entry;
        public int originalIndex;
        public int sortedIndex = -1;

        @Override
        public int compareTo(PhoneBookEntry phoneBookEntry) {
            return this.entry.compareTo(phoneBookEntry);
        }

        @Override
        public String getField(PBEntryField pBEntryField) {
            return this.entry.getField(pBEntryField);
        }

        @Override
        public Object getFilterData(Object object) {
            return this.entry.getFilterData(object);
        }

        @Override
        public PhoneBook getParent() {
            return this.entry.getParent();
        }

        @Override
        public void setField(PBEntryField pBEntryField, String string) {
            this.entry.setField(pBEntryField, string);
        }

        @Override
        public void delete() {
            this.entry.delete();
        }

        @Override
        public void commit() {
            this.entry.commit();
        }

        @Override
        public void updateDisplay() {
            this.entry.updateDisplay();
        }

        @Override
        public void copyFrom(PBEntryFieldContainer pBEntryFieldContainer) {
            this.entry.copyFrom(pBEntryFieldContainer);
        }

        @Override
        public void refreshToStringRule() {
            this.entry.refreshToStringRule();
        }

        public String toString() {
            return this.entry.toString();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            return object == this.entry;
        }

        public Row(PhoneBookEntry phoneBookEntry, int n) {
            this.entry = phoneBookEntry;
            this.originalIndex = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RowComparator
    implements Comparator<Row> {
        public final Comparator<PhoneBookEntry> wrapped;

        @Override
        public int compare(Row row, Row row2) {
            return this.wrapped.compare(row.entry, row2.entry);
        }

        public RowComparator(Comparator<PhoneBookEntry> comparator) {
            this.wrapped = comparator;
        }
    }
}

