/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import yajhfc.Utils;
import yajhfc.filters.Filter;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.PhonebookEvent;
import yajhfc.phonebook.PhonebookEventListener;
import yajhfc.phonebook.convrules.EntryToStringRule;
import yajhfc.phonebook.ui.PhoneBookSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoneBookTreeModel
implements TreeModel,
PhonebookEventListener {
    protected final List<PhoneBook> phoneBooks = new ArrayList<PhoneBook>();
    protected final EventListenerList listeners = new EventListenerList();
    protected final RootNode rootNode;
    protected JTree tree;
    protected EntryToStringRule entryToStringRule = PhoneBook.DEFAULT_TOSTRINGRULE;
    protected Comparator<PhoneBookEntry> comparator = null;
    protected Filter<PhoneBookEntry, PBEntryField> filter = null;

    public void addPhoneBook(PhoneBook phoneBook) {
        this.phoneBooks.add(phoneBook);
        phoneBook.setEntryToStringRule(this.entryToStringRule);
        PhoneBookSorter phoneBookSorter = new PhoneBookSorter(phoneBook, this.comparator, this.filter);
        phoneBookSorter.addPhonebookEventListener(this);
        phoneBook.treeModelData = phoneBookSorter;
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, new Object[]{this.rootNode}, new int[]{this.phoneBooks.size() - 1}, new Object[]{phoneBook}));
    }

    public void removePhoneBook(PhoneBook phoneBook) {
        int n = this.phoneBooks.indexOf(phoneBook);
        if (n < 0) {
            return;
        }
        this.phoneBooks.remove(n);
        PhoneBookSorter phoneBookSorter = (PhoneBookSorter)phoneBook.treeModelData;
        phoneBookSorter.removePhonebookEventListener(this);
        phoneBookSorter.detach();
        this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, new Object[]{this.rootNode}, new int[]{n}, new Object[]{phoneBook}));
    }

    public void refreshPhoneBook(PhoneBook phoneBook) {
        PhoneBookSorter phoneBookSorter = (PhoneBookSorter)phoneBook.treeModelData;
        phoneBookSorter.refresh();
    }

    public List<PhoneBook> getPhoneBooks() {
        return this.phoneBooks;
    }

    public void sortPhonebooks() {
        Collections.sort(this.phoneBooks, new Comparator<PhoneBook>(){

            @Override
            public int compare(PhoneBook phoneBook, PhoneBook phoneBook2) {
                int n = phoneBook.toString().compareToIgnoreCase(phoneBook2.toString());
                if (n == 0) {
                    n = phoneBook.getDescriptor().compareTo(phoneBook2.getDescriptor());
                }
                return n;
            }
        });
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.rootNode}));
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(TreeModelListener.class, treeModelListener);
    }

    public void addPBTreeModelListener(PBTreeModelListener pBTreeModelListener) {
        this.listeners.add(PBTreeModelListener.class, pBTreeModelListener);
    }

    public void removePBTreeModelListener(PBTreeModelListener pBTreeModelListener) {
        this.listeners.remove(PBTreeModelListener.class, pBTreeModelListener);
    }

    @Override
    public Object getChild(Object object, int n) {
        if (object instanceof RootNode) {
            return this.phoneBooks.get(n);
        }
        if (object instanceof PhoneBook) {
            List<PhoneBookEntry> list = PhoneBookTreeModel.entriesFromPB((PhoneBook)object);
            return list == null ? null : list.get(n);
        }
        return null;
    }

    @Override
    public int getChildCount(Object object) {
        if (object instanceof RootNode) {
            return this.phoneBooks.size();
        }
        if (object instanceof PhoneBook) {
            List<PhoneBookEntry> list = PhoneBookTreeModel.entriesFromPB((PhoneBook)object);
            return list == null ? 0 : list.size();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object instanceof RootNode) {
            return this.phoneBooks.indexOf(object2);
        }
        if (object instanceof PhoneBook && object2 instanceof PhoneBookEntry) {
            List<PhoneBookEntry> list = PhoneBookTreeModel.entriesFromPB((PhoneBook)object);
            return list == null ? -1 : list.indexOf(object2);
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.rootNode;
    }

    @Override
    public boolean isLeaf(Object object) {
        return !(object instanceof RootNode) && !(object instanceof PhoneBook);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public Comparator<PhoneBookEntry> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<PhoneBookEntry> comparator) {
        if (this.comparator != comparator) {
            this.comparator = comparator;
            for (PhoneBook phoneBook : this.phoneBooks) {
                PhoneBookSorter phoneBookSorter = (PhoneBookSorter)phoneBook.treeModelData;
                phoneBookSorter.setComparator(comparator);
            }
        }
    }

    protected void resetFilter() {
        this.applyFilter(null);
        this.fireFilterWasReset();
    }

    public void applyFilter(Filter<PhoneBookEntry, PBEntryField> filter) {
        if (this.filter != filter) {
            this.filter = filter;
            for (PhoneBook phoneBook : this.phoneBooks) {
                PhoneBookSorter phoneBookSorter = (PhoneBookSorter)phoneBook.treeModelData;
                phoneBookSorter.setFilter(filter);
            }
        }
    }

    private static List<PhoneBookEntry> entriesFromPB(PhoneBook phoneBook) {
        return ((PhoneBookSorter)phoneBook.treeModelData).getEntries();
    }

    protected void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            ((TreeModelListener)objectArray[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            ((TreeModelListener)objectArray[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            ((TreeModelListener)objectArray[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            ((TreeModelListener)objectArray[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireFilterWasReset() {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PBTreeModelListener.class) continue;
            ((PBTreeModelListener)objectArray[i + 1]).filterWasReset();
        }
    }

    @Override
    public void elementsAdded(PhonebookEvent phonebookEvent) {
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, new Object[]{this.rootNode, ((PhoneBookSorter)phonebookEvent.getSource()).getPhoneBook()}, phonebookEvent.getIndices(), (Object[])phonebookEvent.getEntries()));
    }

    @Override
    public void elementsChanged(PhonebookEvent phonebookEvent) {
        this.phonebookReloaded(phonebookEvent);
    }

    @Override
    public void elementsRemoved(PhonebookEvent phonebookEvent) {
        this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, new Object[]{this.rootNode, ((PhoneBookSorter)phonebookEvent.getSource()).getPhoneBook()}, phonebookEvent.getIndices(), (Object[])phonebookEvent.getEntries()));
    }

    @Override
    public void phonebookReloaded(PhonebookEvent phonebookEvent) {
        TreePath[] treePathArray = null;
        if (this.tree != null) {
            treePathArray = this.tree.getSelectionPaths();
        }
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.rootNode, ((PhoneBookSorter)phonebookEvent.getSource()).getPhoneBook()}));
        if (this.tree != null) {
            this.tree.setSelectionPaths(treePathArray);
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setTree(JTree jTree) {
        this.tree = jTree;
    }

    public EntryToStringRule getEntryToStringRule() {
        return this.entryToStringRule;
    }

    public void setEntryToStringRule(EntryToStringRule entryToStringRule) {
        if (entryToStringRule != this.entryToStringRule) {
            this.entryToStringRule = entryToStringRule;
            for (PhoneBook phoneBook : this.getPhoneBooks()) {
                phoneBook.setEntryToStringRule(entryToStringRule);
                List<PhoneBookEntry> list = PhoneBookTreeModel.entriesFromPB(phoneBook);
                Object[] objectArray = list.toArray();
                int[] nArray = new int[objectArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = i;
                }
                this.fireTreeNodesChanged(new TreeModelEvent((Object)this, new Object[]{this.rootNode, phoneBook}, nArray, objectArray));
            }
        }
    }

    public void setNameToStringRule(EntryToStringRule entryToStringRule) {
        this.setEntryToStringRule(PhoneBook.toStringRuleFromNameRule(entryToStringRule));
    }

    public PhoneBookTreeModel() {
        this.rootNode = new RootNode(Utils._("All phone books"));
    }

    public RootNode getRootNode() {
        return this.rootNode;
    }

    public boolean isShowingFilteredResults() {
        return this.filter != null;
    }

    public static interface PBTreeModelListener
    extends EventListener {
        public void filterWasReset();
    }

    public static class RootNode {
        private String caption;

        public String toString() {
            return this.caption;
        }

        public RootNode(String string) {
            this.caption = string;
        }
    }
}

