/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import yajhfc.Utils;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.convrules.ConcatRule;
import yajhfc.phonebook.convrules.EntryToStringRule;
import yajhfc.phonebook.convrules.RuleParser;
import yajhfc.util.CancelAction;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ExcDialogAbstractAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleParserDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(RuleParserDialog.class.getName());
    private static final int border = 10;
    JList listFields;
    JList listExamples;
    Action actOK;
    Action actValidate;
    Action actAddField;
    Action actAddExample;
    JTextArea textEdit;
    ConcatRule result;

    public RuleParserDialog(Frame frame, String string, EntryToStringRule[] entryToStringRuleArray) throws HeadlessException {
        super(frame, string, true);
        this.initialize(entryToStringRuleArray);
    }

    public RuleParserDialog(Dialog dialog, String string, EntryToStringRule[] entryToStringRuleArray) throws HeadlessException {
        super(dialog, string, true);
        this.initialize(entryToStringRuleArray);
    }

    private void initialize(EntryToStringRule[] entryToStringRuleArray) {
        this.listFields = new JList<String>(this.buildFieldList(PBEntryField.values()));
        this.actAddField = new AddFromListAction(this.listFields);
        this.listExamples = new JList<String>(this.buildRuleList(entryToStringRuleArray));
        this.actAddExample = new AddFromListAction(this.listExamples);
        this.textEdit = new JTextArea();
        this.textEdit.setFont(new Font("DialogInput", 0, 12));
        ClipboardPopup.DEFAULT_POPUP.addToComponent(this.textEdit);
        this.actOK = new ExcDialogAbstractAction(Utils._("OK")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                RuleParserDialog.this.result = RuleParserDialog.this.validateRule();
                if (RuleParserDialog.this.result != null) {
                    RuleParserDialog.this.dispose();
                }
            }
        };
        this.actValidate = new ExcDialogAbstractAction(Utils._("Validate")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                ConcatRule concatRule = RuleParserDialog.this.validateRule();
                if (concatRule != null) {
                    JOptionPane.showMessageDialog(RuleParserDialog.this, Utils._("Display style is valid."));
                }
            }
        };
        CancelAction cancelAction = new CancelAction(this);
        double[][] dArrayArray = new double[][]{{10.0, 0.5, 10.0, -1.0, 10.0}, {10.0, -2.0, 10.0, -2.0, -2.0, 10.0, -1.0, 10.0, -2.0, 10.0}};
        JPanel jPanel = new JPanel(new TableLayout(dArrayArray));
        jPanel.add((Component)new JLabel("<html>" + Utils._("Please enter the desired display style in the text box below. Double click on the lists to add the selected field/predefined style.") + "</html>"), "1,1,3,1,c,c");
        Utils.addWithLabel(jPanel, (Component)new JScrollPane(this.listFields), Utils._("Available fields"), "1,4,1,4,f,f");
        Utils.addWithLabel(jPanel, (Component)new JScrollPane(this.listExamples), Utils._("Predefined styles"), "3,4,3,4,f,f");
        jPanel.add((Component)new JScrollPane(this.textEdit), "1,6,3,6,f,f");
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 10, 10));
        jPanel2.add(new JButton(this.actOK));
        jPanel2.add(new JButton(this.actValidate));
        jPanel2.add(new JButton(cancelAction));
        jPanel.add((Component)jPanel2, "1,8,3,8,f,c");
        this.setContentPane(jPanel);
        this.setDefaultCloseOperation(2);
        this.setSize(800, 600);
        Utils.setDefWinPos(this);
    }

    ConcatRule validateRule() {
        String string = this.textEdit.getText();
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(this, Utils._("Please enter a display style."), Utils._("Validate"), 2);
            return null;
        }
        try {
            ConcatRule concatRule = RuleParser.parseRule(string, true);
            boolean bl = false;
            for (Object object : concatRule.getChildren()) {
                if (!(object instanceof PBEntryField)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this, Utils._("The display style must contain at least one field."), Utils._("Validate"), 2);
                return null;
            }
            return concatRule;
        }
        catch (RuleParser.RuleParseException ruleParseException) {
            log.log(Level.INFO, "Validation failed", ruleParseException);
            JOptionPane.showMessageDialog(this, Utils._("Display style is not valid") + ":\n" + ruleParseException.getLocalizedMessage(), Utils._("Validate"), 2);
            int n = ruleParseException.getErrorEnd() + 1;
            if (n == 0) {
                n = string.length();
            }
            this.textEdit.select(ruleParseException.getErrorOffset(), n);
            this.textEdit.requestFocusInWindow();
            return null;
        }
    }

    private Vector<String> buildFieldList(PBEntryField[] pBEntryFieldArray) {
        Vector<String> vector = new Vector<String>(pBEntryFieldArray.length);
        for (PBEntryField pBEntryField : pBEntryFieldArray) {
            vector.add("[" + pBEntryField.getDescription() + "]");
        }
        return vector;
    }

    private Vector<String> buildRuleList(EntryToStringRule[] entryToStringRuleArray) {
        Vector<String> vector = new Vector<String>(entryToStringRuleArray.length);
        for (EntryToStringRule entryToStringRule : entryToStringRuleArray) {
            vector.add(RuleParser.ruleToString(entryToStringRule, true));
        }
        return vector;
    }

    public void setEditedRule(EntryToStringRule entryToStringRule) {
        this.textEdit.setText(RuleParser.ruleToString(entryToStringRule, true));
    }

    public static ConcatRule showForRule(Window window, String string, EntryToStringRule[] entryToStringRuleArray, EntryToStringRule entryToStringRule) {
        RuleParserDialog ruleParserDialog;
        if (window instanceof Dialog) {
            ruleParserDialog = new RuleParserDialog((Dialog)window, string, entryToStringRuleArray);
        } else if (window instanceof Frame) {
            ruleParserDialog = new RuleParserDialog((Frame)window, string, entryToStringRuleArray);
        } else {
            throw new RuntimeException("owner must be a Dialog or Frame");
        }
        ruleParserDialog.setEditedRule(entryToStringRule);
        ruleParserDialog.setVisible(true);
        return ruleParserDialog.result;
    }

    class AddFromListAction
    extends ExcDialogAbstractAction
    implements MouseListener,
    ListSelectionListener {
        protected final JList list;
        protected JPopupMenu popupMenu;

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.setEnabled(this.list.getSelectedIndex() >= 0);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && (n = this.list.locationToIndex(mouseEvent.getPoint())) >= 0) {
                this.actionPerformed(new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), ""));
            }
        }

        public JPopupMenu getPopupMenu() {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
                this.popupMenu.add(this);
            }
            return this.popupMenu;
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        protected void actualActionPerformed(ActionEvent actionEvent) {
            if (this.list.getSelectedValue() == null) {
                return;
            }
            String string = this.list.getSelectedValue().toString();
            RuleParserDialog.this.textEdit.replaceSelection(string);
            RuleParserDialog.this.textEdit.requestFocusInWindow();
        }

        public AddFromListAction(JList jList) {
            super(Utils._("Add"));
            this.list = jList;
            jList.addListSelectionListener(this);
            jList.addMouseListener(this);
            jList.getActionMap().put(this.getClass().getName(), this);
            jList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), this.getClass().getName());
        }
    }
}

