/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.ui;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import yajhfc.Utils;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.ui.NewPhoneBookWin;
import yajhfc.phonebook.ui.PhonebookPanel;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.LimitedPlainDocument;

public class SingleEntryPhonebookPanel
extends PhonebookPanel {
    Map<PBEntryField, JTextComponent> entryFields = new EnumMap<PBEntryField, JTextComponent>(PBEntryField.class);
    JScrollPane scrollComment;
    JTextArea textComment;
    boolean writable;

    public SingleEntryPhonebookPanel(NewPhoneBookWin newPhoneBookWin) {
        super(newPhoneBookWin, null, false);
        PBEntryField[] pBEntryFieldArray;
        int n = 0;
        int n2 = 0;
        for (PBEntryField pBEntryField : pBEntryFieldArray = PBEntryField.values()) {
            if (pBEntryField.isShortLength()) {
                ++n2;
                continue;
            }
            ++n;
        }
        int n3 = 2 * (n + (n2 + 1) / 2);
        double[][] dArrayArray = new double[][]{{0.5, 5.0, -1.0}, new double[n3]};
        Arrays.fill(dArrayArray[1], 0, n3 - 1, -2.0);
        dArrayArray[1][n3 - 1] = -1.0;
        TableLayout tableLayout = new TableLayout(dArrayArray);
        tableLayout.setVGap(5);
        this.setLayout(tableLayout);
        int n4 = 1;
        int n5 = 0;
        for (PBEntryField pBEntryField : pBEntryFieldArray) {
            TableLayoutConstraints tableLayoutConstraints;
            if (pBEntryField == PBEntryField.Comment) continue;
            JTextField jTextField = this.createEntryTextField(pBEntryField);
            if (pBEntryField.isShortLength()) {
                tableLayoutConstraints = new TableLayoutConstraints(n5, n4, n5, n4, 2, 0);
                if (n5 == 0) {
                    n5 = 2;
                } else {
                    n4 += 2;
                    n5 = 0;
                }
            } else {
                tableLayoutConstraints = new TableLayoutConstraints(0, n4, 2, n4, 2, 0);
                n5 = 0;
                n4 += 2;
            }
            Utils.addWithLabel((JPanel)this, (Component)jTextField, pBEntryField.getDescription() + ":", tableLayoutConstraints);
        }
        this.textComment = new JTextArea(new LimitedPlainDocument(0));
        this.textComment.setWrapStyleWord(true);
        this.textComment.setLineWrap(true);
        this.textComment.addFocusListener(this.entryListener);
        this.textComment.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.entryFields.put(PBEntryField.Comment, this.textComment);
        this.textComment.putClientProperty("YajHFC-PBEntryfield", PBEntryField.Comment);
        this.scrollComment = new JScrollPane(this.textComment, 22, 31);
        Utils.addWithLabel((JPanel)this, (Component)this.scrollComment, Utils._("Comments:"), new TableLayoutConstraints(0, n4, 2, n4, 2, 2));
    }

    public void writeToTextFields(PhoneBook phoneBook, PhoneBookEntry phoneBookEntry) {
        if (phoneBookEntry == null || phoneBook == null) {
            for (JTextComponent jTextComponent : this.entryFields.values()) {
                jTextComponent.setText("");
                jTextComponent.setEnabled(false);
            }
            this.scrollComment.setEnabled(false);
            this.writable = false;
        } else {
            boolean bl = !phoneBook.isReadOnly();
            for (Map.Entry<PBEntryField, JTextComponent> entry : this.entryFields.entrySet()) {
                JTextComponent jTextComponent = entry.getValue();
                PBEntryField pBEntryField = entry.getKey();
                jTextComponent.setText(phoneBookEntry.getField(pBEntryField));
                jTextComponent.setEnabled(phoneBook.isFieldAvailable(pBEntryField));
                jTextComponent.setEditable(bl);
                ((LimitedPlainDocument)jTextComponent.getDocument()).setLimit(phoneBook.getMaxLength(pBEntryField));
            }
            this.scrollComment.setEnabled(this.textComment.isEnabled());
            this.writable = bl;
        }
    }

    public void readFromTextFields(PhoneBookEntry phoneBookEntry, boolean bl) {
        if (phoneBookEntry == null || !this.writable || phoneBookEntry.getParent().isReadOnly()) {
            return;
        }
        for (Map.Entry<PBEntryField, JTextComponent> entry : this.entryFields.entrySet()) {
            PBEntryField pBEntryField = entry.getKey();
            if (!phoneBookEntry.getParent().isFieldAvailable(pBEntryField)) continue;
            JTextComponent jTextComponent = entry.getValue();
            phoneBookEntry.setField(pBEntryField, jTextComponent.getText());
        }
        if (bl) {
            phoneBookEntry.updateDisplay();
        } else {
            phoneBookEntry.commit();
        }
    }

    protected JTextField createEntryTextField(PBEntryField pBEntryField) {
        JTextField jTextField = super.createEntryTextField(pBEntryField);
        this.entryFields.put(pBEntryField, jTextField);
        return jTextField;
    }
}

