/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import yajhfc.Utils;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.SortOrder;
import yajhfc.util.CancelAction;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.MultiButtonGroup;
import yajhfc.util.fmtEditor;

public class SortOrderDialog
extends JDialog {
    private static final String DESCENDING_ACTION_COMMAND = "descending";
    private static final String ASCENDING_ACTION_COMMAND = "ascending";
    private static final int border = 8;
    fmtEditor<PBEntryField> fmtEditor;
    Action actOK;
    MultiButtonGroup directionGroup;
    boolean[] descending = new boolean[PBEntryField.FIELD_COUNT];
    List<PBEntryField> selectedList;
    JPanel sortDirectionPanel;
    public SortOrder result;

    public SortOrderDialog(Dialog dialog, SortOrder sortOrder) {
        super(dialog, Utils._("Custom sort order"), true);
        this.initialize(sortOrder);
    }

    public SortOrderDialog(Frame frame, SortOrder sortOrder) {
        super(frame, Utils._("Custom sort order"), true);
        this.initialize(sortOrder);
    }

    private void initialize(SortOrder sortOrder) {
        Object object;
        this.actOK = new ExcDialogAbstractAction(Utils._("OK")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                if (SortOrderDialog.this.selectedList.size() > 0) {
                    PBEntryField[] pBEntryFieldArray = SortOrderDialog.this.selectedList.toArray(new PBEntryField[SortOrderDialog.this.selectedList.size()]);
                    boolean[] blArray = new boolean[pBEntryFieldArray.length];
                    for (int i = 0; i < pBEntryFieldArray.length; ++i) {
                        blArray[i] = SortOrderDialog.this.isDescending(pBEntryFieldArray[i]);
                    }
                    SortOrderDialog.this.result = new SortOrder(pBEntryFieldArray, blArray);
                    SortOrderDialog.this.dispose();
                }
            }
        };
        this.selectedList = new ArrayList<PBEntryField>();
        if (sortOrder != null) {
            for (int i = 0; i < sortOrder.getFieldCount(); ++i) {
                object = sortOrder.getFields(i);
                this.selectedList.add((PBEntryField)object);
                this.setDescending((PBEntryField)object, sortOrder.getDescending(i));
            }
            this.actOK.setEnabled(true);
        } else {
            this.actOK.setEnabled(false);
        }
        this.fmtEditor = new fmtEditor<Object>(PBEntryField.values(), this.selectedList, Collections.emptyList(), (ListCellRenderer)new DefaultListCellRenderer(), null, null, Utils._("Selected sort order:"), Utils._("Available fields:"));
        this.fmtEditor.getSelectedList().setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                PBEntryField pBEntryField = (PBEntryField)object;
                object = pBEntryField.getDescription() + " (" + (SortOrderDialog.this.isDescending(pBEntryField) ? Utils._(SortOrderDialog.DESCENDING_ACTION_COMMAND) : Utils._(SortOrderDialog.ASCENDING_ACTION_COMMAND)) + ")";
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        this.fmtEditor.getSelectedList().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SortOrderDialog.this.loadSortDirectionPanel();
                }
            }
        });
        this.fmtEditor.getSelectedListModel().addListDataListener(new ListDataListener(){

            public void intervalRemoved(ListDataEvent listDataEvent) {
                this.checkOKEnable();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                this.checkOKEnable();
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
            }

            private void checkOKEnable() {
                SortOrderDialog.this.actOK.setEnabled(SortOrderDialog.this.selectedList.size() > 0);
            }
        });
        this.directionGroup = new MultiButtonGroup(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                int[] nArray = SortOrderDialog.this.fmtEditor.getSelectedList().getSelectedIndices();
                if (nArray.length == 0) {
                    return;
                }
                boolean bl = SortOrderDialog.DESCENDING_ACTION_COMMAND.equals(actionEvent.getActionCommand());
                for (int n : nArray) {
                    SortOrderDialog.this.setDescending(n, bl);
                    SortOrderDialog.this.fmtEditor.getSelectedListModel().changeNotify(n);
                }
            }
        };
        this.directionGroup.addItem(Utils._(ASCENDING_ACTION_COMMAND), ASCENDING_ACTION_COMMAND);
        this.directionGroup.addItem(Utils._(DESCENDING_ACTION_COMMAND), DESCENDING_ACTION_COMMAND);
        CancelAction cancelAction = new CancelAction(this);
        this.sortDirectionPanel = new JPanel();
        this.sortDirectionPanel.setLayout(new BoxLayout(this.sortDirectionPanel, 1));
        this.sortDirectionPanel.setBorder(BorderFactory.createTitledBorder(Utils._("Sort direction")));
        object = new Dimension(8, 8);
        this.sortDirectionPanel.add(Box.createRigidArea((Dimension)object));
        for (JRadioButton jRadioButton : this.directionGroup.createButtons()) {
            this.sortDirectionPanel.add(jRadioButton);
            this.sortDirectionPanel.add(Box.createRigidArea((Dimension)object));
        }
        this.loadSortDirectionPanel();
        Box box = Box.createVerticalBox();
        box.add(Box.createRigidArea((Dimension)object));
        box.add(this.sortDirectionPanel);
        box.add(Box.createVerticalGlue());
        JPanel jPanel = new JPanel(new FlowLayout(1, 8, 8));
        jPanel.add(new JButton(this.actOK));
        jPanel.add(new JButton(cancelAction));
        JPanel jPanel2 = new JPanel(new BorderLayout(8, 8));
        jPanel2.add(this.fmtEditor, "Center");
        jPanel2.add((Component)box, "East");
        jPanel2.add((Component)jPanel, "South");
        this.setContentPane(jPanel2);
        this.setSize(800, 600);
        Utils.setDefWinPos(this);
    }

    void setDescending(int n, boolean bl) {
        this.setDescending(this.selectedList.get(n), bl);
    }

    void setDescending(PBEntryField pBEntryField, boolean bl) {
        this.descending[pBEntryField.ordinal()] = bl;
    }

    boolean isDescending(int n) {
        return this.isDescending(this.selectedList.get(n));
    }

    boolean isDescending(PBEntryField pBEntryField) {
        return this.descending[pBEntryField.ordinal()];
    }

    void loadSortDirectionPanel() {
        int n = this.fmtEditor.getSelectedList().getSelectedIndex();
        Utils.enableChildren(this.sortDirectionPanel, n >= 0);
        if (n >= 0) {
            this.directionGroup.setSelectedActionCommand(this.isDescending(n) ? DESCENDING_ACTION_COMMAND : ASCENDING_ACTION_COMMAND);
        }
    }

    public static SortOrder showForSortOrder(Window window, SortOrder sortOrder) {
        SortOrderDialog sortOrderDialog;
        if (window instanceof Dialog) {
            sortOrderDialog = new SortOrderDialog((Dialog)window, sortOrder);
        } else if (window instanceof Frame) {
            sortOrderDialog = new SortOrderDialog((Frame)window, sortOrder);
        } else {
            throw new RuntimeException("owner must be a Dialog or Frame");
        }
        sortOrderDialog.setVisible(true);
        return sortOrderDialog.result;
    }
}

