/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.xml;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import yajhfc.Utils;
import yajhfc.phonebook.DefaultPhoneBookEntry;
import yajhfc.phonebook.DistributionList;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.PhonebookEventListener;
import yajhfc.phonebook.convrules.PBEntryFieldContainer;
import yajhfc.phonebook.xml.XMLPhoneBook;
import yajhfc.phonebook.xml.XMLPhoneBookEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDistributionList
extends DefaultPhoneBookEntry
implements XMLPhoneBookEntry,
DistributionList {
    private static final Logger log = Logger.getLogger(XMLDistributionList.class.getName());
    private XMLPhoneBook parent;
    private String name = "";
    private XMLPhoneBook items;
    private boolean dirty = false;

    public XMLDistributionList(XMLPhoneBook xMLPhoneBook) {
        this.parent = xMLPhoneBook;
        this.items = new XMLPhoneBook(xMLPhoneBook.parentDialog);
    }

    @Override
    public void commit() {
        for (PhoneBookEntry phoneBookEntry : this.items.getEntries().toArray(new PhoneBookEntry[this.items.getEntries().size()])) {
            phoneBookEntry.commit();
        }
        if (this.dirty || this.items.wasChanged()) {
            this.parent.writeEntry(this);
            this.dirty = false;
        }
    }

    @Override
    public void delete() {
        this.parent.deleteEntry(this);
    }

    @Override
    public void saveToXML(Element element, Document document) {
        try {
            Element element2 = document.createElement("name");
            element2.setTextContent(this.name);
            element.appendChild(element2);
            element2 = document.createElement("items");
            this.items.saveToXML(element2, document);
            element.appendChild(element2);
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error saving distribution list: ", exception);
        }
        this.dirty = false;
    }

    @Override
    public void loadFromXML(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            try {
                String string = node.getNodeName();
                if ("name".equals(string)) {
                    this.name = node.getTextContent();
                    continue;
                }
                if ("items".equals(string)) {
                    this.items.loadFromXML((Element)node);
                    continue;
                }
                log.warning("Unknown element: " + string);
                continue;
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Error reading element " + node.getNodeName() + ": ", exception);
            }
        }
        this.dirty = false;
    }

    @Override
    public PhoneBook getParent() {
        return this.parent;
    }

    @Override
    public String getField(PBEntryField pBEntryField) {
        if (pBEntryField == PBEntryField.Name) {
            return this.name;
        }
        return null;
    }

    @Override
    public void setField(PBEntryField pBEntryField, String string) {
        if (pBEntryField == PBEntryField.Name && !this.name.equals(string)) {
            this.name = string;
            this.dirty = true;
        }
    }

    @Override
    public String toString() {
        return this.name == null || this.name.length() == 0 ? Utils._("<no name>") : this.name;
    }

    @Override
    public List<PhoneBookEntry> getEntries() {
        return this.items.getEntries();
    }

    @Override
    public PhoneBookEntry addNewEntry(PBEntryFieldContainer pBEntryFieldContainer) {
        return this.items.addNewEntry(pBEntryFieldContainer);
    }

    @Override
    public void addEntries(Collection<? extends PBEntryFieldContainer> collection) {
        this.items.addEntries(collection);
    }

    @Override
    public PhoneBookEntry addNewEntry() {
        return this.items.addNewEntry();
    }

    @Override
    public void addPhonebookEventListener(PhonebookEventListener phonebookEventListener) {
        this.items.addPhonebookEventListener(phonebookEventListener);
    }

    @Override
    public void removePhonebookEventListener(PhonebookEventListener phonebookEventListener) {
        this.items.removePhonebookEventListener(phonebookEventListener);
    }

    @Override
    public boolean isReadOnly() {
        return this.parent.isReadOnly();
    }
}

