/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.xml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import yajhfc.Utils;
import yajhfc.phonebook.DefaultPhoneBookEntry;
import yajhfc.phonebook.DistributionList;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.PhoneBookException;
import yajhfc.phonebook.xml.SingleXMLPhoneBookEntry;
import yajhfc.phonebook.xml.XMLDistributionList;
import yajhfc.phonebook.xml.XMLPhoneBookEntry;
import yajhfc.phonebook.xml.XMLSettings;
import yajhfc.util.ExampleFileFilter;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.SafeJFileChooser;
import yajhfc.util.TransactFileOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPhoneBook
extends PhoneBook {
    private static final Logger log = Logger.getLogger(XMLPhoneBook.class.getName());
    public static final String PB_Prefix = "XML";
    public static final String PB_DisplayName = Utils._("XML phone book");
    public static final String PB_Description = Utils._("A phone book saving its entries as a XML file.");
    public static final boolean PB_CanExport = true;
    private ArrayList<XMLPhoneBookEntry> list;
    private XMLSettings settings;
    private boolean isOpened = false;
    private boolean wasChanged = false;
    protected final boolean allowDistLists;
    protected static DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY;
    protected static TransformerFactory TRANSFORMER_FACTORY;
    private List<PhoneBookEntry> itemsView;

    protected static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        if (DOCUMENT_BUILDER_FACTORY == null) {
            DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
        }
        return DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
    }

    protected static TransformerFactory getTransformerFactory() {
        if (TRANSFORMER_FACTORY == null) {
            TRANSFORMER_FACTORY = TransformerFactory.newInstance();
        }
        return TRANSFORMER_FACTORY;
    }

    @Override
    public PhoneBookEntry addNewEntry() {
        SingleXMLPhoneBookEntry singleXMLPhoneBookEntry = new SingleXMLPhoneBookEntry(this);
        this.addEntryGeneral(singleXMLPhoneBookEntry);
        return singleXMLPhoneBookEntry;
    }

    @Override
    public DistributionList addDistributionList() {
        if (!this.allowDistLists) {
            throw new UnsupportedOperationException("No distribution lists allowed.");
        }
        XMLDistributionList xMLDistributionList = new XMLDistributionList(this);
        this.addEntryGeneral(xMLDistributionList);
        return xMLDistributionList;
    }

    private void addEntryGeneral(XMLPhoneBookEntry xMLPhoneBookEntry) {
        this.list.add(xMLPhoneBookEntry);
        this.fireEntriesAdded(this.list.size() - 1, xMLPhoneBookEntry);
        this.wasChanged = true;
    }

    void deleteEntry(PhoneBookEntry phoneBookEntry) {
        int n = Utils.identityIndexOf(this.list, phoneBookEntry);
        if (n >= 0) {
            this.list.remove(n);
            this.fireEntriesRemoved(n, phoneBookEntry);
            this.wasChanged = true;
        }
    }

    void writeEntry(PhoneBookEntry phoneBookEntry) {
        int n = Utils.identityIndexOf(this.list, phoneBookEntry);
        this.fireEntriesChanged(n, phoneBookEntry);
        this.wasChanged = true;
    }

    @Override
    public List<PhoneBookEntry> getEntries() {
        return this.itemsView;
    }

    @Override
    public String browseForPhoneBook(boolean bl) {
        XMLSettings xMLSettings = new PBBrowser(this.settings, bl).browseForPhoneBook(this.parentDialog);
        if (xMLSettings == null) {
            return null;
        }
        return "XML:" + xMLSettings.saveToString();
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        if (this.wasChanged) {
            try {
                TransactFileOutputStream transactFileOutputStream = new TransactFileOutputStream(new File(this.settings.fileName));
                this.saveToResult(new StreamResult(transactFileOutputStream));
                ((OutputStream)transactFileOutputStream).close();
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog(this.parentDialog, Utils._("Error saving the phone book: "), exception);
            }
        }
        this.isOpened = false;
    }

    public void saveToResult(Result result) throws ParserConfigurationException, TransformerException {
        Document document = XMLPhoneBook.createDocumentBuilder().newDocument();
        Element element = document.createElement("phonebook");
        element.setAttribute("xmlns", "http://yajhfc.de/schema/phonebook");
        this.saveToXML(element, document);
        document.appendChild(element);
        element.normalize();
        TransformerFactory transformerFactory = XMLPhoneBook.getTransformerFactory();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(document);
        transformer.transform(dOMSource, result);
    }

    public void saveToXML(Element element, Document document) {
        for (XMLPhoneBookEntry xMLPhoneBookEntry : this.list) {
            String string = xMLPhoneBookEntry instanceof DistributionList ? "distributionlist" : "entry";
            Element element2 = document.createElement(string);
            xMLPhoneBookEntry.saveToXML(element2, document);
            element.appendChild(element2);
        }
        this.wasChanged = false;
    }

    public void loadFromXML(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            DefaultPhoneBookEntry defaultPhoneBookEntry;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String string = node.getNodeName();
            if (string.equals("entry")) {
                defaultPhoneBookEntry = new SingleXMLPhoneBookEntry(this);
                ((SingleXMLPhoneBookEntry)defaultPhoneBookEntry).loadFromXML((Element)node);
                this.list.add((XMLPhoneBookEntry)((Object)defaultPhoneBookEntry));
                continue;
            }
            if (string.equals("distributionlist")) {
                defaultPhoneBookEntry = new XMLDistributionList(this);
                ((XMLDistributionList)defaultPhoneBookEntry).loadFromXML((Element)node);
                this.list.add((XMLPhoneBookEntry)((Object)defaultPhoneBookEntry));
                continue;
            }
            log.warning("Unknown node: " + string);
        }
        this.firePhonebookReloaded();
        this.wasChanged = false;
    }

    @Override
    protected void openInternal(String string) throws PhoneBookException {
        this.settings = new XMLSettings();
        this.settings.loadFromString(string);
        this.reloadEntries();
        this.isOpened = true;
    }

    public void loadFromInputSource(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        this.list.clear();
        DocumentBuilder documentBuilder = XMLPhoneBook.createDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        Element element = document.getDocumentElement();
        this.loadFromXML(element);
    }

    private void reloadEntries() throws PhoneBookException {
        this.list.clear();
        File file = new File(this.settings.fileName);
        if (!file.exists()) {
            return;
        }
        try {
            this.loadFromInputSource(new InputSource(file.toURI().toString()));
        }
        catch (Exception exception) {
            throw new PhoneBookException(exception, false);
        }
    }

    public boolean wasChanged() {
        return this.wasChanged;
    }

    @Override
    public boolean isOpen() {
        return this.isOpened;
    }

    @Override
    public boolean supportsDistributionLists() {
        return this.allowDistLists;
    }

    @Override
    public String getDisplayCaption() {
        String string = this.settings.caption;
        if (string != null && string.length() > 0) {
            return string;
        }
        return Utils.shortenFileNameForDisplay(this.settings.fileName, 40);
    }

    public XMLPhoneBook(Dialog dialog, boolean bl) {
        super(dialog);
        this.allowDistLists = bl;
        this.list = new ArrayList();
        this.itemsView = Collections.unmodifiableList(this.list);
    }

    public XMLPhoneBook(Dialog dialog) {
        this(dialog, true);
    }

    static class PBBrowser
    extends SafeJFileChooser {
        private JTextField textCaption;
        private JPanel bottomPanel;
        private final boolean exportMode;

        public PBBrowser(XMLSettings xMLSettings, boolean bl) {
            this.exportMode = bl;
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            ExampleFileFilter exampleFileFilter = new ExampleFileFilter("phonebook", Utils._("Phone book files"));
            this.addChoosableFileFilter(exampleFileFilter);
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
            this.setFileFilter(exampleFileFilter);
            if (!bl) {
                this.bottomPanel = new JPanel(false);
                this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
                this.bottomPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Utils._("Phone book name to display:")), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
                this.textCaption = new JTextField();
                this.bottomPanel.add(this.textCaption);
                if (xMLSettings != null) {
                    this.setSelectedFile(new File(xMLSettings.fileName));
                    this.textCaption.setText(xMLSettings.caption);
                }
            }
        }

        protected JDialog createDialog(Component component) throws HeadlessException {
            JDialog jDialog = super.createDialog(component);
            if (!this.exportMode) {
                JPanel jPanel = new JPanel(new BorderLayout(), false);
                jPanel.add((Component)jDialog.getContentPane(), "Center");
                jPanel.add((Component)this.bottomPanel, "South");
                jDialog.setContentPane(jPanel);
            }
            return jDialog;
        }

        public XMLSettings browseForPhoneBook(Component component) {
            this.setDialogType(this.exportMode ? 1 : 0);
            if (this.showDialog(component, null) == 0) {
                XMLSettings xMLSettings = new XMLSettings();
                xMLSettings.fileName = this.getSelectedFile().getAbsolutePath();
                if (this.textCaption != null) {
                    xMLSettings.caption = this.textCaption.getText().trim();
                }
                return xMLSettings;
            }
            return null;
        }
    }
}

