/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import yajhfc.Utils;
import yajhfc.model.IconMap;
import yajhfc.plugin.PluginManager;
import yajhfc.plugin.PluginType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginTableModel
extends AbstractTableModel {
    protected static final String[] colNames = new String[]{Utils._("File name"), Utils._("Type"), Utils._("Loaded"), Utils._("Only this session")};
    protected static final Map<PluginType, PluginTypeDesc> typeDisplayMap = new EnumMap<PluginType, PluginTypeDesc>(PluginType.class);
    protected List<Entry> entries = new ArrayList<Entry>();

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Entry entry = this.entries.get(n);
        switch (n2) {
            case 0: {
                return entry;
            }
            case 1: {
                return PluginTableModel.typeDisplayMap.get((Object)((Object)entry.type)).description;
            }
            case 2: {
                return entry.loaded;
            }
            case 3: {
                return !entry.persistent;
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return IconMap.class;
            }
            case 1: {
                return String.class;
            }
            case 2: 
            case 3: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 3;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 3: {
                this.entries.get((int)n).persistent = (Boolean)object == false;
                this.fireTableRowsUpdated(n, n);
            }
        }
    }

    @Override
    public String getColumnName(int n) {
        return colNames[n];
    }

    public void addAllItems(Collection<PluginManager.PluginInfo> collection) {
        int n = this.entries.size();
        for (PluginManager.PluginInfo pluginInfo : collection) {
            this.entries.add(new Entry(pluginInfo.file, pluginInfo.type, pluginInfo.persistent, pluginInfo.loaded));
        }
        this.fireTableRowsInserted(n, this.entries.size() - 1);
    }

    public void addItem(PluginManager.PluginInfo pluginInfo) {
        this.addItem(pluginInfo.file, pluginInfo.type, pluginInfo.persistent, pluginInfo.loaded);
    }

    public void addItem(File file, PluginType pluginType) {
        this.addItem(file, pluginType, true, false);
    }

    public void addItem(File file, PluginType pluginType, boolean bl, boolean bl2) {
        this.entries.add(new Entry(file, pluginType, bl, bl2));
        int n = this.entries.size() - 1;
        this.fireTableRowsInserted(n, n);
    }

    public void removeItemAt(int n) {
        this.entries.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public Entry getEntry(int n) {
        return this.entries.get(n);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    static {
        typeDisplayMap.put(PluginType.JDBCDRIVER, new PluginTypeDesc(Utils._("JDBC driver"), Utils.loadIcon("development/Jar")));
        typeDisplayMap.put(PluginType.PLUGIN, new PluginTypeDesc(Utils._("Plugin"), Utils.loadIcon("development/J2EEApplicationClient")));
    }

    protected static class PluginTypeDesc {
        public final String description;
        public final ImageIcon icon;

        public PluginTypeDesc(String string, ImageIcon imageIcon) {
            this.description = string;
            this.icon = imageIcon;
        }
    }

    public static class Entry
    extends PluginManager.PluginInfo
    implements IconMap {
        public final ImageIcon icon;
        public final String fileName;

        public Entry(File file, PluginType pluginType, boolean bl, boolean bl2) {
            super(file, pluginType, bl);
            this.fileName = file.getAbsolutePath();
            this.icon = PluginTableModel.typeDisplayMap.get((Object)((Object)pluginType)).icon;
            this.loaded = bl2;
        }

        public String getDescription() {
            return null;
        }

        public ImageIcon getDisplayIcon() {
            return this.icon;
        }

        public String getText() {
            return this.fileName;
        }

        public String toString() {
            return this.fileName;
        }
    }
}

