/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.print;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import yajhfc.phonebook.DistributionList;
import yajhfc.phonebook.ui.PBEntryFieldTableModel;
import yajhfc.print.tableprint.HeaderPrintMode;
import yajhfc.print.tableprint.ResizeMode;
import yajhfc.print.tableprint.TableCellRenderer;
import yajhfc.print.tableprint.TablePrintColumn;
import yajhfc.print.tableprint.TablePrintable;

public class DistributionListCellRenderer
extends TablePrintable
implements TableCellRenderer {
    protected PBEntryFieldTableModel tableModel = new PBEntryFieldTableModel(null);

    public DistributionListCellRenderer() {
        super(null);
        this.setModel(this.tableModel);
        this.setHeaderPrintMode(HeaderPrintMode.PRINT_ON_FIRST_PAGE);
        this.setResizeMode(ResizeMode.RESIZE_GROW_AND_SHRINK);
    }

    public double drawCell(Graphics2D graphics2D, double d, double d2, Object object, TablePrintColumn tablePrintColumn, Color color, double d3, double d4, double d5, boolean bl, TableCellRenderer.ColumnPageData columnPageData) {
        if (bl) {
            if (columnPageData.remainingData == null) {
                return Double.MIN_VALUE;
            }
            this.readPageData((PageData)columnPageData.remainingData);
        } else {
            this.currentRow = 0;
            this.currentPage = 0;
            this.lastStartRow = 0;
            columnPageData.clear();
        }
        DistributionList distributionList = (DistributionList)object;
        this.tableModel.setList(Collections.unmodifiableList(distributionList.getEntries()));
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, tablePrintColumn.getEffectiveColumnWidth(), d5 - d2);
        Shape shape = graphics2D.getClip();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.clip(double_);
        double d6 = this.drawTable(graphics2D, double_, this.currentPage);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
        if (d6 <= 0.0) {
            ++this.currentPage;
            columnPageData.remainingData = this.createPageData();
        }
        return d6;
    }

    protected void readPageData(PageData pageData) {
        this.currentRow = pageData.currentRow;
        this.currentPage = pageData.currentPage;
        this.lastStartRow = pageData.lastStartRow;
        this.pageData.clear();
        this.pageData.addAll(pageData.pageData);
    }

    protected PageData createPageData() {
        PageData pageData = new PageData();
        pageData.currentRow = this.currentRow;
        pageData.currentPage = this.currentPage;
        pageData.lastStartRow = this.lastStartRow;
        pageData.pageData = new ArrayList<TableCellRenderer.ColumnPageData[]>(this.pageData);
        return pageData;
    }

    public double getPreferredWidth(Graphics2D graphics2D, Object object, FontMetrics fontMetrics, Format format, TablePrintColumn tablePrintColumn) {
        throw new UnsupportedOperationException();
    }

    protected static class PageData {
        public int currentRow;
        public int lastStartRow;
        public int currentPage;
        public List<TableCellRenderer.ColumnPageData[]> pageData;

        protected PageData() {
        }
    }
}

