/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.ui.PBEntryFieldTableModel;
import yajhfc.print.tableprint.Alignment;
import yajhfc.print.tableprint.TablePrintable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPhonebookPrintable
extends TablePrintable {
    protected int pbNumber;
    protected int pageOffset;
    protected PhoneBook[] phoneBooks;
    protected PBEntryFieldTableModel model;
    protected int lastPageIndex = -1;

    public MultiPhonebookPrintable(PhoneBook[] phoneBookArray) {
        super(null);
        this.phoneBooks = phoneBookArray;
        this.model = new PBEntryFieldTableModel(null);
        this.setModel(this.model);
    }

    @Override
    protected double drawHeaderOrFooter(Graphics2D graphics2D, Map<Alignment, MessageFormat> map, Rectangle2D rectangle2D, int n, boolean bl) {
        return super.drawHeaderOrFooter(graphics2D, map, rectangle2D, n + this.pageOffset, bl);
    }

    private void setNewPhonebook() {
        this.model.setList(Collections.unmodifiableList(this.phoneBooks[this.pbNumber].getEntries()));
        this.pageHeader.put(Alignment.CENTER, new MessageFormat("'" + this.phoneBooks[this.pbNumber] + "'"));
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n == 0 && this.lastPageIndex != 0) {
            this.pbNumber = 0;
            this.pageOffset = 0;
            this.setNewPhonebook();
        }
        this.lastPageIndex = n;
        AffineTransform affineTransform = ((Graphics2D)graphics).getTransform();
        int n2 = super.print(graphics, pageFormat, n - this.pageOffset);
        if (n2 == 0) {
            return 0;
        }
        ++this.pbNumber;
        if (this.pbNumber >= this.phoneBooks.length) {
            return 1;
        }
        ((Graphics2D)graphics).setTransform(affineTransform);
        this.pageOffset = n;
        this.setNewPhonebook();
        graphics.clearRect(0, 0, (int)Math.ceil(pageFormat.getWidth()), (int)Math.ceil(pageFormat.getHeight()));
        return this.print(graphics, pageFormat, n);
    }
}

