/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.print;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import yajhfc.FaxOptions;
import yajhfc.Utils;
import yajhfc.phonebook.DistributionList;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.convrules.PBEntryFieldContainer;
import yajhfc.phonebook.ui.PBEntryFieldTableModel;
import yajhfc.print.DistributionListCellRenderer;
import yajhfc.print.MultiPhonebookPrintable;
import yajhfc.print.PhoneBookColumnLayout;
import yajhfc.print.StatusDialogPrintable;
import yajhfc.print.tableprint.Alignment;
import yajhfc.print.tableprint.TablePrintColumn;
import yajhfc.print.tableprint.TablePrintable;
import yajhfc.util.CancelAction;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.SelectionTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhonebooksPrinter
extends JDialog {
    private static final int border = 6;
    Action okAction;
    SelectionTableModel<PhoneBook> pbModel;
    SelectionTableModel<PBEntryField> colsModel;
    JRadioButton radAll;
    JRadioButton radSelItems;
    JRadioButton radUserSel;
    boolean modalResult = false;

    public PhonebooksPrinter(Dialog dialog, List<PhoneBook> list, PhoneBook phoneBook, boolean bl) {
        super(dialog, Utils._("Print phone books"), true);
        this.initialize(list, phoneBook, bl);
    }

    private void initialize(List<PhoneBook> list, PhoneBook phoneBook, boolean bl) {
        this.okAction = new ExcDialogAbstractAction(Utils._("Print")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                if (PhonebooksPrinter.this.radUserSel.isSelected() && PhonebooksPrinter.this.pbModel.countNumberOfSelectedItems() == 0 || PhonebooksPrinter.this.colsModel.countNumberOfSelectedItems() == 0) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                PhonebooksPrinter.this.modalResult = true;
                PhonebooksPrinter.this.dispose();
            }
        };
        CancelAction cancelAction = new CancelAction(this);
        FaxOptions faxOptions = Utils.getFaxOptions();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new TableLayout(new double[][]{{6.0, -1.0, -2.0, 6.0, -2.0, -1.0, 6.0}, {6.0, -2.0, 3.0, -2.0, 3.0, -2.0, -1.0, 3.0, -2.0, 3.0, -2.0, 6.0}}));
        this.radAll = new JRadioButton(Utils._("All phone books"));
        this.radSelItems = new JRadioButton(Utils._("Selected phone book entries"));
        this.radSelItems.setEnabled(bl);
        this.radUserSel = new JRadioButton(Utils._("Only the following phone book(s):"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radAll);
        buttonGroup.add(this.radSelItems);
        buttonGroup.add(this.radUserSel);
        this.pbModel = new SelectionTableModel<PhoneBook>(list.toArray(new PhoneBook[list.size()]));
        if (bl) {
            this.radSelItems.setSelected(true);
            this.pbModel.selectAll(true);
        } else if (phoneBook != null) {
            this.radUserSel.setSelected(true);
            this.pbModel.setSelectedObjects(Collections.singleton(phoneBook));
        } else {
            this.radAll.setSelected(true);
            this.pbModel.selectAll(true);
        }
        this.colsModel = new SelectionTableModel<PBEntryField>(PBEntryField.values());
        if (faxOptions.pbprintPrintColumns.size() == 0) {
            this.colsModel.selectAll(true);
        } else {
            this.colsModel.setSelectedObjects(faxOptions.pbprintPrintColumns);
        }
        JTable jTable = this.createSelectionTable(this.pbModel);
        this.pbModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                PhonebooksPrinter.this.radUserSel.setSelected(true);
                PhonebooksPrinter.this.checkEnabled();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.getViewport().setBackground(jTable.getBackground());
        jScrollPane.getViewport().setOpaque(true);
        JTable jTable2 = this.createSelectionTable(this.colsModel);
        this.colsModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                PhonebooksPrinter.this.checkEnabled();
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(jTable2);
        jScrollPane2.getViewport().setBackground(jTable2.getBackground());
        jScrollPane2.getViewport().setOpaque(true);
        jPanel.add((Component)this.radAll, "1,1,2,1");
        jPanel.add((Component)this.radSelItems, "1,3,2,3");
        jPanel.add((Component)this.radUserSel, "1,5,2,5");
        jPanel.add((Component)jScrollPane, "1,6,2,6");
        jPanel.add((Component)new JLabel(Utils._("Columns to print:")), "4,1,5,1");
        jPanel.add((Component)jScrollPane2, "4,2,5,6");
        jPanel.add((Component)new JSeparator(), "0,8,6,8");
        jPanel.add((Component)new JButton(this.okAction), "2,10");
        jPanel.add((Component)cancelAction.createCancelButton(), "4,10");
        this.setContentPane(jPanel);
        this.setDefaultCloseOperation(2);
        this.setSize(640, 480);
        Utils.setDefWinPos(this);
    }

    private JTable createSelectionTable(SelectionTableModel<?> selectionTableModel) {
        JTable jTable = new JTable(selectionTableModel);
        jTable.setSelectionMode(0);
        jTable.setShowGrid(false);
        jTable.setRowSelectionAllowed(true);
        jTable.setTableHeader(null);
        jTable.getColumnModel().getColumn(0).setMaxWidth(15);
        return jTable;
    }

    void checkEnabled() {
        boolean bl = (!this.radUserSel.isSelected() || this.pbModel.countNumberOfSelectedItems() > 0) && this.colsModel.countNumberOfSelectedItems() > 0;
        this.okAction.setEnabled(bl);
    }

    public static TablePrintable getPhonebooksTablePrintable(Dialog dialog, List<PhoneBook> list, PhoneBook phoneBook, List<PhoneBookEntry> list2, boolean bl) {
        TablePrintable tablePrintable;
        PhonebooksPrinter phonebooksPrinter = new PhonebooksPrinter(dialog, list, phoneBook, list2 != null && list2.size() > 1);
        phonebooksPrinter.setVisible(true);
        if (!phonebooksPrinter.modalResult) {
            return null;
        }
        PBEntryField[] pBEntryFieldArray = phonebooksPrinter.colsModel.getSelectedObjects();
        FaxOptions faxOptions = Utils.getFaxOptions();
        faxOptions.pbprintPrintColumns.clear();
        faxOptions.pbprintPrintColumns.addAll(Arrays.asList(pBEntryFieldArray));
        if (phonebooksPrinter.radAll.isSelected()) {
            tablePrintable = new MultiPhonebookPrintable(list.toArray(new PhoneBook[list.size()]));
        } else if (phonebooksPrinter.radSelItems.isSelected()) {
            tablePrintable = new TablePrintable(new PBEntryFieldTableModel(new ArrayList<PBEntryFieldContainer>(list2)));
            tablePrintable.getPageHeader().put(Alignment.CENTER, new MessageFormat("'" + Utils._("Selected phone book entries") + "'"));
        } else {
            tablePrintable = new MultiPhonebookPrintable(phonebooksPrinter.pbModel.getSelectedObjects());
        }
        PhonebooksPrinter.setColumnLayout(pBEntryFieldArray, tablePrintable);
        DistributionListCellRenderer distributionListCellRenderer = new DistributionListCellRenderer();
        PhonebooksPrinter.setColumnLayout(pBEntryFieldArray, distributionListCellRenderer);
        distributionListCellRenderer.setHeaderFont(tablePrintable.getHeaderFont().deriveFont(2));
        tablePrintable.getRendererMap().put(DistributionList.class, distributionListCellRenderer);
        return tablePrintable;
    }

    public static void printPhonebooks(Dialog dialog, List<PhoneBook> list, PhoneBook phoneBook, List<PhoneBookEntry> list2, boolean bl) {
        TablePrintable tablePrintable = PhonebooksPrinter.getPhonebooksTablePrintable(dialog, list, phoneBook, list2, bl);
        if (tablePrintable == null) {
            return;
        }
        try {
            FaxOptions faxOptions = Utils.getFaxOptions();
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            if (faxOptions.printAttributes == null) {
                hashPrintRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
            } else {
                for (Attribute attribute : faxOptions.printAttributes) {
                    hashPrintRequestAttributeSet.add(attribute);
                }
            }
            if (StatusDialogPrintable.printWithDialog(dialog, tablePrintable, hashPrintRequestAttributeSet)) {
                faxOptions.printAttributes = hashPrintRequestAttributeSet.toArray();
            }
        }
        catch (PrinterException printerException) {
            ExceptionDialog.showExceptionDialog(dialog, Utils._("Error printing the table:"), printerException);
        }
    }

    private static void setColumnLayout(PBEntryField[] pBEntryFieldArray, TablePrintable tablePrintable) {
        PhoneBookColumnLayout phoneBookColumnLayout = new PhoneBookColumnLayout();
        phoneBookColumnLayout.setMinFillColsWidth(100.0);
        phoneBookColumnLayout.applyFilter(pBEntryFieldArray);
        tablePrintable.setColumnLayout(phoneBookColumnLayout);
        TablePrintColumn tablePrintColumn = phoneBookColumnLayout.getDistListColumn(true);
        tablePrintColumn.setFont(tablePrintable.getTableFont().deriveFont(2));
        tablePrintColumn.setBackgroundColor(tablePrintable.getHeaderBackground());
        TablePrintColumn tablePrintColumn2 = phoneBookColumnLayout.getColumnFor(PBEntryField.Comment);
        tablePrintColumn2.setWordWrap(true);
        tablePrintColumn2.setWidth(-2.0f);
        tablePrintColumn2.setFont(new Font("Monospaced", 0, 12));
    }
}

