/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.print.tableprint;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.text.FieldPosition;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import yajhfc.Utils;
import yajhfc.print.tableprint.Alignment;
import yajhfc.print.tableprint.TableCellRenderer;
import yajhfc.print.tableprint.TablePrintColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCellRenderer
implements TableCellRenderer {
    private StringBuffer sbuf = new StringBuffer();
    private FieldPosition fpos = new FieldPosition(0);

    protected String valueToString(Format format, Object object) {
        if (object == null) {
            return "";
        }
        if (format != null) {
            this.sbuf.setLength(0);
            format.format(object, this.sbuf, this.fpos);
            return this.sbuf.toString();
        }
        return object.toString();
    }

    protected Format getFormat(TablePrintColumn tablePrintColumn) {
        return tablePrintColumn.getEffectiveFormat();
    }

    protected Alignment getAlignment(TablePrintColumn tablePrintColumn) {
        return tablePrintColumn.getAlignment();
    }

    protected int wordWrapText(List<String> list, List<Rectangle2D> list2, int n, Graphics2D graphics2D, double d, FontMetrics fontMetrics) {
        int n2 = -1;
        String string = list.get(n);
        String string2 = null;
        Rectangle2D rectangle2D = null;
        do {
            String string3;
            Rectangle2D rectangle2D2;
            if ((rectangle2D2 = fontMetrics.getStringBounds(string3 = (n2 = string.indexOf(32, n2 + 1)) < 0 ? string : string.substring(0, n2), graphics2D)).getWidth() > d && string2 != null) {
                list.set(n, string2);
                list2.set(n, rectangle2D);
                list.add(++n, null);
                list2.add(n, null);
                string = string.substring(string2.length() + 1);
                string2 = null;
                rectangle2D = null;
                n2 = 0;
                continue;
            }
            string2 = string3;
            rectangle2D = rectangle2D2;
        } while (n2 >= 0);
        list.set(n, string);
        list2.set(n, fontMetrics.getStringBounds(string, graphics2D));
        return n;
    }

    @Override
    public double drawCell(Graphics2D graphics2D, double d, double d2, Object object, TablePrintColumn tablePrintColumn, Color color, double d3, double d4, double d5, boolean bl, TableCellRenderer.ColumnPageData columnPageData) {
        double d6;
        Object object2;
        List<String> list;
        if (bl) {
            if (columnPageData.remainingData == null) {
                return Double.MIN_VALUE;
            }
            list = (List<String>)columnPageData.remainingData;
        } else {
            object2 = this.valueToString(this.getFormat(tablePrintColumn), object);
            list = object2 == null || ((String)object2).equals("") ? Collections.singletonList(" ") : Utils.fastSplitToList((String)object2, '\n');
        }
        object2 = graphics2D.getFontMetrics();
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Rectangle2D rectangle2D = ((FontMetrics)object2).getStringBounds(list.get(i), graphics2D);
            arrayList.add(rectangle2D);
            if (!this.isWordWrap(tablePrintColumn) || !(rectangle2D.getWidth() > tablePrintColumn.getEffectiveColumnWidth() - 2.0 * d3)) continue;
            i = this.wordWrapText(list, arrayList, i, graphics2D, tablePrintColumn.getEffectiveColumnWidth() - 2.0 * d3, (FontMetrics)object2);
        }
        double d7 = 2.0 * d4;
        int n = 0;
        boolean bl2 = false;
        for (Rectangle2D rectangle2D : arrayList) {
            if (d2 + d7 + rectangle2D.getHeight() > d5) {
                bl2 = true;
                break;
            }
            d7 += rectangle2D.getHeight();
            ++n;
        }
        int n2 = list.size();
        if (bl2) {
            if (n < 1) {
                if (columnPageData != null) {
                    columnPageData.remainingData = list;
                }
                return 0.0;
            }
            if (columnPageData != null) {
                columnPageData.remainingData = list.subList(n, list.size());
            }
            n2 = n;
            d6 = -d7;
        } else {
            if (columnPageData != null) {
                columnPageData.remainingData = null;
            }
            d6 = d7;
        }
        Shape shape = graphics2D.getClip();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, tablePrintColumn.getEffectiveColumnWidth(), d7);
        graphics2D.clip(double_);
        if (color != null) {
            Color color2 = graphics2D.getColor();
            graphics2D.setColor(color);
            graphics2D.fill(double_);
            graphics2D.setColor(color2);
        }
        d2 += d4 + (double)((FontMetrics)object2).getAscent();
        for (int i = 0; i < n2; ++i) {
            Rectangle2D rectangle2D = (Rectangle2D)arrayList.get(i);
            graphics2D.drawString(list.get(i), (float)this.getAlignment(tablePrintColumn).calculateX(d, rectangle2D.getWidth(), tablePrintColumn.getEffectiveColumnWidth(), d3), (float)d2);
            d2 += rectangle2D.getHeight();
        }
        graphics2D.setClip(shape);
        return d6;
    }

    protected boolean isWordWrap(TablePrintColumn tablePrintColumn) {
        return tablePrintColumn.isWordWrap();
    }

    @Override
    public double getPreferredWidth(Graphics2D graphics2D, Object object, FontMetrics fontMetrics, Format format, TablePrintColumn tablePrintColumn) {
        String[] stringArray = Utils.fastSplit(this.valueToString(format, object), '\n');
        double d = 0.0;
        for (String string : stringArray) {
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
            if (!(rectangle2D.getWidth() > d)) continue;
            d = rectangle2D.getWidth();
        }
        return d;
    }
}

