/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.print.tableprint;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.Format;
import javax.swing.ImageIcon;
import yajhfc.model.IconMap;
import yajhfc.print.tableprint.TableCellRenderer;
import yajhfc.print.tableprint.TablePrintColumn;

public class IconMapCellRenderer
implements TableCellRenderer {
    private static final double ICON_SPACING = 0.25;

    public double drawCell(Graphics2D graphics2D, double d, double d2, Object object, TablePrintColumn tablePrintColumn, Color color, double d3, double d4, double d5, boolean bl, TableCellRenderer.ColumnPageData columnPageData) {
        Serializable serializable;
        if (bl) {
            return Double.MIN_VALUE;
        }
        IconMap iconMap = (IconMap)object;
        String string = iconMap.getText();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        double d6 = rectangle2D.getHeight() + 2.0 * d4;
        if (d2 + d6 > d5) {
            return 0.0;
        }
        Shape shape = graphics2D.getClip();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, tablePrintColumn.getEffectiveColumnWidth(), d6);
        graphics2D.clip(double_);
        if (color != null) {
            serializable = graphics2D.getColor();
            graphics2D.setColor(color);
            graphics2D.fill(double_);
            graphics2D.setColor((Color)serializable);
        }
        serializable = iconMap.getDisplayIcon();
        double d7 = rectangle2D.getHeight() / (double)((ImageIcon)serializable).getIconHeight();
        double d8 = (double)((ImageIcon)serializable).getIconWidth() * d7;
        double d9 = rectangle2D.getWidth() + d8 + (double)fontMetrics.getHeight() * 0.25;
        double d10 = tablePrintColumn.getAlignment().calculateX(d, d9, tablePrintColumn.getEffectiveColumnWidth(), d3);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d10, d2 + d4);
        affineTransform.scale(d7, d7);
        graphics2D.drawImage(((ImageIcon)serializable).getImage(), affineTransform, null);
        graphics2D.drawString(string, (float)(d10 + d8 + (double)fontMetrics.getHeight() * 0.25), (float)(d2 + d4 + (double)fontMetrics.getAscent()));
        graphics2D.setClip(shape);
        return d6;
    }

    public double getPreferredWidth(Graphics2D graphics2D, Object object, FontMetrics fontMetrics, Format format, TablePrintColumn tablePrintColumn) {
        IconMap iconMap = (IconMap)object;
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(iconMap.getText(), graphics2D);
        double d = rectangle2D.getHeight() / (double)iconMap.getDisplayIcon().getIconHeight();
        return rectangle2D.getWidth() + (double)fontMetrics.getHeight() * 0.25 + (double)iconMap.getDisplayIcon().getIconWidth() * d;
    }
}

