/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.printerport;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.options.PanelTreeNode;
import yajhfc.plugin.PluginManager;
import yajhfc.plugin.PluginUI;
import yajhfc.printerport.FIFOThread;
import yajhfc.printerport.ListenThread;
import yajhfc.printerport.PortOptions;
import yajhfc.printerport.PortOptionsPanel;

public final class EntryPoint {
    static final Logger log = Logger.getLogger(EntryPoint.class.getName());
    private static PortOptions options;
    public static ListenThread TCP_THREAD;
    public static FIFOThread FIFO_THREAD;

    public static PortOptions getOptions() {
        if (options == null) {
            options = new PortOptions();
            options.loadFromProperties(Utils.getSettingsProperties());
        }
        return options;
    }

    public static boolean init(int n) {
        if (n != 0) {
            log.fine("Not loading for startup mode " + n);
            return true;
        }
        PluginManager.pluginUIs.add(new PluginUI(){

            public int getOptionsPanelParent() {
                return 1;
            }

            public PanelTreeNode createOptionsPanel(PanelTreeNode panelTreeNode) {
                return new PanelTreeNode(panelTreeNode, new PortOptionsPanel(), Utils._("Printer port"), Utils.loadCustomIcon("printerport-icon.gif"));
            }

            public void saveOptions(Properties properties) {
                EntryPoint.getOptions().storeToProperties(properties);
            }
        });
        EntryPoint.reopenTCPThread();
        EntryPoint.reopenFIFOThread();
        return true;
    }

    public static void reopenTCPThread() {
        if (TCP_THREAD != null) {
            TCP_THREAD.close();
            TCP_THREAD = null;
        }
        PortOptions portOptions = EntryPoint.getOptions();
        if (portOptions.enabled) {
            try {
                TCP_THREAD = new ListenThread(portOptions.bindAddress, portOptions.port);
                TCP_THREAD.start();
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Error creating server socket:", exception);
            }
        }
    }

    public static void reopenFIFOThread() {
        if (FIFO_THREAD != null) {
            FIFO_THREAD.close();
            FIFO_THREAD = null;
        }
        PortOptions portOptions = EntryPoint.getOptions();
        if (portOptions.enableFIFO) {
            String string = portOptions.fifoName.replace("%u", System.getProperty("user.name"));
            FIFO_THREAD = new FIFOThread(string);
            FIFO_THREAD.start();
        }
    }
}

