/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.printerport;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.PlatformInfo;
import yajhfc.printerport.UnixFIFO;

public abstract class FIFO {
    public static Class<? extends FIFO> FIFO_IMPLEMENTATION;
    protected String fifoName;

    public static FIFO createFIFO(String string) throws IOException {
        if (FIFO_IMPLEMENTATION == null) {
            throw new IOException("No FIFO implementation for this platform available");
        }
        try {
            Constructor<? extends FIFO> constructor = FIFO_IMPLEMENTATION.getConstructor(String.class);
            return constructor.newInstance(string);
        }
        catch (Exception exception) {
            throw (IOException)new IOException("Error creating the FIFO").initCause(exception);
        }
    }

    protected FIFO(String string) {
        this.fifoName = string;
    }

    public abstract InputStream openInputStream() throws IOException;

    public abstract void close();

    public String getFIFOName() {
        return this.fifoName;
    }

    public String toString() {
        return this.getFIFOName();
    }

    static {
        if (!PlatformInfo.IS_WINDOWS) {
            FIFO_IMPLEMENTATION = UnixFIFO.class;
        } else {
            try {
                Class<?> clazz = Class.forName("yajhfc.printerport.win32.Win32FIFO");
                Method method = clazz.getMethod("isAvailable", new Class[0]);
                if (((Boolean)method.invoke(null, new Object[0])).booleanValue()) {
                    FIFO_IMPLEMENTATION = clazz;
                }
            }
            catch (Exception exception) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Could not call yajhfc.printerport.win32.Win32FIFO.isAvailable()");
            }
        }
    }
}

