/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.printerport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.launch.SendWinSubmitProtocol;

public class ListenThread
extends Thread {
    private static final Logger log = Logger.getLogger(ListenThread.class.getName());
    protected final ServerSocket printerSock;

    public ListenThread(String string, int n) throws UnknownHostException, IOException {
        super("PrinterPort-" + string);
        this.printerSock = new ServerSocket(n, 0, string == null || string.length() == 0 ? null : InetAddress.getByName(string));
        this.setDaemon(true);
    }

    public void close() {
        try {
            this.printerSock.close();
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, "Error closing socket:", iOException);
        }
    }

    public void run() {
        block9: {
            block7: while (true) {
                try {
                    while (!this.isInterrupted()) {
                        Socket socket = this.printerSock.accept();
                        try {
                            this.submitFax(socket);
                            socket.close();
                            continue block7;
                        }
                        catch (Exception exception) {
                            log.log(Level.WARNING, "Error accepting a connection:", exception);
                        }
                    }
                    break block9;
                }
                catch (IOException iOException) {
                    log.log(Level.WARNING, "Error accepting a connection:", iOException);
                    break block9;
                }
            }
            finally {
                this.close();
            }
        }
    }

    protected void submitFax(Socket socket) throws IOException {
        SendWinSubmitProtocol sendWinSubmitProtocol = new SendWinSubmitProtocol();
        sendWinSubmitProtocol.setInputStream(socket.getInputStream(), this.getPrinterSockText());
        sendWinSubmitProtocol.submit(true);
    }

    protected String getPrinterSockText() {
        return "[" + this.printerSock.getInetAddress().toString() + ':' + this.printerSock.getLocalPort() + ']';
    }
}

