/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.printerport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Logger;
import yajhfc.printerport.EntryPoint;
import yajhfc.printerport.FIFO;
import yajhfc.shutdown.ShutdownManager;
import yajhfc.util.ExternalProcessExecutor;

public class UnixFIFO
extends FIFO {
    private static final Logger log = Logger.getLogger(UnixFIFO.class.getName());
    protected File fifo;

    public UnixFIFO(String string) throws IOException, InterruptedException {
        super(string);
        this.createUnixFIFO(string);
    }

    private void createUnixFIFO(String string) throws IOException, InterruptedException {
        String string2;
        this.fifo = new File(string);
        String string3 = EntryPoint.getOptions().mkfifo;
        if (this.fifo.exists()) {
            this.fifo.delete();
        }
        log.fine("Executing \"" + string3 + " " + this.fifo + "\".");
        List<String> list = ExternalProcessExecutor.splitCommandLine(string3);
        list.add(this.fifo.getPath());
        ExternalProcessExecutor.quoteCommandLine(list);
        Process process = new ProcessBuilder(list).redirectErrorStream(true).start();
        process.getOutputStream().close();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((string2 = bufferedReader.readLine()) != null) {
            log.info(string3 + " output: " + string2);
        }
        bufferedReader.close();
        int n = process.waitFor();
        if (n != 0) {
            throw new IOException(string3 + " failed with exit code " + n);
        }
        log.fine("FIFO created successfully.");
        ShutdownManager.deleteOnExit(this.fifo);
    }

    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.fifo);
    }

    public void close() {
        this.fifo.delete();
    }
}

