/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.printerport.win32;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.PlatformInfo;
import yajhfc.printerport.FIFO;
import yajhfc.util.pipe.win32.Win32NamedPipeInputStream;

public class Win32FIFO
extends FIFO {
    public Win32FIFO(String string) throws IOException {
        super(Win32FIFO.translateFIFOName(string));
    }

    private static String translateFIFOName(String string) throws IOException {
        if (!PlatformInfo.IS_WINDOWS) {
            throw new IOException("This class only supports Windows!");
        }
        if (string.startsWith("\\\\.\\pipe\\")) {
            return string;
        }
        if (string.indexOf(47) >= 0 || string.indexOf(92) >= 0) {
            throw new IOException("Invalid FIFO name " + string + ". It must either be just a file name without path or start with " + "\\\\.\\pipe\\");
        }
        return "\\\\.\\pipe\\" + string;
    }

    public InputStream openInputStream() throws IOException {
        return new Win32NamedPipeInputStream(this.fifoName);
    }

    public void close() {
    }

    public static boolean isAvailable() {
        if (!PlatformInfo.IS_WINDOWS) {
            return false;
        }
        try {
            Class.forName("com.sun.jna.Native");
            Class.forName("com.sun.jna.platform.win32.WinNT");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(Win32FIFO.class.getName()).log(Level.INFO, "JNA not found, Win32 named pipe printer port will not be available", classNotFoundException);
            return false;
        }
    }
}

