/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.report;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import yajhfc.PaperSize;
import yajhfc.file.FileConverter;
import yajhfc.file.FileFormat;
import yajhfc.file.FormattedFile;
import yajhfc.file.GhostScriptMultiFileConverter;
import yajhfc.file.UnknownFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fax2ImageConverter {
    private static final String FILENAME_PATTERN = "page%d.png";
    protected File tempDir = null;
    protected List<File> pngFiles = null;
    protected BufferedImage[] images = null;
    protected PaperSize paperSize = PaperSize.A4;
    protected String gsDevice;

    public Fax2ImageConverter() {
        this("pngmono");
    }

    public Fax2ImageConverter(String string) {
        this.gsDevice = string;
    }

    public void readFiles(List<FormattedFile> list, int n, int n2) throws IOException, UnknownFormatException, FileConverter.ConversionException {
        File file;
        this.close();
        this.tempDir = File.createTempFile("report", ".dir");
        this.tempDir.delete();
        this.tempDir.mkdir();
        PNGMultiFileConverter pNGMultiFileConverter = new PNGMultiFileConverter(this.gsDevice);
        pNGMultiFileConverter.convertMultipleFiles(list, new File(this.tempDir, FILENAME_PATTERN), this.paperSize);
        this.pngFiles = new ArrayList<File>();
        for (int i = 1; (file = new File(this.tempDir, String.format(FILENAME_PATTERN, i))).exists() && (n2 < 0 || i <= n2 + 1); ++i) {
            if (i < n + 1) continue;
            this.pngFiles.add(file);
        }
        this.images = new BufferedImage[this.pngFiles.size()];
    }

    public int getNumberOfPages() {
        return this.images.length;
    }

    public void close() {
        if (this.pngFiles != null) {
            this.images = null;
            this.pngFiles = null;
            Fax2ImageConverter.deleteTree(this.tempDir);
            this.tempDir = null;
        }
    }

    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize;
    }

    public String getGsDevice() {
        return this.gsDevice;
    }

    public void setGsDevice(String string) {
        this.gsDevice = string;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public BufferedImage getImage(int n) throws IOException {
        BufferedImage bufferedImage = this.images[n];
        if (bufferedImage == null) {
            File file = this.pngFiles.get(n);
            this.images[n] = ImageIO.read(file);
            return this.images[n];
        }
        return bufferedImage;
    }

    private static void deleteTree(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                Fax2ImageConverter.deleteTree(file2);
            }
        }
        file.delete();
    }

    protected static class PNGMultiFileConverter
    extends GhostScriptMultiFileConverter {
        protected final String device;

        public PNGMultiFileConverter(String string) {
            this.device = string;
        }

        public FileFormat getTargetFormat() {
            return FileFormat.PNG;
        }

        protected String[] getAdditionalGSParams() {
            return NO_ADDITIONAL_PARAMETERS;
        }

        protected String getGSDevice() {
            return this.device;
        }
    }
}

