/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.report;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.FmtItemList;
import yajhfc.model.TableType;
import yajhfc.report.EntryPoint;
import yajhfc.report.ReportOptions;
import yajhfc.report.SendReport;
import yajhfc.util.CancelAction;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.IntVerifier;
import yajhfc.util.SelectionTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendReportDialog<T extends FmtItem>
extends JDialog {
    static final Logger log = Logger.getLogger(SendReportDialog.class.getName());
    JTextField textPageFrom;
    JTextField textPageTo;
    JTextField textThumbnailsPerPage;
    JRadioButton radAllPages;
    JRadioButton radSelectedPages;
    JRadioButton radUnlimitedThumbs;
    JRadioButton radLimitThumbs;
    SelectionTableModel<T> colsModel;
    FmtItemList<T> columns;
    TableType tableType;
    public boolean modalResult = false;

    public SendReportDialog(Frame frame, FmtItemList<T> fmtItemList, TableType tableType) {
        super(frame, true);
        this.columns = fmtItemList;
        this.tableType = tableType;
        this.initialize();
    }

    public SendReportDialog(Dialog dialog, FmtItemList<T> fmtItemList, TableType tableType) {
        super(dialog, true);
        this.columns = fmtItemList;
        this.tableType = tableType;
        this.initialize();
    }

    private void initialize() {
        DocumentListener documentListener = new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                SendReportDialog.this.radSelectedPages.setSelected(true);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                SendReportDialog.this.radSelectedPages.setSelected(true);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.textPageTo = new JTextField(4);
        this.textPageTo.setInputVerifier(new IntVerifier(1, 9999));
        this.textPageTo.getDocument().addDocumentListener(documentListener);
        this.textPageFrom = new JTextField(4);
        this.textPageFrom.setInputVerifier(new IntVerifier(1, 9999));
        this.textPageFrom.getDocument().addDocumentListener(documentListener);
        this.textThumbnailsPerPage = new JTextField(4);
        this.textThumbnailsPerPage.setInputVerifier(new IntVerifier(1, 9999));
        this.textThumbnailsPerPage.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                SendReportDialog.this.radLimitThumbs.setSelected(true);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                SendReportDialog.this.radLimitThumbs.setSelected(true);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.radAllPages = new JRadioButton(Utils._("All pages"));
        this.radSelectedPages = new JRadioButton(Utils._("Only for the following pages:"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radAllPages);
        buttonGroup.add(this.radSelectedPages);
        this.radUnlimitedThumbs = new JRadioButton(Utils._("Unlimited (put all on one page)"));
        this.radLimitThumbs = new JRadioButton(Utils._("At most:"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.radUnlimitedThumbs);
        buttonGroup2.add(this.radLimitThumbs);
        FmtItem[] fmtItemArray = this.columns.getAvailableKeys();
        this.colsModel = new SelectionTableModel<FmtItem>(fmtItemArray);
        JTable jTable = this.createSelectionTable(this.colsModel);
        jTable.setDefaultRenderer(fmtItemArray.getClass().getComponentType(), new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string;
                if (object != null) {
                    FmtItem fmtItem = (FmtItem)object;
                    string = fmtItem.getDescription();
                } else {
                    string = "";
                }
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.getViewport().setBackground(jTable.getBackground());
        jScrollPane.getViewport().setOpaque(true);
        ExcDialogAbstractAction excDialogAbstractAction = new ExcDialogAbstractAction(Utils._("OK")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                if (SendReportDialog.this.validateInput()) {
                    SendReportDialog.this.modalResult = true;
                    SendReportDialog.this.setVisible(false);
                }
            }
        };
        CancelAction cancelAction = new CancelAction(this);
        double[][] dArrayArray = new double[][]{{5.0, -2.0, 2.0, -1.0, 5.0}, {5.0, -2.0, 5.0, -2.0, -2.0, -1.0, 5.0}};
        JPanel jPanel = new JPanel(new TableLayout(dArrayArray), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(Utils._("Number of thumbnails per page")));
        jPanel.add((Component)this.radUnlimitedThumbs, "1,1,3,1,l,c");
        jPanel.add((Component)this.radLimitThumbs, "1,3,l,c");
        jPanel.add((Component)this.textThumbnailsPerPage, "1,4,f,f");
        jPanel.add((Component)new JLabel(Utils._("thumbnails per page")), "3,4,l,c");
        dArrayArray = new double[][]{{5.0, -2.0, -2.0, -1.0, 5.0}, {5.0, -2.0, 5.0, -2.0, -2.0, -1.0, 5.0}};
        JPanel jPanel2 = new JPanel(new TableLayout(dArrayArray), false);
        jPanel2.setBorder(BorderFactory.createTitledBorder(Utils._("Fax pages to print thumbnails for")));
        jPanel2.add((Component)this.radAllPages, "1,1,3,1,l,c");
        jPanel2.add((Component)this.radSelectedPages, "1,3,,3,3,l,c");
        jPanel2.add((Component)this.textPageFrom, "1,4,f,f");
        jPanel2.add((Component)new JLabel(Utils._(" to ")), "2,4,f,f");
        jPanel2.add((Component)this.textPageTo, "3,4,l,f");
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(new JButton(excDialogAbstractAction));
        jPanel3.add(cancelAction.createCancelButton());
        dArrayArray = new double[][]{{5.0, -1.0, 5.0, 0.5, 5.0}, {5.0, -2.0, -2.0, 5.0, -2.0, 5.0, -1.0, 5.0, -2.0, 5.0}};
        JPanel jPanel4 = new JPanel(new TableLayout(dArrayArray));
        Utils.addWithLabel(jPanel4, (Component)jScrollPane, Utils._("Information to print on report"), "1,2,1,8,f,f");
        jPanel4.add((Component)jPanel2, "3,2,3,2,f,f");
        jPanel4.add((Component)jPanel, "3,4,3,4,f,f");
        jPanel4.add((Component)jPanel3, "3,8,3,8,f,f");
        this.setContentPane(jPanel4);
        this.setLocationByPlatform(true);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.initializeValues();
    }

    private JTable createSelectionTable(SelectionTableModel<?> selectionTableModel) {
        JTable jTable = new JTable(selectionTableModel);
        jTable.setSelectionMode(0);
        jTable.setShowGrid(false);
        jTable.setRowSelectionAllowed(true);
        jTable.setTableHeader(null);
        jTable.getColumnModel().getColumn(0).setMaxWidth(15);
        return jTable;
    }

    private boolean validateNumericInput(JTextField jTextField, int n, int n2, String string) {
        try {
            int n3 = Integer.valueOf(jTextField.getText());
            if (n3 < n || n3 > n2) {
                jTextField.requestFocusInWindow();
                JOptionPane.showMessageDialog(this, string);
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            jTextField.requestFocusInWindow();
            JOptionPane.showMessageDialog(this, string);
            return false;
        }
    }

    protected boolean validateInput() {
        return this.validateNumericInput(this.textThumbnailsPerPage, 1, 9999, Utils._("The number of thumbnails per page must be between 1 and 9999.")) && this.validateNumericInput(this.textPageFrom, 1, 9999, Utils._("The start page must be between 1 and 9999.")) && this.validateNumericInput(this.textPageTo, 1, 9999, Utils._("The end page must be between 1 and 9999."));
    }

    public void initializeValues() {
        List<Enum> list;
        String string;
        ReportOptions reportOptions = EntryPoint.getOptions();
        switch (this.tableType) {
            case RECEIVED: {
                string = Utils._("Fax receive report");
                list = reportOptions.reportRecvColumns;
                break;
            }
            case SENT: {
                string = Utils._("Fax send report");
                list = reportOptions.reportSentColumns;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only TableType SENT and RECEIVED supported!");
            }
        }
        this.setTitle(string);
        if (list.size() > 0) {
            this.colsModel.setSelectedObjects(list);
        } else {
            this.colsModel.selectAll();
        }
        this.textPageFrom.setText(String.valueOf(reportOptions.reportPageFrom));
        this.textPageTo.setText(String.valueOf(reportOptions.reportPageTo));
        this.textThumbnailsPerPage.setText(String.valueOf(reportOptions.reportThumbsPerPage));
        if (reportOptions.reportUnlimitedThumbs) {
            this.radUnlimitedThumbs.setSelected(true);
        } else {
            this.radLimitThumbs.setSelected(true);
        }
        if (reportOptions.reportPrintAllPages) {
            this.radAllPages.setSelected(true);
        } else {
            this.radSelectedPages.setSelected(true);
        }
    }

    public void writeToAndSaveDefaults(SendReport<T> sendReport) {
        String string;
        boolean bl = this.radUnlimitedThumbs.isSelected();
        boolean bl2 = this.radAllPages.isSelected();
        int n = Integer.parseInt(this.textThumbnailsPerPage.getText());
        int n2 = Integer.parseInt(this.textPageFrom.getText());
        int n3 = Integer.parseInt(this.textPageTo.getText());
        List<T> list = Arrays.asList(this.colsModel.getSelectedObjects());
        ReportOptions reportOptions = EntryPoint.getOptions();
        reportOptions.reportPrintAllPages = bl2;
        reportOptions.reportPageFrom = n2;
        reportOptions.reportPageTo = n3;
        reportOptions.reportThumbsPerPage = n;
        reportOptions.reportUnlimitedThumbs = bl;
        switch (this.tableType) {
            case RECEIVED: {
                string = Utils._("Fax receive report");
                reportOptions.reportRecvColumns.clear();
                reportOptions.reportRecvColumns.addAll(list);
                break;
            }
            case SENT: {
                string = Utils._("Fax send report");
                reportOptions.reportSentColumns.clear();
                reportOptions.reportSentColumns.addAll(list);
                break;
            }
            default: {
                throw new IllegalArgumentException("Only TableType SENT and RECEIVED supported!");
            }
        }
        sendReport.setHeadLine(string);
        sendReport.setColumns(list);
        if (bl2) {
            sendReport.setStartPage(1);
            sendReport.setEndPage(0);
        } else {
            sendReport.setStartPage(n2);
            sendReport.setEndPage(n3);
        }
        if (bl) {
            sendReport.setThumbnailsPerPage(0);
        } else {
            sendReport.setThumbnailsPerPage(n);
        }
    }

    public static <T extends FmtItem> SendReport<T> showSendReportDialog(Frame frame, FmtItemList<T> fmtItemList, TableType tableType) {
        SendReportDialog sendReportDialog = new SendReportDialog(frame, fmtItemList, tableType);
        sendReportDialog.setVisible(true);
        if (sendReportDialog.modalResult) {
            SendReport sendReport = new SendReport();
            sendReportDialog.writeToAndSaveDefaults(sendReport);
            sendReportDialog.dispose();
            return sendReport;
        }
        return null;
    }
}

