/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.send;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.PaperSize;
import yajhfc.Utils;
import yajhfc.file.FileConverter;
import yajhfc.file.FileConverterToFile;
import yajhfc.file.FileConverters;
import yajhfc.file.FileFormat;
import yajhfc.file.FormattedFile;
import yajhfc.launch.Launcher2;
import yajhfc.send.HylaTFLItem;
import yajhfc.shutdown.ShutdownManager;

public class LocalFileTFLItem
extends HylaTFLItem {
    private static final Logger log = Logger.getLogger(LocalFileTFLItem.class.getName());
    protected String fileName;
    protected boolean prepared = false;
    protected FormattedFile preparedFile;

    private void convertFile(FileConverter fileConverter) {
        try {
            File file = File.createTempFile("conv", ".ps");
            ShutdownManager.deleteOnExit(file);
            if (fileConverter instanceof FileConverterToFile) {
                ((FileConverterToFile)fileConverter).convertToHylaFormatFile(new File(this.fileName), file, this.desiredPaperSize, FileFormat.PDF);
            } else {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileConverter.convertToHylaFormat(new File(this.fileName), fileOutputStream, this.desiredPaperSize, FileFormat.PDF);
                fileOutputStream.close();
            }
            this.preparedFile = FormattedFile.getTempFileWithCorrectExtension(file);
            switch (this.preparedFile.getFormat()) {
                case PDF: 
                case PostScript: {
                    break;
                }
                default: {
                    throw new FileConverter.ConversionException("Converter output for file " + this.fileName + " has an unsupported file format " + (Object)((Object)this.preparedFile.getFormat()) + " (converter=" + fileConverter + ")");
                }
            }
        }
        catch (Exception exception) {
            Launcher2.application.getDialogUI().showExceptionDialog(MessageFormat.format(Utils._("The document {0} could not be converted to PostScript, PDF or TIFF. Reason:"), this.getText()), exception);
        }
    }

    public void setDesiredPaperSize(PaperSize paperSize) {
        if (!paperSize.equals((Object)this.desiredPaperSize)) {
            super.setDesiredPaperSize(paperSize);
            this.prepared = false;
        }
    }

    protected void prepareFile() throws FileNotFoundException, IOException {
        if (this.prepared) {
            return;
        }
        FileFormat fileFormat = FormattedFile.detectFileFormat(this.fileName);
        if (FormattedFile.canViewFormat(fileFormat)) {
            this.preparedFile = new FormattedFile(this.fileName, fileFormat);
        } else {
            FileConverter fileConverter = FileConverters.getConverterFor(fileFormat);
            if (Utils.debugMode) {
                log.info("prepareFile: fileName='" + this.fileName + "' format: " + (Object)((Object)fileFormat));
            }
            if (fileConverter == null) {
                log.warning("Unconvertable file: " + this.fileName + ", format: " + (Object)((Object)fileFormat));
                this.preparedFile = new FormattedFile(this.fileName, fileFormat);
            } else {
                this.convertFile(fileConverter);
            }
        }
        this.prepared = true;
    }

    public FormattedFile getPreviewFilename() {
        try {
            this.prepareFile();
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error preparing preview:", exception);
            return null;
        }
        return this.preparedFile;
    }

    public String getText() {
        return this.fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setText(String string) {
        if (!this.fileName.equals(string)) {
            this.fileName = string;
            this.prepared = false;
        }
    }

    public LocalFileTFLItem(String string) {
        this.fileName = string;
    }
}

