/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.send;

import com.google.gson.JsonObject;
import gnu.hylafax.HylaFAXClient;
import gnu.hylafax.Job;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import yajhfc.FaxNotification;
import yajhfc.FaxOptions;
import yajhfc.FaxResolution;
import yajhfc.HylaClientManager;
import yajhfc.HylaModem;
import yajhfc.MainWin;
import yajhfc.PaperSize;
import yajhfc.SenderIdentity;
import yajhfc.Utils;
import yajhfc.faxcover.Faxcover;
import yajhfc.file.FileFormat;
import yajhfc.file.FormattedFile;
import yajhfc.file.GhostScriptMultiFileConverter;
import yajhfc.file.MultiFileConverter;
import yajhfc.file.PDFMultiFileConverter;
import yajhfc.launch.Launcher2;
import yajhfc.model.servconn.FaxListConnectionType;
import yajhfc.model.servconn.srfax.SRFaxSentIds;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.convrules.DefaultPBEntryFieldContainer;
import yajhfc.phonebook.convrules.NameRule;
import yajhfc.phonebook.convrules.PBEntryFieldContainer;
import yajhfc.send.FaxSender;
import yajhfc.send.HylaTFLItem;
import yajhfc.send.SendControllerListener;
import yajhfc.send.SendFileManager;
import yajhfc.send.SendWin;
import yajhfc.send.SendWinControl;
import yajhfc.send.SendWinStyle;
import yajhfc.send.SimplifiedSendDialog;
import yajhfc.server.Server;
import yajhfc.server.ServerOptions;
import yajhfc.shutdown.ShutdownManager;
import yajhfc.ui.YajOptionPane;
import yajhfc.ui.swing.SwingYajOptionPane;
import yajhfc.util.ProgressWorker;
import yajhfc.util.SRFaxAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendController
implements FaxSender {
    protected Server server;
    protected YajOptionPane dialogUI;
    protected boolean pollMode;
    protected boolean useCover = false;
    protected List<HylaTFLItem> files = new ArrayList<HylaTFLItem>();
    protected List<PBEntryFieldContainer> numbers = new ArrayList<PBEntryFieldContainer>();
    protected String subject = "";
    protected String comments = "";
    protected PaperSize paperSize;
    protected File customCover = null;
    protected int maxTries;
    protected FaxNotification notificationType;
    protected FaxResolution resolution;
    protected int killTime;
    protected Date sendTime = null;
    protected boolean archiveJob;
    protected final Map<String, String> customProperties;
    protected ProgressWorker.ProgressUI progressMonitor = null;
    protected SenderIdentity fromIdentity;
    protected Object selectedModem;
    protected final List<Long> submittedJobs = new ArrayList<Long>();
    protected final List<SendControllerListener> listeners = new ArrayList<SendControllerListener>();
    private static final int FILE_DISPLAY_LEN = 30;
    static SendWinControl lastSendWin = null;

    public ProgressWorker.ProgressUI getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(ProgressWorker.ProgressUI progressUI) {
        this.progressMonitor = progressUI;
    }

    void setPaperSizes() {
        for (HylaTFLItem hylaTFLItem : this.files) {
            hylaTFLItem.setDesiredPaperSize(this.paperSize);
        }
    }

    protected Faxcover initFaxCover() throws IOException, FileNotFoundException, Faxcover.InvalidCoverFormatException {
        FaxOptions faxOptions = Utils.getFaxOptions();
        File file = null;
        if (this.customCover != null) {
            file = this.customCover;
        } else if (this.fromIdentity.useCustomDefaultCover) {
            file = new File(this.fromIdentity.defaultCover);
        }
        Faxcover faxcover = Faxcover.createInstanceForTemplate(file);
        faxcover.pageCount = 0;
        if (this.customCover != null) {
            if (!this.customCover.canRead()) {
                this.dialogUI.showMessageDialog(MessageFormat.format(Utils._("Can not read file \"{0}\"!"), this.customCover.toString()), Utils._("Error"), 2);
                return null;
            }
        } else if (this.fromIdentity.useCustomDefaultCover && !new File(this.fromIdentity.defaultCover).canRead()) {
            this.dialogUI.showMessageDialog(MessageFormat.format(Utils._("Can not read default cover page file \"{0}\"!"), this.fromIdentity.defaultCover), Utils._("Error"), 2);
            return null;
        }
        for (HylaTFLItem hylaTFLItem : this.files) {
            FileInputStream fileInputStream = new FileInputStream(hylaTFLItem.getPreviewFilename().file);
            faxcover.estimatePostscriptPages(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        faxcover.fromData = this.fromIdentity;
        faxcover.nameRule = faxOptions.coverNameRule;
        faxcover.locationRule = faxOptions.coverLocationRule.generateRule(faxOptions.coverZIPCodeRule);
        faxcover.companyRule = faxOptions.coverCompanyRule;
        faxcover.comments = this.comments;
        faxcover.regarding = this.subject;
        faxcover.pageSize = this.paperSize;
        if (this.sendTime != null) {
            faxcover.coverDate = this.sendTime;
        }
        return faxcover;
    }

    protected File makeCoverFile(Faxcover faxcover, PBEntryFieldContainer pBEntryFieldContainer) throws IOException, FileNotFoundException {
        Object object;
        faxcover.toData = pBEntryFieldContainer != null ? pBEntryFieldContainer : new DefaultPBEntryFieldContainer("");
        if (this.numbers.size() > 1) {
            object = new PBEntryFieldContainer[this.numbers.size() - 1];
            int n = 0;
            for (PBEntryFieldContainer pBEntryFieldContainer2 : this.numbers) {
                if (pBEntryFieldContainer2.equals(pBEntryFieldContainer) || n >= ((Object)object).length) continue;
                object[n++] = pBEntryFieldContainer2;
            }
            faxcover.ccData = object;
        } else {
            faxcover.ccData = null;
        }
        File file = File.createTempFile("cover", ".ps");
        ShutdownManager.deleteOnExit(file);
        object = new FileOutputStream(file);
        faxcover.makeCoverSheet((OutputStream)object);
        ((FileOutputStream)object).close();
        return file;
    }

    public SendController(Server server, Window window, boolean bl) {
        this(server, window, bl, null);
    }

    public SendController(Server server, Window window, boolean bl, ProgressWorker.ProgressUI progressUI) {
        this(server, new SwingYajOptionPane(window), bl, progressUI);
    }

    public SendController(Server server, YajOptionPane yajOptionPane, boolean bl, ProgressWorker.ProgressUI progressUI) {
        this.server = server;
        this.dialogUI = yajOptionPane;
        this.pollMode = bl;
        this.progressMonitor = progressUI;
        ServerOptions serverOptions = server.getOptions();
        this.paperSize = serverOptions.paperSize;
        this.maxTries = serverOptions.maxTry;
        this.notificationType = serverOptions.notifyWhen;
        this.resolution = serverOptions.resolution;
        this.archiveJob = serverOptions.archiveSentFaxes;
        this.customProperties = new TreeMap<String, String>(serverOptions.customJobOptions);
        this.selectedModem = serverOptions.defaultModem;
        this.killTime = serverOptions.killTime;
        this.fromIdentity = server.getDefaultIdentity();
    }

    public boolean validateEntries() {
        if (this.numbers.size() == 0) {
            this.dialogUI.showMessageDialog(Utils._("To send a fax you have to enter at least one phone number!"), Utils._("Warning"), 1);
            return false;
        }
        for (int i = 0; i < this.numbers.size(); ++i) {
            PBEntryFieldContainer pBEntryFieldContainer = this.numbers.get(i);
            String string = pBEntryFieldContainer.getField(PBEntryField.FaxNumber);
            if (string != null && string.length() != 0) continue;
            this.dialogUI.showMessageDialog(MessageFormat.format(Utils._("For recipient {0} (\"{1}\") no fax number has been entered."), i + 1, NameRule.GIVENNAME_NAME.applyRule(pBEntryFieldContainer)), Utils._("Warning"), 1);
            return false;
        }
        if (this.files.size() == 0) {
            if (this.useCover) {
                if (this.dialogUI.showConfirmDialog(Utils._("You haven't selected a file to transmit, so your fax will ONLY contain the cover page.\nContinue anyway?"), Utils._("Continue?"), 0, 3) == 1) {
                    return false;
                }
            } else {
                this.dialogUI.showMessageDialog(Utils._("To send a fax you must select at least one file!"), Utils._("Warning"), 1);
                return false;
            }
        }
        if (this.server.getOptions().faxListConnectionType == FaxListConnectionType.SRFAX && this.customCover != null) {
            this.dialogUI.showMessageDialog(Utils._("SRFax does not support custom cover page!"), Utils._("Warning"), 1);
            return false;
        }
        return true;
    }

    public void sendFax() {
        if (Launcher2.application.getSendReadyState() != MainWin.SendReadyState.Ready) {
            throw new IllegalStateException("Application is not ready to send! (SendReadyState=" + (Object)((Object)Launcher2.application.getSendReadyState()) + ")");
        }
        SendWorker sendWorker = new SendWorker();
        sendWorker.startWork(this.dialogUI, Utils._("Sending fax"));
    }

    public void previewFax(PBEntryFieldContainer pBEntryFieldContainer) {
        PreviewWorker previewWorker = new PreviewWorker(pBEntryFieldContainer);
        previewWorker.startWork(this.dialogUI, Utils._("Previewing fax"));
    }

    public boolean isUseCover() {
        return this.useCover;
    }

    @Override
    public void setUseCover(boolean bl) {
        this.useCover = bl;
    }

    public List<PBEntryFieldContainer> getNumbers() {
        return this.numbers;
    }

    public void setNumbers(List<PBEntryFieldContainer> list) {
        this.numbers = list;
    }

    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(String string) {
        if (string == null) {
            throw new IllegalArgumentException("subject may not be null!");
        }
        this.subject = string;
    }

    public String getComment() {
        return this.comments;
    }

    @Override
    public void setComment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("comments may not be null!");
        }
        this.comments = string;
    }

    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(PaperSize paperSize) {
        if (paperSize == null) {
            throw new IllegalArgumentException("paperSize may not be null!");
        }
        this.paperSize = paperSize;
    }

    public File getCustomCover() {
        return this.customCover;
    }

    public void setCustomCover(File file) {
        this.customCover = file;
    }

    public int getMaxTries() {
        return this.maxTries;
    }

    public void setMaxTries(int n) {
        this.maxTries = n;
    }

    public FaxNotification getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationType(FaxNotification faxNotification) {
        this.notificationType = faxNotification;
    }

    public FaxResolution getResolution() {
        return this.resolution;
    }

    public void setResolution(FaxResolution faxResolution) {
        this.resolution = faxResolution;
    }

    public int getKillTime() {
        return this.killTime;
    }

    public void setKillTime(int n) {
        this.killTime = n;
    }

    public Object getSelectedModem() {
        return this.selectedModem;
    }

    public void setSelectedModem(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("selectedModem may not be null!");
        }
        this.selectedModem = object;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public Server getServer() {
        return this.server;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    @Override
    public boolean isPollMode() {
        return this.pollMode;
    }

    public List<HylaTFLItem> getFiles() {
        return this.files;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(Date date) {
        this.sendTime = date;
    }

    public boolean isArchiveJob() {
        return this.archiveJob;
    }

    public void setArchiveJob(boolean bl) {
        this.archiveJob = bl;
    }

    public void addSendControllerListener(SendControllerListener sendControllerListener) {
        this.listeners.add(sendControllerListener);
    }

    public void removeSendControllerListener(SendControllerListener sendControllerListener) {
        this.listeners.remove(sendControllerListener);
    }

    protected void fireSendOperationComplete(boolean bl) {
        for (SendControllerListener sendControllerListener : this.listeners) {
            sendControllerListener.sendOperationComplete(bl);
        }
    }

    @Override
    public List<Long> getSubmittedJobIDs() {
        return this.submittedJobs;
    }

    public SenderIdentity getIdentity() {
        return this.fromIdentity;
    }

    @Override
    public void setIdentity(SenderIdentity senderIdentity) {
        this.fromIdentity = senderIdentity;
    }

    public static void printJobIDIfRequested(Long l) {
        if (Launcher2.jobIDWriter != null) {
            Launcher2.jobIDWriter.printf("%1$tF %1$tT NEW_FAXJOB %2$d", new Date(), l);
            Launcher2.jobIDWriter.println();
            Launcher2.jobIDWriter.flush();
        }
    }

    public static SendWinControl getSendWindow(Frame frame, Server server, boolean bl, boolean bl2) {
        if (lastSendWin == null || lastSendWin.isPollMode() != bl) {
            return SendController.createSendWindow(frame, server, false, bl2);
        }
        return lastSendWin;
    }

    public static SendWinControl createSendWindow(Frame frame, Server server, boolean bl, boolean bl2) {
        if (lastSendWin != null) {
            lastSendWin.getWindow().dispose();
            lastSendWin = null;
        }
        JDialog jDialog = bl || Utils.getFaxOptions().sendWinStyle == SendWinStyle.TRADITIONAL ? new SendWin(server, frame, bl) : new SimplifiedSendDialog(server, frame, bl2);
        lastSendWin = jDialog;
        jDialog.getWindow().addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (lastSendWin == windowEvent.getSource()) {
                    lastSendWin = null;
                }
            }
        });
        return jDialog;
    }

    @Override
    public Collection<PBEntryFieldContainer> getRecipients() {
        return this.numbers;
    }

    @Override
    public Collection<HylaTFLItem> getDocuments() {
        return this.files;
    }

    @Override
    public void setModem(String string) {
        this.setSelectedModem(string);
    }

    class SendWorker
    extends ProgressWorker {
        final Logger log = Logger.getLogger(SendWorker.class.getName());
        final SendFileManager fileManager;
        boolean success = false;

        private void setIfNotEmpty(Job job, String string, String string2) {
            try {
                if (string2.length() > 0) {
                    job.setProperty(string, Utils.sanitizeInput(string2));
                }
            }
            catch (Exception exception) {
                this.log.log(Level.WARNING, "Couldn't set additional job info " + string + ": ", exception);
            }
        }

        private String getModem() {
            Object object = SendController.this.selectedModem;
            if (Utils.debugMode) {
                this.log.fine("Selected modem (" + object.getClass().getCanonicalName() + "): " + object);
            }
            if (object instanceof HylaModem) {
                return ((HylaModem)object).getInternalName();
            }
            String string = object.toString();
            int n = string.indexOf(32);
            if (n == -1) {
                return string;
            }
            return string.substring(0, n);
        }

        protected int calculateMaxProgress() {
            int n = 20 * SendController.this.numbers.size() + 10 + this.fileManager.calcMaxProgress();
            if (SendController.this.useCover) {
                n += 20;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void doWork() {
            FaxOptions faxOptions = Utils.getFaxOptions();
            ServerOptions serverOptions = SendController.this.server.getOptions();
            if (serverOptions.faxListConnectionType == FaxListConnectionType.SRFAX) {
                Object object;
                String string;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (PBEntryFieldContainer object22 : SendController.this.numbers) {
                    string = object22.getField(PBEntryField.FaxNumber).replaceAll("[^\\d.]", "");
                    if (string.length() == 10) {
                        string = "1" + string;
                    }
                    arrayList.add(string);
                    arrayList2.add(object22.getField(PBEntryField.GivenName));
                }
                String string2 = "Queue_Fax";
                string = "";
                int n = 0;
                string = string + "&sCPSubject=" + SendController.this.subject;
                if (SendController.this.useCover) {
                    try {
                        string = string + "&sCoverPage=Company&sCPComments=" + SendController.this.comments + "&sCPFromName=" + serverOptions.SRFaxNumber + "&sCPToName=" + StringUtils.join(arrayList2, ", ");
                    }
                    catch (Exception pBEntryFieldContainer) {
                        this.showExceptionDialog(Utils._("An error occured with the cover page: "), pBEntryFieldContainer);
                    }
                }
                for (HylaTFLItem hylaTFLItem : SendController.this.files) {
                    block44: {
                        this.updateNote(MessageFormat.format(Utils._("Creating job for {0}"), hylaTFLItem.toString()));
                        try {
                            Object object2;
                            Object object3;
                            Object object4;
                            File file = new File(hylaTFLItem.toString());
                            if (!file.exists()) {
                                object4 = hylaTFLItem.getPreviewFilename();
                                object3 = new File(Utils.getFaxOptions().ghostScriptLocation);
                                if (((FormattedFile)object4).getFormat() == FileFormat.PostScript) {
                                    if (!((File)object3).exists()) {
                                        this.showMessageDialog("Ghostscript is required to convert PostScript file to PDF files. SRFax does not accept PostScript file in the API.", "Ghostscript executable not found", 0);
                                    }
                                    file = File.createTempFile("temp", ".pdf");
                                    object2 = new PDFMultiFileConverter();
                                    File[] fileArray = new File[]{((FormattedFile)object4).getFile()};
                                    ((GhostScriptMultiFileConverter)object2).convertMultiplePSorPDFFiles(fileArray, file, SendController.this.paperSize);
                                } else {
                                    file = ((FormattedFile)object4).getFile();
                                }
                            }
                            if (file.exists()) {
                                object4 = FileUtils.readFileToByteArray(file);
                                object3 = DatatypeConverter.printBase64Binary((byte[])object4);
                                string = string + "&sFileName_" + n + "=" + URLEncoder.encode(file.getName().toString(), "UTF-8") + "&sFileContent_" + n + "=" + URLEncoder.encode((String)object3, "UTF-8");
                                break block44;
                            }
                            object4 = hylaTFLItem.toString().substring(hylaTFLItem.toString().indexOf(":") + 1);
                            object3 = ((String)object4).substring(((String)object4).indexOf("|") + 1);
                            if (SendController.this.files.size() > 1) {
                                object2 = SRFaxAPI.sendPost("Retrieve_Fax&sFaxFileName=" + (String)object4 + "&sFaxDetailsID=" + (String)object3 + "&sDirection=IN", serverOptions.user, serverOptions.pass.getPassword()).get("Result").getAsString();
                                try {
                                    string = string + "&sFileName_" + n + "=" + URLEncoder.encode((String)object3 + ".pdf", "UTF-8") + "&sFileContent_" + n + "=" + URLEncoder.encode((String)object2, "UTF-8");
                                    break block44;
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    SendController.this.dialogUI.showExceptionDialog("UnsupportedEncodingException", unsupportedEncodingException);
                                    this.success = false;
                                    return;
                                }
                            }
                            String string3 = "Forward_Fax";
                            string = "&sDirection=IN&sFaxFileName=" + (String)object4 + "&sFaxDetailsID" + (String)object3;
                        }
                        catch (Exception exception) {
                            SendController.this.dialogUI.showExceptionDialog("Error", "Something wrong with your files", exception);
                            this.success = false;
                            return;
                        }
                    }
                    ++n;
                }
                if (SendController.this.sendTime != null && SendController.this.sendTime.getTime() - 10000L >= System.currentTimeMillis()) {
                    object = new SimpleDateFormat("yyyy-MM-dd");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
                    string = string + "&sQueueFaxDate=" + ((DateFormat)object).format(SendController.this.sendTime) + "&sQueueFaxTime=" + simpleDateFormat.format(SendController.this.sendTime);
                }
                try {
                    void var6_12;
                    JsonObject jsonObject = SRFaxAPI.sendPost((String)var6_12 + "&sCallerID=" + serverOptions.SRFaxNumber + "&sSenderEmail=" + serverOptions.SRFaxEmail + "&sFaxType=" + (arrayList.size() > 1 ? "BROADCAST" : "SINGLE") + "&sToFaxNumber=" + StringUtils.join(arrayList, "|") + string, serverOptions.user, serverOptions.pass.getPassword());
                    if (jsonObject.get("Status").getAsString().compareTo("Failed") == 0) {
                        SendController.this.dialogUI.showMessageDialog(jsonObject.get("Result").getAsString(), Utils._("Error"), 0);
                        this.success = false;
                        return;
                    }
                    object = jsonObject.get("Result").getAsString();
                    SRFaxSentIds.getInstance().ids.add(serverOptions.user + "@" + (String)object);
                }
                catch (Exception exception) {
                    this.showExceptionDialog(Utils._("An error occured while submitting the fax: "), exception);
                }
                faxOptions.useCover = SendController.this.useCover;
                SendController.this.dialogUI.showMessageDialog("Fax successfully queued.", Utils._("Success"), 1);
                this.success = true;
                return;
            }
            HylaClientManager hylaClientManager = SendController.this.server.getClientManager();
            try {
                HylaFAXClient hylaFAXClient = hylaClientManager.beginServerTransaction(SendController.this.dialogUI);
                if (hylaFAXClient == null) {
                    return;
                }
                SendController.this.submittedJobs.clear();
                Faxcover faxcover = null;
                if (!SendController.this.pollMode) {
                    SendController.this.setPaperSizes();
                    if (SendController.this.useCover) {
                        faxcover = SendController.this.initFaxCover();
                        this.stepProgressBar(20);
                    }
                    this.fileManager.uploadFiles(hylaFAXClient, this);
                }
                String string = Utils.sanitizeInput(this.getModem());
                if (Utils.debugMode) {
                    this.log.fine("Use modem: " + string);
                }
                String string4 = serverOptions.filterFromFaxNr + "\r\n";
                for (PBEntryFieldContainer pBEntryFieldContainer : SendController.this.numbers) {
                    this.updateNote(MessageFormat.format(Utils._("Creating job to {0}"), pBEntryFieldContainer.getField(PBEntryField.FaxNumber)));
                    try {
                        if (faxcover != null) {
                            this.fileManager.setCoverFile(SendController.this.makeCoverFile(faxcover, pBEntryFieldContainer), hylaFAXClient);
                        }
                        this.stepProgressBar(5);
                        HylaFAXClient hylaFAXClient2 = hylaFAXClient;
                        synchronized (hylaFAXClient2) {
                            this.log.finest("In hyfc monitor");
                            Job job = hylaFAXClient.createJob();
                            this.stepProgressBar(5);
                            job.setFromUser(Utils.sanitizeInput(hylaClientManager.getUser()));
                            String string5 = Utils.sanitizeInput(serverOptions.notifyAddress);
                            if (string5 != null && string5.length() > 0) {
                                job.setNotifyAddress(string5);
                            }
                            job.setMaximumDials(serverOptions.maxDial);
                            if (!SendController.this.pollMode) {
                                this.setIfNotEmpty(job, "TOUSER", faxOptions.coverNameRule.applyRule(pBEntryFieldContainer));
                                this.setIfNotEmpty(job, "TOCOMPANY", faxOptions.coverCompanyRule.applyRule(pBEntryFieldContainer));
                                this.setIfNotEmpty(job, "TOLOCATION", faxOptions.coverLocationRule.generateRule(faxOptions.coverZIPCodeRule).applyRule(pBEntryFieldContainer));
                                this.setIfNotEmpty(job, "TOVOICE", pBEntryFieldContainer.getField(PBEntryField.VoiceNumber));
                                this.setIfNotEmpty(job, "REGARDING", SendController.this.subject);
                                this.setIfNotEmpty(job, "COMMENTS", SendController.this.comments);
                                this.setIfNotEmpty(job, "FROMCOMPANY", SendController.this.fromIdentity.FromCompany);
                                this.setIfNotEmpty(job, "FROMLOCATION", SendController.this.fromIdentity.FromLocation);
                                this.setIfNotEmpty(job, "FROMVOICE", SendController.this.fromIdentity.FromVoiceNumber);
                                if (faxOptions.regardingAsUsrKey) {
                                    this.setIfNotEmpty(job, "USRKEY", SendController.this.subject);
                                }
                            }
                            String string6 = serverOptions.numberPrefix + Utils.stringFilterOut(pBEntryFieldContainer.getField(PBEntryField.FaxNumber), string4, 255);
                            job.setDialstring(string6);
                            job.setMaximumTries(SendController.this.maxTries);
                            job.setNotifyType(SendController.this.notificationType.getType());
                            job.setPageDimension(SendController.this.paperSize.getSize());
                            job.setVerticalResolution(SendController.this.resolution.getResolution());
                            if (SendController.this.resolution.useXVRes()) {
                                job.setProperty("USEXVRES", "YES");
                            }
                            if (SendController.this.sendTime == null || SendController.this.sendTime.getTime() - 10000L < System.currentTimeMillis()) {
                                job.setSendTime("NOW");
                            } else {
                                job.setSendTime(SendController.this.sendTime);
                            }
                            job.setKilltime(Utils.minutesToHylaTime(SendController.this.killTime));
                            job.setProperty("MODEM", string);
                            if (SendController.this.archiveJob) {
                                job.setProperty("doneop", "archive");
                            }
                            for (Map.Entry<String, String> entry : SendController.this.customProperties.entrySet()) {
                                job.setProperty(entry.getKey(), entry.getValue());
                            }
                            if (SendController.this.pollMode) {
                                job.setProperty("POLL", "\"\" \"\"");
                            } else {
                                this.fileManager.attachDocuments(hylaFAXClient, job, this);
                                faxOptions.useCover = SendController.this.useCover;
                                faxOptions.useCustomCover = SendController.this.customCover != null;
                                faxOptions.CustomCover = SendController.this.customCover != null ? SendController.this.customCover.getAbsolutePath() : null;
                            }
                            this.stepProgressBar(5);
                            hylaFAXClient.submit(job);
                            Long l = job.getId();
                            SendController.this.submittedJobs.add(l);
                            SendController.printJobIDIfRequested(l);
                        }
                        this.log.finest("Out of hyfc monitor");
                        this.stepProgressBar(5);
                    }
                    catch (Exception exception) {
                        this.showExceptionDialog(MessageFormat.format(Utils._("An error occured while submitting the fax job for phone number \"{0}\" (will try to submit the fax to the other numbers anyway): "), pBEntryFieldContainer.getField(PBEntryField.FaxNumber)), exception);
                    }
                }
                this.updateNote(Utils._("Cleaning up"));
                this.success = true;
            }
            catch (Exception exception) {
                this.showExceptionDialog(Utils._("An error occured while submitting the fax: "), exception);
            }
            hylaClientManager.endServerTransaction();
        }

        protected void done() {
            SendController.this.fireSendOperationComplete(this.success);
            Utils.executorService.submit(new Runnable(){

                public void run() {
                    SendWorker.this.fileManager.cleanup();
                }
            });
        }

        public SendWorker() {
            this.progressMonitor = SendController.this.progressMonitor;
            this.fileManager = new SendFileManager(SendController.this.paperSize, SendController.this.files);
        }
    }

    class PreviewWorker
    extends ProgressWorker {
        protected PBEntryFieldContainer selectedNumber;

        public PreviewWorker(PBEntryFieldContainer pBEntryFieldContainer) {
            this.selectedNumber = pBEntryFieldContainer;
            this.progressMonitor = SendController.this.progressMonitor;
        }

        protected int calculateMaxProgress() {
            return 15000;
        }

        public void doWork() {
            try {
                int n;
                SendController.this.setPaperSizes();
                ArrayList<FormattedFile> arrayList = new ArrayList<FormattedFile>(SendController.this.files.size() + 1);
                if (SendController.this.useCover && SendController.this.server.getOptions().faxListConnectionType != FaxListConnectionType.SRFAX) {
                    n = 10000 / (SendController.this.files.size() + 1);
                    this.updateNote(Utils._("Creating cover page"));
                    File file = SendController.this.makeCoverFile(SendController.this.initFaxCover(), this.selectedNumber);
                    arrayList.add(new FormattedFile(file));
                    this.setProgress(n);
                } else {
                    n = SendController.this.files.size() > 0 ? 10000 / SendController.this.files.size() : 0;
                }
                for (HylaTFLItem hylaTFLItem : SendController.this.files) {
                    this.updateNote(MessageFormat.format(Utils._("Formatting {0}"), Utils.shortenFileNameForDisplay(hylaTFLItem.getText(), 30)));
                    FormattedFile formattedFile = hylaTFLItem.getPreviewFilename();
                    if (formattedFile != null) {
                        arrayList.add(formattedFile);
                    }
                    this.stepProgressBar(n);
                }
                if (arrayList.size() > 0) {
                    this.updateNote(Utils._("Launching viewer"));
                    MultiFileConverter.viewMultipleFiles(arrayList, SendController.this.paperSize, true);
                }
            }
            catch (Exception exception) {
                this.showExceptionDialog(Utils._("Error previewing the documents:"), exception);
            }
        }
    }
}

