/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.send;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.file.FileConverter;
import yajhfc.file.MultiFileConvFormat;
import yajhfc.file.MultiFileConverter;
import yajhfc.file.UnknownFormatException;
import yajhfc.send.SendController;
import yajhfc.send.SendControllerListener;
import yajhfc.send.email.YajMailer;
import yajhfc.shutdown.ShutdownManager;
import yajhfc.ui.YajOptionPane;

public class SendFaxArchiver
implements SendControllerListener {
    private static final Logger log = Logger.getLogger(SendFaxArchiver.class.getName());
    protected final SendController sendController;
    protected final YajOptionPane dialogs;
    protected final String errorDir;
    protected final String successDir;
    protected final String errorMail;
    protected final Object logger;

    public SendFaxArchiver(SendController sendController, YajOptionPane yajOptionPane, String string, String string2, String string3, Object object) {
        this.sendController = sendController;
        this.dialogs = yajOptionPane;
        this.successDir = string;
        this.errorDir = string2;
        this.logger = object;
        this.errorMail = string3;
        sendController.addSendControllerListener(this);
    }

    protected String getPdfBaseName() {
        return new SimpleDateFormat("yyyy-MM-dd_HHmmss").format(new Date());
    }

    public File saveFaxAsPDF(String string, String string2) throws IOException, UnknownFormatException, FileConverter.ConversionException {
        String string3 = this.getPdfBaseName();
        File file = new File(string2, string3 + ".pdf");
        int n = 0;
        while (!file.createNewFile()) {
            file = new File(string2, string3 + "-" + ++n + ".pdf");
        }
        log.fine("Saving fax as " + file);
        MultiFileConverter.convertTFLItemsToSingleFile(this.sendController.getFiles(), file, MultiFileConvFormat.PDF, this.sendController.getPaperSize());
        if (string != null && string.length() > 0) {
            String string4 = file.getName();
            int n2 = string4.lastIndexOf(46);
            if (n2 < 0) {
                n2 = string4.length();
            }
            string4 = string4.substring(0, n2) + ".log";
            File file2 = new File(string2, string4);
            FileWriter fileWriter = new FileWriter(file2);
            fileWriter.write(string);
            fileWriter.close();
        }
        return file;
    }

    public void saveFaxAsSuccess() {
        log.info("Fax has been sent successfully...");
        if (this.successDir != null) {
            try {
                this.saveFaxAsPDF(this.logger != null ? this.logger.toString() : null, this.successDir);
            }
            catch (Exception exception) {
                this.dialogs.showExceptionDialog("Error saving fax as PDF", exception);
            }
        }
    }

    public void saveFaxAsError() {
        log.info("Fax has not been sent successfully...");
        File file = null;
        if (this.errorDir != null) {
            try {
                file = this.saveFaxAsPDF(this.logger != null ? this.logger.toString() : null, this.errorDir);
            }
            catch (Exception exception) {
                this.dialogs.showExceptionDialog("Error saving fax as PDF", exception);
            }
        }
        if (this.errorMail != null) {
            if (!YajMailer.isAvailable()) {
                this.dialogs.showMessageDialog("Mail plugin not installed, cannot send error mail.", "Error", 0);
            } else {
                try {
                    boolean bl;
                    boolean bl2 = bl = file == null;
                    if (bl) {
                        file = File.createTempFile("attachment", ".pdf");
                        ShutdownManager.deleteOnExit(file);
                        MultiFileConverter.convertTFLItemsToSingleFile(this.sendController.getFiles(), file, MultiFileConvFormat.PDF, this.sendController.getPaperSize());
                    }
                    String string = Utils._("The attached fax could not be submitted successfully to HylaFAX.");
                    if (this.logger != null) {
                        string = string + "\n\n" + Utils._("Send log:") + "\n-------------------------------------------------\n" + this.logger;
                    }
                    YajMailer yajMailer = YajMailer.getInstance();
                    yajMailer.setSubject("YajHFC: " + Utils._("Fax failed to send"));
                    yajMailer.setBody(string);
                    yajMailer.setToAddresses(this.errorMail);
                    yajMailer.addAttachment(file, this.getPdfBaseName() + ".pdf");
                    yajMailer.setFromIdentity(this.sendController.getIdentity());
                    yajMailer.sendMail();
                    if (bl) {
                        file.delete();
                    }
                }
                catch (Exception exception) {
                    this.dialogs.showExceptionDialog("Error sending mail for failed fax", exception);
                }
            }
        }
    }

    public void sendOperationComplete(boolean bl) {
        if (bl) {
            this.saveFaxAsSuccess();
        } else {
            this.saveFaxAsError();
        }
    }
}

