/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.send;

import gnu.hylafax.HylaFAXClient;
import gnu.hylafax.Job;
import gnu.inet.ftp.ServerResponseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import yajhfc.PaperSize;
import yajhfc.Utils;
import yajhfc.file.FileConverter;
import yajhfc.file.FileFormat;
import yajhfc.file.FormattedFile;
import yajhfc.file.MultiFileConvFormat;
import yajhfc.file.MultiFileConverter;
import yajhfc.file.UnknownFormatException;
import yajhfc.options.MultiFileMode;
import yajhfc.send.HylaTFLItem;
import yajhfc.util.ProgressWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendFileManager {
    protected final List<HylaTFLItem> files;
    protected File coverFile;
    protected String pdfServerName;
    protected String coverName;
    protected final MultiFileMode mode;
    protected final MultiFileConvFormat targetFormat;
    protected final boolean createAlwaysTargetFormat;
    protected final PaperSize paperSize;
    private static final int FILE_DISPLAY_LEN = 30;

    public void uploadFiles(HylaFAXClient hylaFAXClient, ProgressWorker progressWorker) throws FileNotFoundException, IOException, ServerResponseException, UnknownFormatException, FileConverter.ConversionException {
        switch (this.mode) {
            case NONE: {
                hylaFAXClient.type('I');
                MessageFormat messageFormat = new MessageFormat(Utils._("Uploading {0}"));
                for (HylaTFLItem hylaTFLItem : this.files) {
                    progressWorker.updateNote(messageFormat.format(new Object[]{Utils.shortenFileNameForDisplay(hylaTFLItem.getText(), 30)}));
                    hylaTFLItem.upload(hylaFAXClient);
                    progressWorker.stepProgressBar(20);
                }
                this.pdfServerName = null;
                break;
            }
            case EXCEPT_COVER: {
                this.pdfServerName = this.putPDFFile(hylaFAXClient, progressWorker, null);
                break;
            }
            case FULL_FAX: {
                this.pdfServerName = null;
            }
        }
    }

    public int calcMaxProgress() {
        switch (this.mode) {
            case NONE: {
                return 20 * this.files.size();
            }
            case EXCEPT_COVER: 
            case FULL_FAX: {
                return 100 + 10 * this.files.size();
            }
        }
        return 0;
    }

    private String putPDFFile(HylaFAXClient hylaFAXClient, ProgressWorker progressWorker, File file) throws IOException, UnknownFormatException, FileConverter.ConversionException, ServerResponseException {
        Object object;
        Object object2;
        ArrayList<FormattedFile> arrayList = new ArrayList<FormattedFile>(this.files.size() + 1);
        if (file != null) {
            arrayList.add(new FormattedFile(file));
        }
        MessageFormat messageFormat = new MessageFormat(Utils._("Converting {0}"));
        for (HylaTFLItem object32 : this.files) {
            progressWorker.updateNote(messageFormat.format(new Object[]{Utils.shortenFileNameForDisplay(object32.getText(), 30)}));
            object2 = object32.getPreviewFilename();
            if (object2 != null) {
                arrayList.add((FormattedFile)object2);
            }
            progressWorker.stepProgressBar(10);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (!(arrayList.size() != 1 || this.createAlwaysTargetFormat && ((FormattedFile)arrayList.get(0)).getFormat() != this.targetFormat.getFileFormat())) {
            progressWorker.updateNote(Utils._("Uploading document"));
            object = new FileInputStream(((FormattedFile)arrayList.get((int)0)).file);
            hylaFAXClient.type('I');
            if (Utils.getFaxOptions().sendFORMCommand) {
                hylaFAXClient.form(((FormattedFile)arrayList.get(0)).getFormat().getHylaFAXFormatString());
            }
            String string = hylaFAXClient.putTemporary((InputStream)object);
            ((FileInputStream)object).close();
            progressWorker.stepProgressBar(100);
            return string;
        }
        progressWorker.updateNote(MessageFormat.format(Utils._("Creating {0} from documents to send"), new Object[]{this.targetFormat}));
        object = File.createTempFile("submit", "." + this.targetFormat.getFileFormat().getDefaultExtension());
        MultiFileConverter.convertMultipleFilesToSingleFile(arrayList, (File)object, this.targetFormat, this.paperSize);
        progressWorker.stepProgressBar(50);
        progressWorker.updateNote(MessageFormat.format(Utils._("Uploading {0}"), new Object[]{this.targetFormat}));
        FileInputStream fileInputStream = new FileInputStream((File)object);
        hylaFAXClient.type('I');
        if (Utils.getFaxOptions().sendFORMCommand) {
            hylaFAXClient.form(this.targetFormat.getFileFormat().getHylaFAXFormatString());
        }
        object2 = hylaFAXClient.putTemporary(fileInputStream);
        fileInputStream.close();
        ((File)object).delete();
        progressWorker.stepProgressBar(50);
        return object2;
    }

    public void setCoverFile(File file, HylaFAXClient hylaFAXClient) throws IOException, ServerResponseException {
        switch (this.mode) {
            case NONE: 
            case EXCEPT_COVER: {
                if (file != null) {
                    hylaFAXClient.type('I');
                    FileInputStream fileInputStream = new FileInputStream(file);
                    if (Utils.getFaxOptions().sendFORMCommand) {
                        hylaFAXClient.form(FileFormat.PostScript.getHylaFAXFormatString());
                    }
                    this.coverName = hylaFAXClient.putTemporary(fileInputStream);
                    fileInputStream.close();
                    file.delete();
                } else {
                    this.coverName = null;
                }
                this.coverFile = null;
                break;
            }
            default: {
                this.coverName = null;
                this.coverFile = file;
            }
        }
    }

    public void attachDocuments(HylaFAXClient hylaFAXClient, Job job, ProgressWorker progressWorker) throws ServerResponseException, IOException, UnknownFormatException, FileConverter.ConversionException {
        switch (this.mode) {
            case NONE: {
                if (this.coverName != null) {
                    job.setProperty("COVER", this.coverName);
                }
                for (HylaTFLItem hylaTFLItem : this.files) {
                    job.addDocument(hylaTFLItem.getServerName());
                }
                break;
            }
            case EXCEPT_COVER: {
                if (this.coverName != null) {
                    job.setProperty("COVER", this.coverName);
                }
                if (this.pdfServerName == null) break;
                job.addDocument(this.pdfServerName);
                break;
            }
            case FULL_FAX: {
                if (this.coverFile == null) {
                    if (this.pdfServerName == null) {
                        this.pdfServerName = this.putPDFFile(hylaFAXClient, progressWorker, this.coverFile);
                    }
                    if (this.pdfServerName == null) break;
                    job.addDocument(this.pdfServerName);
                    break;
                }
                String string = this.putPDFFile(hylaFAXClient, progressWorker, this.coverFile);
                if (string == null) break;
                job.addDocument(string);
            }
        }
    }

    public void cleanup() {
        for (HylaTFLItem hylaTFLItem : this.files) {
            hylaTFLItem.cleanup();
        }
    }

    public SendFileManager(PaperSize paperSize, List<HylaTFLItem> list) {
        this(Utils.getFaxOptions().multiFileSendMode, Utils.getFaxOptions().singleFileFormat, Utils.getFaxOptions().alwaysCreateTargetFormat, paperSize, list);
    }

    public SendFileManager(MultiFileMode multiFileMode, MultiFileConvFormat multiFileConvFormat, boolean bl, PaperSize paperSize, List<HylaTFLItem> list) {
        this.mode = multiFileMode;
        this.targetFormat = multiFileConvFormat;
        this.files = list;
        this.createAlwaysTargetFormat = bl;
        this.paperSize = paperSize;
    }
}

