/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.send;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import yajhfc.FaxNotification;
import yajhfc.FaxOptions;
import yajhfc.FaxResolution;
import yajhfc.FileTextField;
import yajhfc.HylaModem;
import yajhfc.PaperSize;
import yajhfc.SenderIdentity;
import yajhfc.Utils;
import yajhfc.faxcover.Faxcover;
import yajhfc.file.FileConverters;
import yajhfc.model.IconMap;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.convrules.PBEntryFieldContainer;
import yajhfc.phonebook.ui.NewPhoneBookWin;
import yajhfc.send.HylaTFLItem;
import yajhfc.send.LocalFileTFLItem;
import yajhfc.send.NumberTFLItem;
import yajhfc.send.SendController;
import yajhfc.send.SendControllerListener;
import yajhfc.send.SendWinControl;
import yajhfc.send.TFLItem;
import yajhfc.send.TextFieldList;
import yajhfc.server.Server;
import yajhfc.server.ServerOptions;
import yajhfc.util.CancelAction;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ExcDialogAbstractAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SendWin
extends JDialog
implements SendWinControl {
    private static final Logger log = Logger.getLogger(SendWin.class.getName());
    JPanel jContentPane = null;
    JButton buttonCancel = null;
    JTabbedPane tabMain = null;
    JPanel paneCommon = null;
    JTextField textNumber = null;
    JComboBox comboResolution = null;
    JComboBox comboPaperSize = null;
    JComboBox comboNotification = null;
    JComboBox comboModem = null;
    JSpinner spinKillTime = null;
    JSpinner spinMaxTries = null;
    FileTextField ftfFilename = null;
    TextFieldList<NumberTFLItem> tflNumbers;
    TextFieldList<HylaTFLItem> tflFiles;
    JPanel paneCover = null;
    JCheckBox checkUseCover = null;
    JCheckBox checkCustomCover = null;
    FileTextField ftfCustomCover = null;
    JTextField textToName = null;
    JTextField textToCompany = null;
    JTextField textToLocation = null;
    JTextField textToVoiceNumber = null;
    JTextField textSubject = null;
    JScrollPane scrollToComments = null;
    JTextArea textToComments = null;
    ClipboardPopup clpNumbers;
    ClipboardPopup clpFiles;
    boolean pollMode = false;
    boolean modalResult = false;
    static final Dimension buttonSize = new Dimension(120, 27);
    static final int border = 10;
    Server server;
    SendController sendController;
    private List<PBEntryFieldContainer> recipientList;

    public SendWin(Server server, Frame frame) {
        this(server, frame, false);
    }

    public SendWin(Server server, Frame frame, boolean bl) {
        super(frame, true);
        this.server = server;
        this.pollMode = bl;
        if (Utils.debugMode) {
            log.fine("Creating new SendWin: server=" + server + ", owner = " + frame);
        }
        this.initialize();
        if (Utils.debugMode) {
            log.fine("New SendWin created.");
        }
    }

    private void initialize() {
        this.setSize(530, 380);
        this.setName("SendWin");
        this.setTitle(Utils._("Send Fax"));
        this.setDefaultCloseOperation(2);
        this.sendController = new SendController(this.server, this, this.pollMode);
        this.sendController.addSendControllerListener(new SendControllerListener(){

            public void sendOperationComplete(boolean bl) {
                if (bl) {
                    SendWin.this.dispose();
                }
            }
        });
        this.setContentPane(this.getJContentPane());
        FaxOptions faxOptions = Utils.getFaxOptions();
        ServerOptions serverOptions = this.server.getOptions();
        this.comboResolution.setSelectedItem((Object)serverOptions.resolution);
        this.comboPaperSize.setSelectedItem((Object)serverOptions.paperSize);
        this.comboNotification.setSelectedItem(serverOptions.notifyWhen);
        this.setModem(serverOptions.defaultModem);
        this.spinMaxTries.setValue(serverOptions.maxTry);
        this.spinKillTime.setValue(serverOptions.killTime);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                Utils.getFaxOptions().sendWinBounds = SendWin.this.getBounds();
            }
        });
        if (faxOptions.sendWinBounds != null) {
            this.setBounds(faxOptions.sendWinBounds);
        } else {
            Utils.setDefWinPos(this);
        }
        if (this.pollMode) {
            this.ftfFilename.setText(Utils._("<none>"));
            this.ftfFilename.setEnabled(false);
            this.tflFiles.setEnabled(false);
            this.setTitle(Utils._("Poll fax"));
            this.pack();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.modalResult = false;
        }
        super.setVisible(bl);
    }

    @Override
    public boolean getModalResult() {
        return this.modalResult;
    }

    @Override
    public List<Long> getSubmittedJobIDs() {
        return this.sendController.getSubmittedJobIDs();
    }

    private JLabel addCoverComp(JComponent jComponent, String string, String string2) {
        JLabel jLabel = Utils.addWithLabel(this.paneCover, (Component)jComponent, string, string2);
        return jLabel;
    }

    void enableCoverComps(boolean bl) {
        this.checkCustomCover.setEnabled(bl);
        this.ftfCustomCover.setEnabled(this.checkCustomCover.isSelected() && bl);
    }

    private JPanel getPaneCover() {
        if (this.paneCover == null) {
            double[][] dArrayArray = new double[][]{{10.0, -1.0, 10.0}, new double[16]};
            double d = 0.125;
            dArrayArray[1][0] = 5.0;
            dArrayArray[1][1] = -2.0;
            for (int i = 2; i <= 14; ++i) {
                dArrayArray[1][i] = i % 2 == 0 ? -2.0 : d;
            }
            dArrayArray[1][dArrayArray[1].length - 1] = -1.0;
            FaxOptions faxOptions = Utils.getFaxOptions();
            this.paneCover = new JPanel(new TableLayout(dArrayArray));
            this.checkUseCover = new JCheckBox(Utils._("Use cover page"));
            this.checkUseCover.setSelected(faxOptions.useCover);
            this.checkUseCover.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SendWin.this.enableCoverComps(SendWin.this.checkUseCover.isSelected());
                }
            });
            this.checkCustomCover = new JCheckBox(Utils._("Use custom cover page:"));
            this.checkCustomCover.setSelected(faxOptions.useCustomCover);
            this.checkCustomCover.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SendWin.this.ftfCustomCover.setEnabled(SendWin.this.checkCustomCover.isSelected() && SendWin.this.checkCustomCover.isEnabled());
                }
            });
            this.ftfCustomCover = new FileTextField();
            this.ftfCustomCover.setFileFilters(Faxcover.getAcceptedFileFilters());
            if (faxOptions.CustomCover != null && faxOptions.CustomCover.length() > 0) {
                this.ftfCustomCover.setText(faxOptions.CustomCover);
            } else {
                this.ftfCustomCover.setText(this.server.getDefaultIdentity().defaultCover);
            }
            this.textToName = new JTextField();
            this.textToCompany = new JTextField();
            this.textToLocation = new JTextField();
            this.textSubject = new JTextField();
            this.textToVoiceNumber = new JTextField();
            this.textToName.addMouseListener(this.getDefClPop());
            this.textToCompany.addMouseListener(this.getDefClPop());
            this.textToLocation.addMouseListener(this.getDefClPop());
            this.textSubject.addMouseListener(this.getDefClPop());
            this.textToVoiceNumber.addMouseListener(this.getDefClPop());
            this.ftfCustomCover.getJTextField().addMouseListener(this.getDefClPop());
            this.textToComments = new JTextArea();
            this.textToComments.setWrapStyleWord(true);
            this.textToComments.setLineWrap(true);
            this.textToComments.addMouseListener(this.getDefClPop());
            this.scrollToComments = new JScrollPane(this.textToComments, 22, 31);
            this.paneCover.add((Component)this.checkUseCover, "1, 1, F, C");
            this.paneCover.add((Component)this.checkCustomCover, "1, 2, F, C");
            this.paneCover.add((Component)this.ftfCustomCover, "1, 3, F, T");
            this.addCoverComp(this.textToName, Utils._("Recipient Name:"), "1, 5, F, T");
            this.addCoverComp(this.textToCompany, Utils._("Company:"), "1, 7, F, T");
            this.addCoverComp(this.textToLocation, Utils._("Location:"), "1, 9, F, T");
            this.addCoverComp(this.textToVoiceNumber, Utils._("Voice number:"), "1, 11, F, T");
            this.addCoverComp(this.textSubject, Utils._("Subject:"), "1, 13, F, T");
            this.addCoverComp(this.scrollToComments, Utils._("Comments:"), "1, 15");
            this.enableCoverComps(faxOptions.useCover);
        }
        return this.paneCover;
    }

    private JPanel getPaneCommon() {
        if (this.paneCommon == null) {
            double[][] dArrayArray = new double[][]{{10.0, 0.5, 10.0, 0.5, 10.0}, new double[14]};
            double d = 1.0 / (double)(dArrayArray[1].length - 1);
            dArrayArray[1][0] = 10.0;
            dArrayArray[1][dArrayArray[1].length - 1] = 10.0;
            dArrayArray[1][1] = -2.0;
            Arrays.fill(dArrayArray[1], 2, dArrayArray[1].length - 2, d);
            double d2 = 2.0 * d;
            dArrayArray[1][6] = d2;
            dArrayArray[1][3] = d2;
            dArrayArray[1][dArrayArray[1].length - 2] = -1.0;
            this.paneCommon = new JPanel(new TableLayout(dArrayArray));
            this.tflFiles = new TextFieldList<HylaTFLItem>(this.getFtfFilename().getJTextField(), true, this.sendController.getFiles()){

                @Override
                protected HylaTFLItem createListItem(String string) {
                    return new LocalFileTFLItem(string);
                }
            };
            this.tflFiles.addLocalComponent(this.getFtfFilename().getJButton());
            this.clpFiles = new ClipboardPopup();
            this.clpFiles.getPopupMenu().addSeparator();
            this.clpFiles.getPopupMenu().add(this.tflFiles.getModifyAction());
            this.clpFiles.getPopupMenu().add(this.tflFiles.getAddAction());
            this.getFtfFilename().getJTextField().addMouseListener(this.clpFiles);
            Utils.addWithLabel(this.paneCommon, (Component)this.getFtfFilename(), Utils._("File(s):"), "1, 2, 3, 2, F, C");
            this.paneCommon.add(this.tflFiles, "1, 3, 3, 3, F, F");
            Box box = Box.createHorizontalBox();
            this.textNumber = new JTextField();
            box.add(this.textNumber);
            JButton jButton = this.getButtonPhoneBook();
            box.add(jButton);
            Dimension dimension = jButton.getPreferredSize();
            Dimension dimension2 = this.textNumber.getPreferredSize();
            if (dimension2.height > dimension.height) {
                dimension.height = dimension2.height;
            } else {
                dimension2.height = dimension.height;
            }
            dimension2.width = Integer.MAX_VALUE;
            jButton.setMaximumSize(dimension);
            this.textNumber.setMaximumSize(dimension2);
            ArrayList arrayList = new ArrayList();
            List<PBEntryFieldContainer> list = Collections.unmodifiableList(arrayList);
            this.sendController.setNumbers(list);
            this.tflNumbers = new TextFieldList<NumberTFLItem>(this.textNumber, false, arrayList){

                @Override
                protected NumberTFLItem createListItem(String string) {
                    NumberTFLItem numberTFLItem = new NumberTFLItem(string);
                    if (!SendWin.this.pollMode) {
                        NumberTFLItem numberTFLItem2 = (NumberTFLItem)this.getList().getSelectedValue();
                        String string2 = SendWin.this.textToCompany.getText();
                        String string3 = SendWin.this.textToLocation.getText();
                        String string4 = SendWin.this.textToName.getText();
                        String string5 = SendWin.this.textToVoiceNumber.getText();
                        if (numberTFLItem2 != null && string2.equals(numberTFLItem2.fields.get(PBEntryField.Company)) && string3.equals(numberTFLItem2.fields.get(PBEntryField.Location)) && string4.equals(numberTFLItem2.fields.get(PBEntryField.Name)) && string5.equals(numberTFLItem2.fields.get(PBEntryField.VoiceNumber))) {
                            string2 = "";
                            string3 = "";
                            string4 = "";
                            string5 = "";
                        }
                        numberTFLItem.fields.put(PBEntryField.Company, string2);
                        numberTFLItem.fields.put(PBEntryField.Location, string3);
                        numberTFLItem.fields.put(PBEntryField.Name, string4);
                        numberTFLItem.fields.put(PBEntryField.VoiceNumber, string5);
                    }
                    return numberTFLItem;
                }

                @Override
                protected void commitChanges(TFLItem tFLItem) {
                    if (!SendWin.this.pollMode) {
                        NumberTFLItem numberTFLItem = (NumberTFLItem)tFLItem;
                        numberTFLItem.fields.put(PBEntryField.Company, SendWin.this.textToCompany.getText());
                        numberTFLItem.fields.put(PBEntryField.Location, SendWin.this.textToLocation.getText());
                        numberTFLItem.fields.put(PBEntryField.Name, SendWin.this.textToName.getText());
                        numberTFLItem.fields.put(PBEntryField.VoiceNumber, SendWin.this.textToVoiceNumber.getText());
                    }
                    super.commitChanges(tFLItem);
                }

                @Override
                protected void displayItem(TFLItem tFLItem) {
                    if (!SendWin.this.pollMode) {
                        NumberTFLItem numberTFLItem = (NumberTFLItem)tFLItem;
                        SendWin.this.textToCompany.setText((String)numberTFLItem.fields.get(PBEntryField.Company));
                        SendWin.this.textToLocation.setText((String)numberTFLItem.fields.get(PBEntryField.Location));
                        SendWin.this.textToName.setText((String)numberTFLItem.fields.get(PBEntryField.Name));
                        SendWin.this.textToVoiceNumber.setText((String)numberTFLItem.fields.get(PBEntryField.VoiceNumber));
                    }
                    super.displayItem(tFLItem);
                }
            };
            this.tflNumbers.addLocalComponent(jButton);
            this.clpNumbers = new ClipboardPopup();
            this.clpNumbers.getPopupMenu().addSeparator();
            this.clpNumbers.getPopupMenu().add(this.tflNumbers.getModifyAction());
            this.clpNumbers.getPopupMenu().add(this.tflNumbers.getAddAction());
            this.textNumber.addMouseListener(this.clpNumbers);
            this.comboNotification = new JComboBox<FaxNotification>(FaxNotification.values());
            this.comboNotification.setRenderer(new IconMap.ListCellRenderer());
            this.comboPaperSize = new JComboBox<PaperSize>(PaperSize.values());
            this.comboResolution = new JComboBox<FaxResolution>(FaxResolution.values());
            this.spinKillTime = new JSpinner(new SpinnerNumberModel(180, 0, 142560, 15));
            this.spinMaxTries = new JSpinner(new SpinnerNumberModel(12, 1, 100, 1));
            this.comboModem = new JComboBox<Object>(this.server.getClientManager().getModems().toArray());
            this.comboModem.setEditable(true);
            Utils.addWithLabel(this.paneCommon, (Component)box, Utils._("Fax number(s):"), "1, 5, 3, 5, F, C");
            this.paneCommon.add(this.tflNumbers, "1, 6, 3, 6, F, F");
            Utils.addWithLabel(this.paneCommon, (Component)this.comboNotification, Utils._("Notify when:"), "1, 8, 1, 8, F, C");
            Utils.addWithLabel(this.paneCommon, (Component)this.comboModem, Utils._("Modem:"), "3, 8, F, C");
            Utils.addWithLabel(this.paneCommon, (Component)this.comboResolution, Utils._("Resolution:"), "1, 10, F, C");
            Utils.addWithLabel(this.paneCommon, (Component)this.comboPaperSize, Utils._("Paper size:"), "3, 10, F, C");
            Utils.addWithLabel(this.paneCommon, (Component)this.spinKillTime, Utils._("Cancel job after (minutes):"), "1, 12, F, C");
            Utils.addWithLabel(this.paneCommon, (Component)this.spinMaxTries, Utils._("Maximum tries:"), "3, 12, F, C");
        }
        return this.paneCommon;
    }

    private JTabbedPane getTabMain() {
        if (this.tabMain == null) {
            this.tabMain = new JTabbedPane(3);
            this.tabMain.addTab(Utils._("General"), this.getPaneCommon());
            this.tabMain.addTab(Utils._("Cover page"), this.getPaneCover());
        }
        return this.tabMain;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            double[][] dArrayArray = new double[][]{{-1.0, 10.0, SendWin.buttonSize.width, 10.0}, {10.0, SendWin.buttonSize.height, 10.0, SendWin.buttonSize.height, 10.0, SendWin.buttonSize.height, -1.0, 10.0}};
            this.jContentPane = new JPanel(new TableLayout(dArrayArray));
            if (this.pollMode) {
                this.jContentPane.add((Component)this.getButtonSend(), "2, 1");
                this.jContentPane.add((Component)this.getButtonCancel(), "2, 3");
                this.jContentPane.add((Component)this.getPaneCommon(), "0, 0, 0, 7");
                this.jContentPane.add((Component)new JSeparator(1), "1, 0, 1, 7, L, F");
            } else {
                this.jContentPane.add((Component)this.getButtonSend(), "2, 1");
                this.jContentPane.add((Component)this.getButtonPreview(), "2, 3");
                this.jContentPane.add((Component)this.getButtonCancel(), "2, 5");
                this.jContentPane.add((Component)this.getTabMain(), "0, 0, 0, 7");
            }
        }
        return this.jContentPane;
    }

    private JButton getButtonSend() {
        ExcDialogAbstractAction excDialogAbstractAction = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                SendWin.this.saveSettingsToSendController();
                if (SendWin.this.sendController.validateEntries()) {
                    SendWin.this.sendController.sendFax();
                    SendWin.this.modalResult = true;
                }
            }
        };
        if (this.pollMode) {
            excDialogAbstractAction.putValue("Name", Utils._("Poll"));
            excDialogAbstractAction.putValue("SmallIcon", Utils.loadIcon("general/Import"));
        } else {
            excDialogAbstractAction.putValue("Name", Utils._("Send"));
            excDialogAbstractAction.putValue("SmallIcon", Utils.loadIcon("general/SendMail"));
        }
        JButton jButton = new JButton(excDialogAbstractAction);
        return jButton;
    }

    private JButton getButtonCancel() {
        if (this.buttonCancel == null) {
            CancelAction cancelAction = new CancelAction(this);
            this.buttonCancel = cancelAction.createCancelButton();
        }
        return this.buttonCancel;
    }

    private JButton getButtonPreview() {
        ExcDialogAbstractAction excDialogAbstractAction = new ExcDialogAbstractAction(Utils._("Preview"), Utils.loadIcon("general/PrintPreview")){

            public void actualActionPerformed(ActionEvent actionEvent) {
                SendWin.this.saveSettingsToSendController();
                if (!SendWin.this.checkUseCover.isSelected() && SendWin.this.tflFiles.model.getSize() == 0) {
                    JOptionPane.showMessageDialog(SendWin.this, Utils._("Nothing to preview! (Neither a cover page nor a file to send has been selected.)"), Utils._("Preview"), 1);
                    return;
                }
                SendWin.this.sendController.previewFax((NumberTFLItem)SendWin.this.tflNumbers.list.getSelectedValue());
            }
        };
        JButton jButton = new JButton(excDialogAbstractAction);
        return jButton;
    }

    private FileTextField getFtfFilename() {
        if (this.ftfFilename == null) {
            this.ftfFilename = new FileTextField(){

                protected void writeTextFieldFileName(String string) {
                    super.writeTextFieldFileName(string);
                    SendWin.this.tflFiles.addListItem(string);
                    Utils.getFaxOptions().lastSendWinPath = this.getCurrentDirectory().getPath();
                }
            };
            this.ftfFilename.setFileFilters(FileConverters.getConvertableFileFilters());
            if (Utils.getFaxOptions().lastSendWinPath.length() > 0) {
                this.ftfFilename.setCurrentDirectory(new File(Utils.getFaxOptions().lastSendWinPath));
            }
        }
        return this.ftfFilename;
    }

    private JButton getButtonPhoneBook() {
        ExcDialogAbstractAction excDialogAbstractAction = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Utils.setWaitCursor(SendWin.this);
                NewPhoneBookWin newPhoneBookWin = new NewPhoneBookWin(SendWin.this);
                Utils.unsetWaitCursorOnOpen(SendWin.this, newPhoneBookWin);
                List<PhoneBookEntry> list = newPhoneBookWin.selectNumbers();
                if (list != null) {
                    for (PhoneBookEntry phoneBookEntry : list) {
                        NumberTFLItem numberTFLItem = new NumberTFLItem(phoneBookEntry);
                        SendWin.this.tflNumbers.addListItem(numberTFLItem);
                    }
                }
            }
        };
        excDialogAbstractAction.putValue("SmallIcon", Utils.loadIcon("general/Bookmarks"));
        excDialogAbstractAction.putValue("ShortDescription", Utils._("Choose number from phone book"));
        JButton jButton = new JButton(excDialogAbstractAction);
        return jButton;
    }

    private ClipboardPopup getDefClPop() {
        return ClipboardPopup.DEFAULT_POPUP;
    }

    @Override
    public Collection<PBEntryFieldContainer> getRecipients() {
        if (this.recipientList == null) {
            this.recipientList = new AbstractList<PBEntryFieldContainer>(){

                @Override
                public PBEntryFieldContainer get(int n) {
                    return SendWin.this.sendController.getNumbers().get(n);
                }

                @Override
                public int size() {
                    return SendWin.this.sendController.getNumbers().size();
                }

                @Override
                public boolean add(PBEntryFieldContainer pBEntryFieldContainer) {
                    NumberTFLItem numberTFLItem = new NumberTFLItem(pBEntryFieldContainer);
                    SendWin.this.tflNumbers.addListItem(numberTFLItem);
                    return true;
                }
            };
        }
        return this.recipientList;
    }

    @Override
    public void setSubject(String string) {
        this.textSubject.setText(string);
    }

    @Override
    public void setModem(String string) {
        Object object = string;
        for (HylaModem hylaModem : this.server.getClientManager().getModems()) {
            if (!hylaModem.getInternalName().equals(string)) continue;
            object = hylaModem;
            break;
        }
        this.comboModem.setSelectedItem(object);
    }

    protected void saveSettingsToSendController() {
        this.tflFiles.commit();
        this.tflNumbers.commit();
        if (this.textToComments != null) {
            this.sendController.setComment(this.textToComments.getText());
        }
        this.sendController.setKillTime((Integer)this.spinKillTime.getValue());
        this.sendController.setMaxTries((Integer)this.spinMaxTries.getValue());
        this.sendController.setNotificationType((FaxNotification)this.comboNotification.getSelectedItem());
        this.sendController.setPaperSize((PaperSize)((Object)this.comboPaperSize.getSelectedItem()));
        this.sendController.setResolution((FaxResolution)((Object)this.comboResolution.getSelectedItem()));
        this.sendController.setSelectedModem(this.comboModem.getSelectedItem());
        if (this.textSubject != null) {
            this.sendController.setSubject(this.textSubject.getText());
        }
        if (this.checkUseCover != null && this.checkUseCover.isSelected()) {
            this.sendController.setUseCover(true);
            this.sendController.setCustomCover(this.checkCustomCover.isSelected() ? new File(this.ftfCustomCover.getText()) : null);
        } else {
            this.sendController.setUseCover(false);
            this.sendController.setCustomCover(null);
        }
    }

    @Override
    public Window getWindow() {
        return this;
    }

    @Override
    public void setComment(String string) {
        this.textToComments.setText(string);
    }

    @Override
    public void setUseCover(boolean bl) {
        this.checkUseCover.setSelected(bl);
    }

    @Override
    public boolean isPollMode() {
        return this.pollMode;
    }

    @Override
    public Collection<HylaTFLItem> getDocuments() {
        return this.tflFiles.model;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
        this.sendController.setServer(server);
    }

    @Override
    public void setIdentity(SenderIdentity senderIdentity) {
        this.sendController.setIdentity(senderIdentity);
    }
}

