/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.send;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import yajhfc.FaxNotification;
import yajhfc.FaxOptions;
import yajhfc.FaxResolution;
import yajhfc.FileTextField;
import yajhfc.HylaModem;
import yajhfc.PaperSize;
import yajhfc.SenderIdentity;
import yajhfc.Utils;
import yajhfc.faxcover.Faxcover;
import yajhfc.file.FileConverters;
import yajhfc.file.FormattedFile;
import yajhfc.file.textextract.FaxnumberExtractor;
import yajhfc.model.IconMap;
import yajhfc.model.servconn.FaxListConnectionType;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.convrules.DefaultPBEntryFieldContainer;
import yajhfc.phonebook.convrules.PBEntryFieldContainer;
import yajhfc.phonebook.ui.NewPhoneBookWin;
import yajhfc.phonebook.ui.PBEntryFieldTableModel;
import yajhfc.send.HylaTFLItem;
import yajhfc.send.JobPropsEditorDialog;
import yajhfc.send.LocalFileTFLItem;
import yajhfc.send.SendController;
import yajhfc.send.SendControllerListener;
import yajhfc.send.SendWinControl;
import yajhfc.send.TextFieldList;
import yajhfc.send.TimeToSendEntry;
import yajhfc.server.Server;
import yajhfc.server.ServerManager;
import yajhfc.server.ServerOptions;
import yajhfc.util.AsyncComboBoxOrListModel;
import yajhfc.util.CancelAction;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ExampleFileFilter;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.JTableTABAction;
import yajhfc.util.ListComboModel;
import yajhfc.util.ProgressPanel;
import yajhfc.util.ProgressWorker;
import yajhfc.util.SafeJFileChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SimplifiedSendDialog
extends JDialog
implements SendWinControl {
    protected static final int FAXNUMBER_LRU_COUNT = 10;
    static final Logger log = Logger.getLogger(SimplifiedSendDialog.class.getName());
    Server server;
    SendController sendController;
    protected JPanel contentPane;
    protected JPanel advancedPane;
    protected ProgressPanel progressPanel;
    protected JButton buttonCancel;
    protected FileTextField ftfFileName;
    protected TextFieldList<HylaTFLItem> tflFiles;
    protected JButton buttonAdvanced;
    protected JTable tableNumbers;
    protected PBEntryFieldTableModel numberTableModel;
    protected JComboBox comboNumber;
    protected ListComboModel<String> comboNumberModel;
    protected Action actSend;
    protected Action actPreview;
    protected Action actPhonebook;
    protected Action actFromFile;
    protected JButton buttonCustomProps;
    protected JComboBox comboResolution;
    protected JComboBox comboPaperSize;
    protected JComboBox comboNotification;
    protected JComboBox comboModem;
    protected JComboBox comboIdentity;
    protected JLabel labelServer;
    protected JComboBox comboServer;
    protected JSpinner spinKillTime;
    protected JSpinner spinMaxTries;
    protected JTextField textSubject;
    protected JTextArea textComments;
    protected JCheckBox checkUseCover;
    protected JCheckBox checkCustomCover;
    protected JCheckBox checkArchiveJob;
    protected FileTextField ftfCustomCover;
    protected TimeToSendEntry ttsEntry;
    protected Action actAddNumber;
    protected Action actRemoveNumber;
    protected Action actCustomProps;
    protected AsyncComboBoxOrListModel<HylaModem> modemModel;
    protected String modemToSet;
    protected boolean isAdvancedView = false;
    protected boolean initiallyHideFiles = false;
    protected boolean modalResult = false;
    protected boolean identitySelectedByUser = false;
    private static final int border = 10;
    private static final String ADVANCED_TEXT = Utils._(">> Advanced");
    private static final String SIMPLIFIED_TEXT = Utils._("<< Simplified");
    private List<PBEntryFieldContainer> recipientList;

    public SimplifiedSendDialog(Server server, Frame frame, boolean bl) throws HeadlessException {
        super(frame, Utils._("Send fax"), true);
        this.server = server;
        this.initiallyHideFiles = bl;
        this.initialize();
    }

    @Override
    public boolean getModalResult() {
        return this.modalResult;
    }

    @Override
    public Window getWindow() {
        return this;
    }

    private void initialize() {
        this.sendController = new SendController(this.server, this, false);
        this.setContentPane(this.createContentPane());
        this.setSize(640, this.initiallyHideFiles ? 400 : 480);
        this.createAdvancedPane();
        this.setAdvancedView(Utils.getFaxOptions().sendWinIsAdvanced);
        this.sendController.setProgressMonitor(this.progressPanel);
        this.sendController.addSendControllerListener(new SendControllerListener(){

            public void sendOperationComplete(boolean bl) {
                if (bl) {
                    SimplifiedSendDialog.this.dispose();
                } else {
                    SimplifiedSendDialog.this.actSend.setEnabled(true);
                    SimplifiedSendDialog.this.setEnabled(true);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                FaxOptions faxOptions = Utils.getFaxOptions();
                faxOptions.sendWinBounds = SimplifiedSendDialog.this.getBounds();
                faxOptions.sendWinIsAdvanced = SimplifiedSendDialog.this.isAdvancedView;
                List<String> list = faxOptions.faxNumbersLRU;
                list.clear();
                list.addAll(SimplifiedSendDialog.this.comboNumberModel.getList());
            }
        });
        if (Utils.getFaxOptions().sendWinBounds != null) {
            this.setBounds(Utils.getFaxOptions().sendWinBounds);
        } else {
            Utils.setDefWinPos(this);
        }
        this.enableCoverComps(Utils.getFaxOptions().useCover);
        this.setDefaultCloseOperation(2);
    }

    protected JComponent createContentPane() {
        double d = this.initiallyHideFiles ? 0.5 : 0.3333333333333333;
        double[][] dArrayArray = new double[][]{{10.0, -1.0, 10.0, -2.0, 10.0}, {10.0, this.initiallyHideFiles ? 0.0 : d, this.initiallyHideFiles ? 0.0 : 10.0, -1.0, 10.0, -2.0, 10.0, -2.0, -2.0, -2.0, d * 0.5, 10.0, -2.0, 10.0}};
        this.progressPanel = new ProgressPanel();
        this.contentPane = new JPanel(new TableLayout(dArrayArray));
        this.actSend = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                SimplifiedSendDialog.this.saveSettingsToSendController();
                if (SimplifiedSendDialog.this.sendController.validateEntries()) {
                    SimplifiedSendDialog.this.sendController.sendFax();
                    SimplifiedSendDialog.this.actSend.setEnabled(false);
                    SimplifiedSendDialog.this.setEnabled(false);
                    SimplifiedSendDialog.this.modalResult = true;
                }
            }
        };
        this.actSend.putValue("Name", Utils._("Send"));
        this.actSend.putValue("SmallIcon", Utils.loadIcon("general/SendMail"));
        JButton jButton = new JButton(this.actSend);
        this.actPreview = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                SimplifiedSendDialog.this.saveSettingsToSendController();
                boolean bl = SimplifiedSendDialog.this.checkUseCover.isSelected();
                if (SimplifiedSendDialog.this.tflFiles.model.getSize() == 0 && (!bl || bl && SimplifiedSendDialog.this.sendController.getNumbers().size() == 0)) {
                    JOptionPane.showMessageDialog(SimplifiedSendDialog.this, Utils._("Nothing to preview! (Neither a cover page nor a file to send has been selected.)"), Utils._("Preview"), 1);
                    return;
                }
                int n = SimplifiedSendDialog.this.tableNumbers.getSelectedRow();
                PBEntryFieldContainer pBEntryFieldContainer = n < 0 ? (SimplifiedSendDialog.this.sendController.getNumbers().size() > 0 ? SimplifiedSendDialog.this.sendController.getNumbers().get(0) : null) : SimplifiedSendDialog.this.sendController.getNumbers().get(n);
                SimplifiedSendDialog.this.sendController.previewFax(pBEntryFieldContainer);
            }
        };
        this.actPreview.putValue("Name", Utils._("Preview"));
        this.actPreview.putValue("SmallIcon", Utils.loadIcon("general/PrintPreview"));
        JButton jButton2 = new JButton(this.actPreview);
        this.actCustomProps = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                JobPropsEditorDialog jobPropsEditorDialog = new JobPropsEditorDialog((Dialog)SimplifiedSendDialog.this, SimplifiedSendDialog.this.sendController.getCustomProperties());
                jobPropsEditorDialog.setVisible(true);
            }
        };
        this.actCustomProps.putValue("Name", Utils._("Job properties") + "...");
        this.buttonCustomProps = new JButton(this.actCustomProps);
        this.buttonCustomProps.setVisible(false);
        CancelAction cancelAction = new CancelAction(this);
        this.buttonCancel = cancelAction.createCancelButton();
        this.buttonAdvanced = new JButton(SIMPLIFIED_TEXT);
        Dimension dimension = this.buttonAdvanced.getPreferredSize();
        this.buttonAdvanced.setText(ADVANCED_TEXT);
        Dimension dimension2 = this.buttonAdvanced.getPreferredSize();
        this.buttonAdvanced.setPreferredSize(new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height)));
        this.buttonAdvanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimplifiedSendDialog.this.setAdvancedView(!SimplifiedSendDialog.this.isAdvancedView);
            }
        });
        this.comboIdentity = new JComboBox<SenderIdentity>(new ListComboModel<SenderIdentity>(Utils.getFaxOptions().identities));
        this.comboIdentity.setSelectedItem(this.sendController.fromIdentity);
        this.comboIdentity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimplifiedSendDialog.this.identitySelectedByUser = true;
            }
        });
        this.comboServer = new JComboBox<Server>(new ListComboModel<Server>(ServerManager.getDefault().getServers()));
        this.comboServer.setSelectedItem(this.server);
        this.comboServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimplifiedSendDialog.this.setServer((Server)SimplifiedSendDialog.this.comboServer.getSelectedItem());
            }
        });
        JPanel jPanel = new JPanel(new TableLayout(new double[][]{{-1.0}, {-2.0, 10.0, -2.0, 10.0, -2.0, -1.0, -2.0, 10.0, -2.0, -2.0, 10.0, -2.0, -2.0, 10.0, -2.0, 10.0}}), false);
        jPanel.add((Component)jButton, "0,0");
        jPanel.add((Component)jButton2, "0,2");
        jPanel.add((Component)this.buttonCancel, "0,4");
        jPanel.add((Component)this.buttonCustomProps, "0,6");
        this.labelServer = Utils.addWithLabel(jPanel, (Component)this.comboServer, Utils._("Server") + ':', "0,9");
        Utils.addWithLabel(jPanel, (Component)this.comboIdentity, Utils._("Identity") + ':', "0,12");
        jPanel.add((Component)this.buttonAdvanced, "0,14");
        this.comboServer.setVisible(false);
        this.labelServer.setVisible(false);
        this.checkUseCover = new JCheckBox(Utils._("Use cover page"));
        this.checkUseCover.setSelected(Utils.getFaxOptions().useCover);
        this.checkUseCover.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimplifiedSendDialog.this.enableCoverComps(SimplifiedSendDialog.this.checkUseCover.isSelected());
            }
        });
        this.textSubject = new JTextField();
        this.textSubject.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textComments = new JTextArea();
        this.textComments.setWrapStyleWord(true);
        this.textComments.setLineWrap(true);
        this.textComments.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        JScrollPane jScrollPane = new JScrollPane(this.textComments, 22, 31);
        if (!this.initiallyHideFiles) {
            this.contentPane.add(this.createFileEntryList(), "1,1, f, f");
        }
        this.contentPane.add(this.createNumberEntryList(), "1,3, f, f");
        this.contentPane.add((Component)this.checkUseCover, "1,5");
        Utils.addWithLabel(this.contentPane, (Component)this.textSubject, Utils._("Subject:"), "1,8");
        Utils.addWithLabel(this.contentPane, (Component)jScrollPane, Utils._("Comments:"), "1,10");
        this.contentPane.add((Component)jPanel, "3,1,3,12,f,f");
        this.progressPanel.setContentComponent(this.contentPane);
        return this.progressPanel;
    }

    void extractRecipientsFor(final HylaTFLItem hylaTFLItem) {
        ProgressWorker progressWorker = new ProgressWorker(){
            private Set<String> numbers;
            private Set<String> subjects;

            public void doWork() {
                try {
                    this.updateNote(Utils._("Extracting recipients..."));
                    FaxnumberExtractor faxnumberExtractor = new FaxnumberExtractor(FaxnumberExtractor.getDefaultPattern(), FaxnumberExtractor.getDefaultSubjectPattern());
                    this.numbers = new TreeSet<String>();
                    this.subjects = new TreeSet<String>();
                    faxnumberExtractor.extractFromMultipleDocuments(Collections.singleton(hylaTFLItem), this.numbers, this.subjects);
                }
                catch (Exception exception) {
                    this.showExceptionDialog(Utils._("Error extracting recipients"), exception);
                    this.numbers = null;
                }
            }

            protected void done() {
                if (this.numbers != null) {
                    for (String string : this.numbers) {
                        DefaultPBEntryFieldContainer defaultPBEntryFieldContainer = new DefaultPBEntryFieldContainer("");
                        defaultPBEntryFieldContainer.setField(PBEntryField.FaxNumber, string);
                        SimplifiedSendDialog.this.getRecipients().add(defaultPBEntryFieldContainer);
                    }
                }
                if (this.subjects != null && this.subjects.size() >= 1) {
                    SimplifiedSendDialog.this.textSubject.setText(this.subjects.iterator().next());
                }
            }
        };
        progressWorker.setProgressMonitor(this.progressPanel);
        progressWorker.startWork(this, Utils._("Extracting recipients..."));
    }

    protected Component createFileEntryList() {
        Box box = Box.createVerticalBox();
        this.ftfFileName = new FileTextField(){

            protected void configureFileChooser(JFileChooser jFileChooser) {
                super.configureFileChooser(jFileChooser);
                jFileChooser.setMultiSelectionEnabled(true);
            }

            protected void handleUserSelection(JFileChooser jFileChooser) {
                File[] fileArray;
                for (File file : fileArray = jFileChooser.getSelectedFiles()) {
                    SimplifiedSendDialog.this.tflFiles.addListItem(file.getPath());
                }
                Utils.getFaxOptions().lastSendWinPath = jFileChooser.getCurrentDirectory().getPath();
                if (fileArray.length == 1) {
                    this.writeTextFieldFileName(fileArray[0].getPath());
                } else {
                    this.writeTextFieldFileName("");
                }
            }
        };
        this.ftfFileName.setFileFilters(FileConverters.getConvertableFileFilters());
        if (Utils.getFaxOptions().lastSendWinPath.length() > 0) {
            this.ftfFileName.setCurrentDirectory(new File(Utils.getFaxOptions().lastSendWinPath));
        }
        this.tflFiles = new TextFieldList<HylaTFLItem>(this.ftfFileName.getJTextField(), true, this.sendController.getFiles()){

            @Override
            protected HylaTFLItem createListItem(String string) {
                LocalFileTFLItem localFileTFLItem = new LocalFileTFLItem(string);
                switch (Utils.getFaxOptions().extractRecipients) {
                    case AUTO: 
                    case YES: {
                        SimplifiedSendDialog.this.extractRecipientsFor(localFileTFLItem);
                        break;
                    }
                }
                return localFileTFLItem;
            }
        };
        this.tflFiles.addLocalComponent(this.ftfFileName.getJButton());
        SaveAsOriginalAction.installOn(this.tflFiles);
        ClipboardPopup clipboardPopup = new ClipboardPopup();
        clipboardPopup.getPopupMenu().addSeparator();
        clipboardPopup.getPopupMenu().add(this.tflFiles.getModifyAction());
        clipboardPopup.getPopupMenu().add(this.tflFiles.getAddAction());
        this.ftfFileName.getJTextField().addMouseListener(clipboardPopup);
        JLabel jLabel = new JLabel(Utils._("File(s) to send:"));
        jLabel.setAlignmentX(0.0f);
        this.ftfFileName.setAlignmentX(0.0f);
        this.tflFiles.setAlignmentX(0.0f);
        box.add(jLabel);
        box.add(this.ftfFileName);
        box.add(this.tflFiles);
        return box;
    }

    protected Component createNumberEntryList() {
        double[][] dArrayArray = new double[][]{{-1.0, -2.0}, {-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -1.0}};
        JPanel jPanel = new JPanel(new TableLayout(dArrayArray), false);
        this.actPhonebook = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                Utils.setWaitCursor(SimplifiedSendDialog.this);
                NewPhoneBookWin newPhoneBookWin = new NewPhoneBookWin(SimplifiedSendDialog.this);
                Utils.unsetWaitCursorOnOpen(SimplifiedSendDialog.this, newPhoneBookWin);
                List<PhoneBookEntry> list = newPhoneBookWin.selectNumbers();
                if (list != null) {
                    for (PhoneBookEntry phoneBookEntry : list) {
                        SimplifiedSendDialog.this.numberTableModel.addRow(new DefaultPBEntryFieldContainer(phoneBookEntry));
                    }
                }
            }
        };
        this.actPhonebook.putValue("Name", Utils._("Add from phone book..."));
        this.actPhonebook.putValue("ShortDescription", Utils._("Choose number from phone book"));
        this.actPhonebook.putValue("SmallIcon", Utils.loadIcon("general/Bookmarks"));
        JButton jButton = new JButton(this.actPhonebook);
        jButton.setText("");
        this.actAddNumber = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                int n;
                Object object = SimplifiedSendDialog.this.comboNumber.getSelectedItem();
                if (object == null) {
                    object = "";
                }
                DefaultPBEntryFieldContainer defaultPBEntryFieldContainer = new DefaultPBEntryFieldContainer("");
                String string = object.toString();
                defaultPBEntryFieldContainer.setField(PBEntryField.FaxNumber, string);
                SimplifiedSendDialog.this.numberTableModel.addRow(defaultPBEntryFieldContainer);
                if (string.length() > 0 && (n = SimplifiedSendDialog.this.comboNumberModel.getList().indexOf(string)) != 0) {
                    if (n >= 0) {
                        SimplifiedSendDialog.this.comboNumberModel.remove(n);
                    }
                    SimplifiedSendDialog.this.comboNumberModel.add(0, string);
                    if (SimplifiedSendDialog.this.comboNumberModel.getSize() > 10) {
                        SimplifiedSendDialog.this.comboNumberModel.remove(10);
                    }
                }
                SimplifiedSendDialog.this.comboNumber.setSelectedItem("");
            }
        };
        this.actAddNumber.putValue("Name", Utils._("Add"));
        this.actAddNumber.putValue("SmallIcon", Utils.loadIcon("general/Add"));
        this.actAddNumber.putValue("ShortDescription", Utils._("Add a new recipient"));
        JButton jButton2 = new JButton(this.actAddNumber);
        jButton2.setText("");
        this.actRemoveNumber = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                int[] nArray = SimplifiedSendDialog.this.tableNumbers.getSelectedRows();
                if (nArray.length >= 0) {
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        SimplifiedSendDialog.this.numberTableModel.removeRow(nArray[i]);
                    }
                    SimplifiedSendDialog.this.actRemoveNumber.setEnabled(false);
                }
            }
        };
        this.actRemoveNumber.putValue("Name", Utils._("Remove"));
        this.actRemoveNumber.putValue("SmallIcon", Utils.loadIcon("general/Delete"));
        this.actRemoveNumber.putValue("ShortDescription", Utils._("Remove selected recipient"));
        this.actRemoveNumber.setEnabled(false);
        JButton jButton3 = new JButton(this.actRemoveNumber);
        jButton3.setText("");
        this.actFromFile = new ExcDialogAbstractAction(){
            private JFileChooser chooser;

            protected void actualActionPerformed(ActionEvent actionEvent) {
                if (this.chooser == null) {
                    this.chooser = new SafeJFileChooser();
                }
                ExampleFileFilter exampleFileFilter = new ExampleFileFilter("txt", Utils._("Text files"));
                this.chooser.addChoosableFileFilter(exampleFileFilter);
                this.chooser.setFileFilter(exampleFileFilter);
                if (this.chooser.showOpenDialog(SimplifiedSendDialog.this) == 0) {
                    try {
                        DefaultPBEntryFieldContainer.readListFile(SimplifiedSendDialog.this.getRecipients(), this.chooser.getSelectedFile().getPath());
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog(SimplifiedSendDialog.this, Utils._("Error reading the specified file:"), exception);
                    }
                }
            }
        };
        this.actFromFile.putValue("Name", Utils._("Add from text file..."));
        this.actFromFile.putValue("SmallIcon", Utils.loadCustomIcon("importtxt.png"));
        this.actFromFile.putValue("ShortDescription", Utils._("Adds recipients from a text file containing one recipient per line"));
        JButton jButton4 = new JButton(this.actFromFile);
        jButton4.setText("");
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem(this.actAddNumber));
        jPopupMenu.add(new JMenuItem(this.actPhonebook));
        jPopupMenu.add(new JMenuItem(this.actFromFile));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(this.actRemoveNumber));
        this.numberTableModel = new PBEntryFieldTableModel(this.sendController.numbers);
        this.tableNumbers = new JTable(this.numberTableModel);
        this.tableNumbers.setSelectionMode(2);
        this.tableNumbers.setAutoResizeMode(0);
        JTableTABAction.wrapDefTabAction(this.tableNumbers);
        this.tableNumbers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SimplifiedSendDialog.this.actRemoveNumber.setEnabled(listSelectionEvent.getFirstIndex() >= 0);
                }
            }
        });
        this.tableNumbers.getActionMap().put("yajhfc-delete", this.actRemoveNumber);
        InputMap inputMap = this.tableNumbers.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "yajhfc-delete");
        Font font = this.tableNumbers.getFont().deriveFont(1);
        TableColumn tableColumn = this.tableNumbers.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new BoldCellRenderer(this.tableNumbers.getDefaultRenderer(String.class), font));
        tableColumn.setHeaderRenderer(new BoldCellRenderer(this.tableNumbers.getTableHeader().getDefaultRenderer(), font));
        JScrollPane jScrollPane = new JScrollPane(this.tableNumbers, 22, 30);
        this.tableNumbers.setComponentPopupMenu(jPopupMenu);
        jScrollPane.setComponentPopupMenu(jPopupMenu);
        ClipboardPopup clipboardPopup = new ClipboardPopup();
        clipboardPopup.getPopupMenu().addSeparator();
        clipboardPopup.getPopupMenu().add(this.actAddNumber);
        this.comboNumberModel = new ListComboModel(new ArrayList(11));
        this.comboNumberModel.addAll((Collection<String>)Utils.getFaxOptions().faxNumbersLRU);
        this.comboNumber = new JComboBox<String>(this.comboNumberModel);
        this.comboNumber.setEditable(true);
        this.comboNumber.setMaximumRowCount(10);
        JComponent jComponent = (JComponent)this.comboNumber.getEditor().getEditorComponent();
        jComponent.getActionMap().put("yajhfc-addnum", this.actAddNumber);
        jComponent.getInputMap().put(KeyStroke.getKeyStroke('\n'), "yajhfc-addnum");
        clipboardPopup.addToComponent(this.comboNumber);
        jPanel.add((Component)new JLabel(Utils._("Fax number:")), "0,0,1,0, f,f");
        jPanel.add((Component)this.comboNumber, "0,1");
        jPanel.add((Component)new JLabel(Utils._("Recipients:")), "0,2,1,2, f,f");
        jPanel.add((Component)jButton2, "1,1");
        jPanel.add((Component)jScrollPane, "0,3,0,6,f,f");
        jPanel.add((Component)jButton3, "1,3");
        jPanel.add((Component)jButton, "1,4");
        jPanel.add((Component)jButton4, "1,5");
        return jPanel;
    }

    protected JPanel createAdvancedPane() {
        double[] dArray = new double[16];
        dArray[0] = this.initiallyHideFiles ? -2.0 : 0.0;
        for (int i = 1; i < 16; ++i) {
            dArray[i] = i % 3 == 1 ? 5.0 : -2.0;
        }
        double[][] dArrayArray = new double[][]{{0.5, 10.0, -1.0}, dArray};
        this.advancedPane = new JPanel(new TableLayout(dArrayArray), false);
        FaxOptions faxOptions = Utils.getFaxOptions();
        this.checkCustomCover = new JCheckBox(Utils._("Use custom cover page:"));
        this.checkCustomCover.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimplifiedSendDialog.this.ftfCustomCover.setEnabled(SimplifiedSendDialog.this.checkCustomCover.isSelected() && SimplifiedSendDialog.this.checkCustomCover.isEnabled());
            }
        });
        this.checkCustomCover.setSelected(faxOptions.useCustomCover);
        this.ftfCustomCover = new FileTextField();
        this.ftfCustomCover.setFileFilters(Faxcover.getAcceptedFileFilters());
        if (faxOptions.CustomCover != null && faxOptions.CustomCover.length() > 0) {
            this.ftfCustomCover.setText(faxOptions.CustomCover);
        } else {
            this.ftfCustomCover.setText(this.server.getDefaultIdentity().defaultCover);
        }
        this.ftfCustomCover.getJTextField().addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.comboNotification = new JComboBox<FaxNotification>(FaxNotification.values());
        this.comboNotification.setRenderer(new IconMap.ListCellRenderer());
        this.comboPaperSize = new JComboBox<PaperSize>(PaperSize.values());
        this.comboResolution = new JComboBox<FaxResolution>(FaxResolution.values());
        this.spinKillTime = new JSpinner(new SpinnerNumberModel(180, 0, 142560, 15));
        this.spinMaxTries = new JSpinner(new SpinnerNumberModel(12, 1, 100, 1));
        this.modemToSet = this.server.getOptions().defaultModem;
        this.modemModel = new AsyncComboBoxOrListModel<HylaModem>(HylaModem.defaultModems, new Callable<List<HylaModem>>(){

            @Override
            public List<HylaModem> call() throws Exception {
                if (SimplifiedSendDialog.this.server.getOptions().faxListConnectionType == FaxListConnectionType.SRFAX) {
                    return null;
                }
                return SimplifiedSendDialog.this.server.getClientManager().getModems();
            }
        }, true, new Runnable(){

            public void run() {
                SimplifiedSendDialog.this.setModemInternal(SimplifiedSendDialog.this.modemToSet);
            }
        });
        this.comboModem = new JComboBox<HylaModem>(this.modemModel);
        this.comboModem.setEditable(true);
        this.comboModem.setSelectedItem(this.modemToSet);
        ClipboardPopup.DEFAULT_POPUP.addToComponent(this.comboModem);
        this.checkArchiveJob = new JCheckBox(Utils._("Archive fax job"));
        this.ttsEntry = new TimeToSendEntry();
        if (this.initiallyHideFiles) {
            this.advancedPane.add(this.createFileEntryList(), "0,0,2,0,f,f");
        }
        this.advancedPane.add((Component)this.checkCustomCover, "0,2,2,2,f,c");
        this.advancedPane.add((Component)this.ftfCustomCover, "0,3,2,3,f,c");
        Utils.addWithLabel(this.advancedPane, (Component)this.comboNotification, Utils._("Notify when:"), "0,6,F,C");
        Utils.addWithLabel(this.advancedPane, (Component)this.comboModem, Utils._("Modem:"), "2,6,,F,C");
        Utils.addWithLabel(this.advancedPane, (Component)this.comboResolution, Utils._("Resolution:"), "0,9,F,C");
        Utils.addWithLabel(this.advancedPane, (Component)this.comboPaperSize, Utils._("Paper size:"), "2,9,F,C");
        Utils.addWithLabel(this.advancedPane, (Component)this.spinKillTime, Utils._("Cancel job after (minutes):"), "0,12,F,C");
        Utils.addWithLabel(this.advancedPane, (Component)this.spinMaxTries, Utils._("Maximum tries:"), "2,12,F, C");
        Box box = Box.createHorizontalBox();
        this.ttsEntry.setAlignmentY(0.5f);
        this.checkArchiveJob.setAlignmentY(0.5f);
        box.add(this.ttsEntry);
        box.add(this.checkArchiveJob);
        Utils.addWithLabel(this.advancedPane, (Component)box, Utils._("Time to send:"), "0,15,2,15");
        this.intializeAdvancedPaneFromServerOptions(this.server.getOptions(), null);
        return this.advancedPane;
    }

    protected void intializeAdvancedPaneFromServerOptions(ServerOptions serverOptions, ServerOptions serverOptions2) {
        if (serverOptions2 == null || this.comboResolution.getSelectedItem() == serverOptions2.resolution) {
            this.comboResolution.setSelectedItem((Object)serverOptions.resolution);
        }
        if (serverOptions2 == null || this.comboPaperSize.getSelectedItem() == serverOptions2.paperSize) {
            this.comboPaperSize.setSelectedItem((Object)serverOptions.paperSize);
        }
        if (serverOptions2 == null || this.comboNotification.getSelectedItem() == serverOptions2.notifyWhen) {
            this.comboNotification.setSelectedItem(serverOptions.notifyWhen);
        }
        if (serverOptions2 == null || (Integer)this.spinMaxTries.getValue() == serverOptions2.maxTry) {
            this.spinMaxTries.setValue(serverOptions.maxTry);
        }
        if (serverOptions2 == null || (Integer)this.spinKillTime.getValue() == serverOptions2.killTime) {
            this.spinKillTime.setValue(serverOptions.killTime);
        }
        if (serverOptions2 == null || this.checkArchiveJob.isSelected() == serverOptions2.archiveSentFaxes) {
            this.checkArchiveJob.setSelected(serverOptions.archiveSentFaxes);
        }
    }

    protected void saveSettingsToSendController() {
        this.sendController.setServer(this.server);
        this.tflFiles.commit();
        Object object = this.comboNumber.getSelectedItem();
        if (object != null && !"".equals(object)) {
            this.actAddNumber.actionPerformed(null);
        }
        if (this.tableNumbers.isEditing()) {
            this.tableNumbers.getCellEditor().stopCellEditing();
        }
        this.sendController.setComment(this.textComments.getText());
        this.sendController.setKillTime((Integer)this.spinKillTime.getValue());
        this.sendController.setMaxTries((Integer)this.spinMaxTries.getValue());
        this.sendController.setNotificationType((FaxNotification)this.comboNotification.getSelectedItem());
        this.sendController.setPaperSize((PaperSize)((Object)this.comboPaperSize.getSelectedItem()));
        this.sendController.setResolution((FaxResolution)((Object)this.comboResolution.getSelectedItem()));
        this.sendController.setSelectedModem(this.comboModem.getSelectedItem());
        this.sendController.setSendTime(this.ttsEntry.getSelection());
        this.sendController.setArchiveJob(this.checkArchiveJob.isSelected());
        this.sendController.setSubject(this.textSubject.getText());
        this.sendController.setIdentity((SenderIdentity)this.comboIdentity.getSelectedItem());
        if (this.checkUseCover != null && this.checkUseCover.isSelected()) {
            this.sendController.setUseCover(true);
            this.sendController.setCustomCover(this.checkCustomCover.isSelected() ? new File(this.ftfCustomCover.getText()) : null);
        } else {
            this.sendController.setUseCover(false);
            this.sendController.setCustomCover(null);
        }
    }

    protected void setAdvancedView(boolean bl) {
        if (bl == this.isAdvancedView) {
            return;
        }
        this.isAdvancedView = bl;
        this.buttonCustomProps.setVisible(bl);
        this.labelServer.setVisible(bl);
        this.comboServer.setVisible(bl);
        if (bl) {
            this.buttonAdvanced.setText(SIMPLIFIED_TEXT);
            this.contentPane.add((Component)this.advancedPane, "1,12,f,f");
            Dimension dimension = this.getSize();
            dimension.height += this.advancedPane.getPreferredSize().height;
            this.setSize(dimension);
        } else {
            this.buttonAdvanced.setText(ADVANCED_TEXT);
            Dimension dimension = this.getSize();
            dimension.height -= this.advancedPane.getPreferredSize().height;
            this.contentPane.remove(this.advancedPane);
            this.setSize(dimension);
        }
        this.validate();
    }

    @Override
    public Collection<PBEntryFieldContainer> getRecipients() {
        if (this.recipientList == null) {
            this.recipientList = new AbstractList<PBEntryFieldContainer>(){

                @Override
                public PBEntryFieldContainer get(int n) {
                    return SimplifiedSendDialog.this.numberTableModel.getRow(n);
                }

                @Override
                public int size() {
                    return SimplifiedSendDialog.this.numberTableModel.getRowCount();
                }

                @Override
                public boolean add(PBEntryFieldContainer pBEntryFieldContainer) {
                    SimplifiedSendDialog.this.numberTableModel.addRow(new DefaultPBEntryFieldContainer(pBEntryFieldContainer));
                    return true;
                }

                @Override
                public PBEntryFieldContainer remove(int n) {
                    PBEntryFieldContainer pBEntryFieldContainer = SimplifiedSendDialog.this.numberTableModel.getRow(n);
                    SimplifiedSendDialog.this.numberTableModel.removeRow(n);
                    return pBEntryFieldContainer;
                }
            };
        }
        return this.recipientList;
    }

    @Override
    public void setSubject(String string) {
        this.textSubject.setText(string);
    }

    @Override
    public List<Long> getSubmittedJobIDs() {
        return this.sendController.getSubmittedJobIDs();
    }

    void enableCoverComps(boolean bl) {
        this.checkCustomCover.setEnabled(bl);
        this.ftfCustomCover.setEnabled(this.checkCustomCover.isSelected() && bl);
    }

    @Override
    public void setComment(String string) {
        this.textComments.setText(string);
    }

    @Override
    public void setUseCover(boolean bl) {
        this.checkUseCover.setSelected(bl);
    }

    protected void setModemInternal(String string) {
        Object object = string;
        for (HylaModem hylaModem : this.server.getClientManager().getModems()) {
            if (!hylaModem.getInternalName().equals(string)) continue;
            object = hylaModem;
            break;
        }
        this.comboModem.setSelectedItem(object);
    }

    @Override
    public void setModem(String string) {
        if (this.modemModel.hasFinished()) {
            this.setModemInternal(string);
        } else {
            this.modemToSet = string;
            this.comboModem.setSelectedItem(string);
        }
    }

    @Override
    public boolean isPollMode() {
        return false;
    }

    public void setIdentity(SenderIdentity senderIdentity, boolean bl) {
        this.comboIdentity.setSelectedItem(senderIdentity);
        this.identitySelectedByUser = bl;
    }

    public Server getServer() {
        return this.server;
    }

    @Override
    public void setServer(Server server) {
        if (this.server != server) {
            this.intializeAdvancedPaneFromServerOptions(server.getOptions(), this.server.getOptions());
            this.server = server;
            this.comboServer.setSelectedItem(server);
            this.modemModel.refreshListAsync();
            if (!this.identitySelectedByUser) {
                this.setIdentity(server.getDefaultIdentity(), false);
            }
        }
    }

    @Override
    public Collection<HylaTFLItem> getDocuments() {
        return this.tflFiles.model;
    }

    @Override
    public void setIdentity(SenderIdentity senderIdentity) {
        this.setIdentity(senderIdentity, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SaveAsOriginalAction
    extends ExcDialogAbstractAction
    implements ListSelectionListener {
        private final TextFieldList<? extends HylaTFLItem> target;

        @Override
        protected void actualActionPerformed(ActionEvent actionEvent) {
            HylaTFLItem hylaTFLItem = (HylaTFLItem)this.target.getList().getSelectedValue();
            if (hylaTFLItem == null) {
                return;
            }
            try {
                FormattedFile formattedFile = hylaTFLItem.getPreviewFilename();
                SafeJFileChooser safeJFileChooser = new SafeJFileChooser();
                safeJFileChooser.setSelectedFile(formattedFile.file);
                FileFilter fileFilter = formattedFile.getFormat().createFileFilter();
                safeJFileChooser.addChoosableFileFilter(fileFilter);
                safeJFileChooser.setFileFilter(fileFilter);
                if (safeJFileChooser.showSaveDialog(this.target) == 0) {
                    File file = safeJFileChooser.getSelectedFile();
                    Utils.copyFile(formattedFile.file, file);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog(this.target, Utils._("Error saving the file"), exception);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(this.target.getList().getSelectedIndex() >= 0);
        }

        private SaveAsOriginalAction(TextFieldList<? extends HylaTFLItem> textFieldList) {
            super(Utils._("Save a copy as..."), Utils.loadIcon("general/SaveAs"));
            this.target = textFieldList;
            this.setEnabled(false);
            textFieldList.getList().addListSelectionListener(this);
            textFieldList.getPopup().addSeparator();
            textFieldList.getPopup().add(this);
        }

        public static SaveAsOriginalAction installOn(TextFieldList<? extends HylaTFLItem> textFieldList) {
            return new SaveAsOriginalAction(textFieldList);
        }
    }

    protected static class BoldCellRenderer
    implements TableCellRenderer {
        protected TableCellRenderer wrapped;
        public Font boldFont;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.wrapped.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setFont(this.boldFont);
            return component;
        }

        public BoldCellRenderer(TableCellRenderer tableCellRenderer, Font font) {
            this.wrapped = tableCellRenderer;
            this.boldFont = font;
        }
    }
}

