/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.send;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import yajhfc.DateKind;
import yajhfc.Utils;
import yajhfc.file.FormattedFile;
import yajhfc.send.HylaTFLItem;
import yajhfc.shutdown.ShutdownManager;

public class StreamTFLItem
extends HylaTFLItem {
    protected FormattedFile tempFile;
    protected String text;

    public boolean equals(Object object) {
        return object == this;
    }

    public void cleanup() {
        this.tempFile.file.delete();
        this.tempFile = null;
    }

    public String getText() {
        return this.text;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isDeletable() {
        return true;
    }

    public FormattedFile getPreviewFilename() {
        return this.tempFile;
    }

    public void setText(String string) {
        throw new IllegalArgumentException("StreamTFLItem is immutable!");
    }

    public StreamTFLItem(InputStream inputStream, String string) throws IOException, FileNotFoundException {
        File file = File.createTempFile("submit", ".ps");
        ShutdownManager.deleteOnExit(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        Utils.copyStream(inputStream, fileOutputStream);
        fileOutputStream.close();
        this.tempFile = FormattedFile.getTempFileWithCorrectExtension(file);
        if (string == null) {
            string = Utils._("<stdin>");
        }
        this.text = string + " \u2013 " + DateKind.TIME_ONLY.getFormat().format(new Date());
    }
}

