/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.send;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import yajhfc.DateKind;
import yajhfc.Utils;
import yajhfc.send.MinutesFormatter;

public class TimeToSendEntry
extends JPanel {
    protected JComboBox comboTTSType;
    protected JSpinner spinMinutes;
    protected JFormattedTextField spinnerTextField;
    protected JFormattedTextField.AbstractFormatterFactory nowFactory = new DefaultFormatterFactory(new JFormattedTextField.AbstractFormatter(){

        public Object stringToValue(String string) throws ParseException {
            return new Date();
        }

        public String valueToString(Object object) throws ParseException {
            return Utils._("Now");
        }
    });
    protected JFormattedTextField.AbstractFormatterFactory dateFactory = new DefaultFormatterFactory(new DateFormatter(DateKind.getInstanceFromKind(DateKind.DATE_AND_TIME)));
    protected JFormattedTextField.AbstractFormatterFactory minutesFactory;
    protected long startTime;

    public Date getSelection() {
        switch (this.getTTSType()) {
            default: {
                return null;
            }
            case EXACT_TIME: {
                return (Date)this.spinMinutes.getValue();
            }
            case IN_MINUTES: 
        }
        return new Date(System.currentTimeMillis() - this.startTime + ((Date)this.spinMinutes.getValue()).getTime());
    }

    public TTSType getTTSType() {
        return (TTSType)((Object)this.comboTTSType.getSelectedItem());
    }

    public void setSelection(Date date) {
        this.configureForItem(TTSType.EXACT_TIME);
        this.comboTTSType.setSelectedItem((Object)TTSType.EXACT_TIME);
        this.spinMinutes.setValue(date);
    }

    void configureForItem(TTSType tTSType) {
        switch (tTSType) {
            case NOW: {
                this.spinMinutes.setEnabled(false);
                this.spinnerTextField.setFormatterFactory(this.nowFactory);
                break;
            }
            case IN_MINUTES: {
                this.spinMinutes.setEnabled(true);
                this.spinnerTextField.setFormatterFactory(this.minutesFactory);
                break;
            }
            case EXACT_TIME: {
                this.spinMinutes.setEnabled(true);
                this.spinnerTextField.setFormatterFactory(this.dateFactory);
            }
        }
    }

    public TimeToSendEntry() {
        super(false);
        this.setLayout(new BoxLayout(this, 0));
        this.comboTTSType = new JComboBox<TTSType>(TTSType.values());
        this.comboTTSType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TimeToSendEntry.this.configureForItem((TTSType)((Object)itemEvent.getItem()));
            }
        });
        this.startTime = (System.currentTimeMillis() + 30000L) / 60000L * 60000L;
        Date date = new Date(this.startTime);
        this.minutesFactory = new DefaultFormatterFactory(new MinutesFormatter(date));
        this.spinMinutes = new JSpinner(new SpinnerDateModel(date, date, null, 12));
        JSpinner.DefaultEditor defaultEditor = new JSpinner.DefaultEditor(this.spinMinutes);
        this.spinnerTextField = defaultEditor.getTextField();
        this.spinnerTextField.setEditable(true);
        this.spinMinutes.setEditor(defaultEditor);
        this.comboTTSType.setMaximumSize(this.comboTTSType.getPreferredSize());
        this.add(this.comboTTSType);
        this.add(Box.createRigidArea(new Dimension(6, 6)));
        this.add(this.spinMinutes);
        this.comboTTSType.setSelectedItem((Object)TTSType.NOW);
        this.spinMinutes.setEnabled(false);
        this.configureForItem(TTSType.NOW);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TTSType {
        NOW(Utils._("Now")),
        IN_MINUTES(Utils._("In (timespan)")),
        EXACT_TIME(Utils._("At (exact time)"));

        private final String description;

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description;
        }

        private TTSType(String string2) {
            this.description = string2;
        }
    }
}

